/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.carving;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import info.jbcs.minecraft.chisel.Chisel;
import info.jbcs.minecraft.chisel.block.BlockMarbleSlab;
import info.jbcs.minecraft.chisel.carving.CarvableVariation;
import info.jbcs.minecraft.chisel.carving.Carving;
import info.jbcs.minecraft.chisel.client.render.CTM;
import info.jbcs.minecraft.chisel.client.render.TextureSubmap;
import info.jbcs.minecraft.chisel.item.ItemCarvable;
import info.jbcs.minecraft.utilities.GeneralClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class CarvableHelper {
    static final String modName = "chisel";
    public static final ArrayList<Block> chiselBlocks = new ArrayList();
    public static final int NORMAL = 0;
    public static final int TOPSIDE = 1;
    public static final int TOPBOTSIDE = 2;
    public static final int CTM3 = 3;
    public static final int CTMV = 4;
    public static final int CTMH = 5;
    public static final int V9 = 6;
    public static final int V4 = 7;
    public static final int CTMX = 8;
    public ArrayList<CarvableVariation> variations = new ArrayList();
    CarvableVariation[] map = new CarvableVariation[16];
    public boolean forbidChiseling = false;
    public String blockName;

    public void addVariation(String description, int metadata, Block bb) {
        this.addVariation(description, metadata, null, bb, 0);
    }

    public void addVariation(String description, int metadata, Block bb, int blockMeta) {
        this.addVariation(description, metadata, null, bb, blockMeta);
    }

    public void addVariation(String description, int metadata, Block bb, int blockMeta, Material material) {
        this.addVariation(description, metadata, null, bb, blockMeta);
    }

    public void addVariation(String description, int metadata, String texture) {
        this.addVariation(description, metadata, texture, null, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addVariation(String description, int metadata, String texture, Block block, int blockMeta) {
        if (this.variations.size() >= 16) {
            return;
        }
        if (this.blockName == null && block != null) {
            this.blockName = block.func_149732_F();
        } else if (this.blockName == null && description != null) {
            this.blockName = description;
        }
        CarvableVariation variation = new CarvableVariation();
        variation.description = description;
        variation.metadata = metadata;
        variation.blockName = this.blockName;
        if (texture != null) {
            boolean ctmx;
            variation.texture = texture;
            String path = "/assets/chisel/textures/blocks/" + variation.texture;
            boolean any = Chisel.class.getResource(path + ".png") != null;
            boolean ctm3 = Chisel.class.getResource(path + "-ctm1.png") != null && Chisel.class.getResource(path + "-ctm2.png") != null && Chisel.class.getResource(path + "-ctm3.png") != null;
            boolean ctmv = Chisel.class.getResource(path + "-ctmv.png") != null;
            boolean ctmh = Chisel.class.getResource(path + "-ctmh.png") != null;
            boolean side = Chisel.class.getResource(path + "-side.png") != null;
            boolean top = Chisel.class.getResource(path + "-top.png") != null;
            boolean bot = Chisel.class.getResource(path + "-bottom.png") != null;
            boolean v9 = Chisel.class.getResource(path + "-v9.png") != null;
            boolean v4 = Chisel.class.getResource(path + "-v4.png") != null;
            boolean bl = ctmx = Chisel.class.getResource(path + "-ctm.png") != null;
            if (ctm3) {
                variation.kind = 3;
            } else if (ctmh && top) {
                variation.kind = 5;
            } else if (ctmv && top) {
                variation.kind = 4;
            } else if (bot && top && side) {
                variation.kind = 2;
            } else if (top && side) {
                variation.kind = 1;
            } else if (v9) {
                variation.kind = 6;
            } else if (v4) {
                variation.kind = 7;
            } else if (any && ctmx && !Chisel.disableCTM) {
                variation.kind = 8;
            } else {
                if (!any) throw new RuntimeException("No valid textures found for chisel block variation '" + description + "' (" + variation.texture + ")");
                variation.kind = 0;
            }
        } else {
            variation.block = block;
            variation.kind = 2;
            variation.blockMeta = blockMeta;
        }
        this.variations.add(variation);
        this.map[metadata] = variation;
    }

    public CarvableVariation getVariation(int metadata) {
        CarvableVariation variation;
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((variation = this.map[metadata]) == null) {
            return null;
        }
        return variation;
    }

    public IIcon getIcon(int side, int metadata) {
        CarvableVariation variation;
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((variation = this.map[metadata]) == null) {
            return GeneralClient.getMissingIcon();
        }
        switch (variation.kind) {
            case 0: {
                return variation.icon;
            }
            case 1: {
                if (side == 0 || side == 1) {
                    return variation.iconTop;
                }
                return variation.icon;
            }
            case 2: {
                if (side == 1) {
                    return variation.iconTop;
                }
                if (side == 0) {
                    return variation.iconBot;
                }
                return variation.icon;
            }
            case 3: {
                return variation.ctm.seams[0].icons[0];
            }
            case 4: {
                if (side < 2) {
                    return variation.iconTop;
                }
                return variation.seamsCtmVert.icons[0];
            }
            case 5: {
                if (side < 2) {
                    return variation.iconTop;
                }
                return variation.seamsCtmVert.icons[0];
            }
            case 6: {
                return variation.variations9.icons[4];
            }
            case 7: {
                return variation.variations9.icons[0];
            }
            case 8: {
                return variation.icon;
            }
        }
        return GeneralClient.getMissingIcon();
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        CarvableVariation variation;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata < 0 || metadata > 15) {
            metadata = 0;
        }
        if ((variation = this.map[metadata]) == null) {
            return GeneralClient.getMissingIcon();
        }
        switch (variation.kind) {
            case 0: 
            case 1: 
            case 2: {
                return this.getIcon(side, metadata);
            }
            case 3: {
                int tex = CTM.getTexture(world, x, y, z, side);
                int row = tex / 16;
                int col = tex % 16;
                return variation.ctm.seams[col / 4].icons[col % 4 + row * 4];
            }
            case 4: {
                boolean botConnected;
                if (side < 2) {
                    return variation.iconTop;
                }
                Block block = world.func_147439_a(x, y, z);
                boolean topConnected = block.equals(world.func_147439_a(x, y + 1, z)) && metadata == world.func_72805_g(x, y + 1, z);
                boolean bl = botConnected = block.equals(world.func_147439_a(x, y - 1, z)) && metadata == world.func_72805_g(x, y - 1, z);
                if (topConnected && botConnected) {
                    return variation.seamsCtmVert.icons[2];
                }
                if (topConnected && !botConnected) {
                    return variation.seamsCtmVert.icons[3];
                }
                if (!topConnected && botConnected) {
                    return variation.seamsCtmVert.icons[1];
                }
                return variation.seamsCtmVert.icons[0];
            }
            case 5: {
                boolean n;
                boolean p;
                boolean reverse;
                if (side < 2) {
                    return variation.iconTop;
                }
                Block block = world.func_147439_a(x, y, z);
                boolean bl = reverse = side == 2 || side == 4;
                if (side < 4) {
                    p = this.isSame(world, x - 1, y, z, block, metadata);
                    n = this.isSame(world, x + 1, y, z, block, metadata);
                } else {
                    p = this.isSame(world, x, y, z + 1, block, metadata);
                    n = this.isSame(world, x, y, z - 1, block, metadata);
                }
                if (p && n) {
                    return variation.seamsCtmVert.icons[1];
                }
                if (p) {
                    return variation.seamsCtmVert.icons[reverse ? 2 : 3];
                }
                if (n) {
                    return variation.seamsCtmVert.icons[reverse ? 3 : 2];
                }
                return variation.seamsCtmVert.icons[0];
            }
            case 6: 
            case 7: {
                int index = x + y * 606731 + z * 571163 + side * 555491;
                if (index < 0) {
                    index = -index;
                }
                return variation.variations9.icons[index % (variation.kind == 6 ? 9 : 4)];
            }
            case 8: {
                return variation.icon;
            }
        }
        return GeneralClient.getMissingIcon();
    }

    public void register(Block block, String name) {
        this.register(block, name, ItemCarvable.class);
    }

    public void registerBlock(Block block, String name) {
        this.registerBlock(block, name, ItemCarvable.class);
    }

    void registerBlock(Block block, String name, Class cl) {
        block.func_149663_c(name);
        GameRegistry.registerBlock((Block)block, (Class)cl, (String)("chisel." + name));
        chiselBlocks.add(block);
    }

    public void register(Block block, String name, Class cl) {
        this.registerBlock(block, name, cl);
        if (block instanceof BlockMarbleSlab) {
            BlockMarbleSlab slab = (BlockMarbleSlab)block;
        }
        for (CarvableVariation variation : this.variations) {
            this.registerVariation(name, variation, block, variation.metadata);
            if (!(block instanceof BlockMarbleSlab) || !((BlockMarbleSlab)block).isBottom) continue;
            BlockMarbleSlab slab = (BlockMarbleSlab)block;
            slab.top.setHarvestLevel(modName, 0, variation.metadata);
            if (this.forbidChiseling) continue;
            Carving.chisel.addVariation(name + ".top", slab.top, variation.metadata, 0);
            Carving.chisel.setGroupClass(name + ".top", name);
        }
    }

    public void registerVariation(String name, CarvableVariation variation, Block block, int blockMeta) {
        LanguageRegistry.addName((Object)new ItemStack(block, 1, blockMeta), (String)(Chisel.blockDescriptions ? variation.blockName : variation.description));
        if (this.forbidChiseling) {
            return;
        }
        if (variation.block == null) {
            Carving.chisel.addVariation(name, block, blockMeta, variation.metadata);
            block.setHarvestLevel(modName, 0, blockMeta);
        } else {
            Carving.chisel.addVariation(name, variation.block, variation.blockMeta, variation.metadata);
            variation.block.setHarvestLevel(modName, 0, variation.blockMeta);
        }
    }

    public void registerBlockIcons(String modName, Block block, IIconRegister register) {
        for (CarvableVariation variation : this.variations) {
            if (variation.block != null) {
                variation.block.func_149651_a(register);
                if (variation.block instanceof BlockPane) {
                    variation.icon = variation.block.func_149733_h(2);
                    variation.iconTop = ((BlockPane)variation.block).func_149733_h(0);
                    variation.iconBot = ((BlockPane)variation.block).func_149733_h(0);
                    continue;
                }
                switch (variation.kind) {
                    case 0: {
                        variation.icon = variation.block.func_149691_a(2, variation.blockMeta);
                        break;
                    }
                    case 1: {
                        variation.icon = variation.block.func_149691_a(2, variation.blockMeta);
                        variation.iconTop = variation.block.func_149691_a(0, variation.blockMeta);
                        break;
                    }
                    case 2: {
                        variation.icon = variation.block.func_149691_a(2, variation.blockMeta);
                        variation.iconTop = variation.block.func_149691_a(1, variation.blockMeta);
                        variation.iconBot = variation.block.func_149691_a(0, variation.blockMeta);
                    }
                }
                continue;
            }
            switch (variation.kind) {
                case 0: {
                    variation.icon = register.func_94245_a(modName + ":" + variation.texture);
                    break;
                }
                case 1: {
                    variation.icon = register.func_94245_a(modName + ":" + variation.texture + "-side");
                    variation.iconTop = register.func_94245_a(modName + ":" + variation.texture + "-top");
                    break;
                }
                case 2: {
                    variation.icon = register.func_94245_a(modName + ":" + variation.texture + "-side");
                    variation.iconTop = register.func_94245_a(modName + ":" + variation.texture + "-top");
                    variation.iconBot = register.func_94245_a(modName + ":" + variation.texture + "-bottom");
                    break;
                }
                case 3: {
                    CarvableVariation.CarvableVariationCTM ctm = new CarvableVariation.CarvableVariationCTM();
                    ctm.seams[0] = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-ctm1"), 4, 4);
                    ctm.seams[1] = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-ctm2"), 4, 4);
                    ctm.seams[2] = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-ctm3"), 4, 4);
                    variation.ctm = ctm;
                    break;
                }
                case 4: {
                    variation.seamsCtmVert = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-ctmv"), 2, 2);
                    variation.iconTop = register.func_94245_a(modName + ":" + variation.texture + "-top");
                    break;
                }
                case 5: {
                    variation.seamsCtmVert = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-ctmh"), 2, 2);
                    variation.iconTop = register.func_94245_a(modName + ":" + variation.texture + "-top");
                    break;
                }
                case 6: {
                    variation.variations9 = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-v9"), 3, 3);
                    break;
                }
                case 7: {
                    variation.variations9 = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-v4"), 2, 2);
                    break;
                }
                case 8: {
                    variation.icon = register.func_94245_a(modName + ":" + variation.texture);
                    variation.submap = new TextureSubmap(register.func_94245_a(modName + ":" + variation.texture + "-ctm"), 4, 4);
                    variation.submapSmall = new TextureSubmap(variation.icon, 2, 2);
                }
            }
        }
    }

    public void registerSubBlocks(Block block, CreativeTabs tabs, List list) {
        for (CarvableVariation variation : this.variations) {
            list.add(new ItemStack(block, 1, variation.metadata));
        }
    }

    private boolean isSame(IBlockAccess world, int x, int y, int z, Block block, int meta) {
        return world.func_147439_a(x, y, z).equals(block) && world.func_72805_g(x, y, z) == meta;
    }

    public void setBlockName(String name) {
        this.blockName = name;
    }

    public static Set<Block> getChiselBlockSet() {
        HashSet<Block> tools = new HashSet<Block>();
        tools.addAll(chiselBlocks);
        return tools;
    }
}

