/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.client.gui;

import info.jbcs.minecraft.chisel.client.gui.GuiElement;
import info.jbcs.minecraft.chisel.client.gui.InputKeyboardEvent;
import info.jbcs.minecraft.chisel.client.gui.InputMouseEvent;
import info.jbcs.minecraft.utilities.DummyContainer;
import info.jbcs.minecraft.utilities.GeneralClient;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreenPlus
extends GuiContainer {
    public int screenW;
    public int screenH;
    public int screenX;
    public int screenY;
    public GuiElement root;
    String backgroundTexture;
    InputMouseEvent mouseEvent = new InputMouseEvent();
    int oldX = -1;
    int oldY = -1;
    boolean[] downButtons = new boolean[12];
    InputKeyboardEvent keyboardEvent = new InputKeyboardEvent();

    public GuiScreenPlus(Container container, int w, int h, String backgroundTexture) {
        super(container);
        this.root = new GuiElement(0, 0, w, h);
        this.root.gui = this;
        this.screenW = w;
        this.screenH = h;
        this.backgroundTexture = backgroundTexture;
    }

    public GuiScreenPlus(int w, int h, String backgroundTexture) {
        this(new DummyContainer(), w, h, backgroundTexture);
    }

    public void func_73866_w_() {
        this.field_146999_f = this.screenW;
        this.field_147000_g = this.screenH;
        super.func_73866_w_();
        this.screenX = this.field_147003_i;
        this.screenY = this.field_147009_r;
        this.root.onAdded();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146269_k() {
        while (Mouse.next()) {
            this.func_146274_d();
        }
        while (Keyboard.next()) {
            this.func_146282_l();
        }
    }

    public void func_146274_d() {
        this.mouseEvent.handled = false;
        this.mouseEvent.x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.screenX;
        this.mouseEvent.y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.screenY;
        if (this.oldX == -1) {
            this.oldX = this.mouseEvent.x;
            this.oldY = this.mouseEvent.y;
        }
        this.mouseEvent.dx = this.mouseEvent.x - this.oldX;
        this.mouseEvent.dy = this.mouseEvent.y - this.oldY;
        this.oldX = this.mouseEvent.x;
        this.oldY = this.mouseEvent.y;
        this.mouseEvent.down = Mouse.getEventButtonState();
        this.mouseEvent.button = Mouse.getEventButton();
        this.mouseEvent.wheel = Mouse.getEventDWheel();
        if (this.mouseEvent.wheel != 0) {
            this.mouseEvent.wheel = this.mouseEvent.wheel < 0 ? -1 : 1;
            this.root.mouseWheel(this.mouseEvent);
        } else if (this.mouseEvent.button >= 0 && this.mouseEvent.button < this.downButtons.length) {
            if (this.downButtons[this.mouseEvent.button] != this.mouseEvent.down) {
                this.downButtons[this.mouseEvent.button] = this.mouseEvent.down;
                if (this.mouseEvent.down) {
                    this.root.mouseDown(this.mouseEvent);
                } else {
                    this.root.mouseUp(this.mouseEvent);
                }
            } else if (this.mouseEvent.dx != 0 || this.mouseEvent.dy != 0) {
                this.root.mouseMove(this.mouseEvent);
            }
        } else if (this.mouseEvent.dx != 0 || this.mouseEvent.dy != 0) {
            this.root.mouseMove(this.mouseEvent);
        }
        if (!this.mouseEvent.handled) {
            super.func_146274_d();
        }
    }

    public void func_146282_l() {
        this.keyboardEvent.handled = false;
        if (Keyboard.getEventKeyState()) {
            this.keyboardEvent.key = Keyboard.getEventKey();
            this.keyboardEvent.character = Keyboard.getEventCharacter();
            switch (this.keyboardEvent.key) {
                case 1: {
                    break;
                }
                default: {
                    this.root.keyPressed(this.keyboardEvent);
                }
            }
        }
        if (!this.keyboardEvent.handled) {
            super.func_146282_l();
        }
    }

    public void close() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
    }

    protected void addChild(GuiElement e) {
        this.root.addChild(e);
    }

    protected void func_146976_a(float f, int bx, int by) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GeneralClient.bind(this.backgroundTexture);
        this.func_73729_b(this.screenX, this.screenY, 0, 0, this.screenW, this.screenH);
    }

    protected void func_146979_b(int fx, int fy) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.root.render();
    }

    public void drawString(String text, int sx, int sy, int color) {
        this.field_146289_q.func_78276_b(text, sx, sy, color);
    }

    public void drawCenteredString(String text, int sx, int sy, int color) {
        this.field_146289_q.func_78276_b(text, sx - this.field_146289_q.func_78256_a(text) / 2, sy - this.field_146289_q.field_78288_b / 2, color);
    }

    public void drawStringWithShadow(String text, int sx, int sy, int color) {
        this.field_146289_q.func_78261_a(text, sx, sy, color);
    }

    public void drawCenteredStringWithShadow(String text, int sx, int sy, int color) {
        this.field_146289_q.func_78261_a(text, sx - this.field_146289_q.func_78256_a(text) / 2, sy - this.field_146289_q.field_78288_b / 2, color);
    }

    public FontRenderer fontRendererObj() {
        return this.field_146289_q;
    }

    protected void drawRect(int gx, int gy, int gw, int gh, int c1, int c2) {
        this.func_73733_a(gx, gy, gx + gw, gy + gh, c1, c2);
    }

    public void drawTiledRect(int rx, int ry, int rw, int rh, int u, int v, int tw, int th) {
        if (rw == 0 || rh == 0 || tw == 0 || th == 0) {
            return;
        }
        float pixel = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int y = 0; y < rh; y += th) {
            for (int x = 0; x < rw; x += tw) {
                int qh;
                int qw = tw;
                if (x + qw > rw) {
                    qw = rw - x;
                }
                if (y + (qh = th) > rh) {
                    qh = rh - y;
                }
                double x1 = rx + x;
                double x2 = rx + x + qw;
                double y1 = ry + y;
                double y2 = ry + y + qh;
                double u1 = pixel * (float)u;
                double u2 = pixel * (float)(u + tw);
                double v1 = pixel * (float)v;
                double v2 = pixel * (float)(v + th);
                tessellator.func_78374_a(x1, y2, (double)this.field_73735_i, u1, v2);
                tessellator.func_78374_a(x2, y2, (double)this.field_73735_i, u2, v2);
                tessellator.func_78374_a(x2, y1, (double)this.field_73735_i, u2, v1);
                tessellator.func_78374_a(x1, y1, (double)this.field_73735_i, u1, v1);
            }
        }
        tessellator.func_78381_a();
    }

    public void bindTexture(String tex) {
        GeneralClient.bind(tex);
    }

    public void playSound(String sound, float volume, float pitch) {
    }
}

