/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.ConfigParser;
import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorChoice;
import CustomOreGen.Config.ValidatorNode;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.Server.ChoiceOption;
import CustomOreGen.Server.ConfigOption;
import CustomOreGen.Server.NumericOption;
import CustomOreGen.Util.Localization;
import org.w3c.dom.Node;

public class ValidatorOption
extends ValidatorNode {
    private final Class _type;

    protected ValidatorOption(ValidatorNode parent, Node node, Class type) {
        super(parent, node);
        this._type = type;
    }

    @Override
    protected boolean validateChildren() throws ParserException {
        Object defValue2;
        super.validateChildren();
        String optionName = this.validateRequiredAttribute(String.class, "name", true);
        ConfigOption option = null;
        Class valueType = null;
        if (this._type == ChoiceOption.class) {
            valueType = String.class;
            ChoiceOption groupName = new ChoiceOption(optionName);
            option = groupName;
            for (ValidatorChoice loadedValueStr : this.validateNamedChildren(2, "Choice", new ValidatorChoice.Factory())) {
                String choiceKey = optionName + "." + loadedValueStr.value;
                String displayValue = Localization.maybeLocalize(choiceKey + ".displayValue", loadedValueStr.displayValue);
                String description = Localization.maybeLocalize(choiceKey + ".description", loadedValueStr.description);
                groupName.addPossibleValue(loadedValueStr.value, displayValue, description);
            }
            if (groupName.getValue() == null) {
                throw new ParserException("Choice option has no possible values.", this.getNode());
            }
        } else if (this._type == NumericOption.class) {
            double dincr;
            double dmax;
            double err;
            valueType = Double.class;
            NumericOption groupName1 = new NumericOption(optionName);
            option = groupName1;
            double defValue1 = this.validateNamedAttribute(valueType, "min", groupName1.getMin(), true);
            if (!groupName1.setLimits(defValue1, err = this.validateNamedAttribute(valueType, "max", groupName1.getMax(), true).doubleValue())) {
                throw new ParserException("Numeric option value range [" + defValue1 + "," + err + "] is invalid.", this.getNode());
            }
            double dmin = this.validateNamedAttribute(valueType, "displayMin", groupName1.getMin(), true);
            if (!groupName1.setDisplayLimits(dmin, dmax = this.validateNamedAttribute(valueType, "displayMax", groupName1.getMax(), true).doubleValue(), dincr = this.validateNamedAttribute(valueType, "displayIncrement", (dmax - dmin) / 100.0, true).doubleValue())) {
                throw new ParserException("Numeric option display range/increment [" + dmin + "," + dmax + "]/" + dincr + " is invalid.", this.getNode());
            }
        } else if (this._type == ConfigOption.DisplayGroup.class) {
            option = new ConfigOption.DisplayGroup(optionName);
        }
        option.setDisplayState(this.validateNamedAttribute(ConfigOption.DisplayState.class, "displayState", option.getDisplayState(), true));
        option.setDisplayName(this.validateAndLocalizeNamedAttribute(optionName, "displayName", option.getDisplayName(), true));
        option.setDescription(this.validateAndLocalizeNamedAttribute(optionName, "description", option.getDescription(), true));
        String groupName2 = this.validateNamedAttribute(String.class, "displayGroup", null, true);
        if (groupName2 != null) {
            ConfigOption defValue3 = this.getParser().target.getConfigOption(groupName2);
            if (defValue3 == null || !(defValue3 instanceof ConfigOption.DisplayGroup)) {
                throw new ParserException("Option '" + groupName2 + "' is not a recognized Display Group.", this.getNode());
            }
            option.setDisplayGroup((ConfigOption.DisplayGroup)defValue3);
        }
        Object object = defValue2 = valueType == null ? null : this.validateNamedAttribute(valueType, "default", null, true);
        if (this.getParser().target.getConfigOption(option.getName()) != null) {
            throw new ParserException("An Option named '" + option.getName() + "' already exists.", this.getNode());
        }
        this.getParser().target.getConfigOptions().add(option);
        String loadedValueStr1 = this.getParser().target.loadConfigOption(option.getName());
        if (loadedValueStr1 != null) {
            String err1 = null;
            try {
                Object ex = ConfigParser.parseString(valueType, loadedValueStr1);
                if (!option.setValue(ex)) {
                    err1 = "";
                }
            }
            catch (IllegalArgumentException var15) {
                err1 = " (" + var15.getMessage() + ")";
            }
            if (err1 == null) {
                return true;
            }
            CustomOreGenBase.log.warn("The saved value '" + loadedValueStr1 + "' for Config Option '" + option.getName() + "' is invalid" + err1 + ".  " + "The default value '" + (defValue2 == null ? option.getValue() : defValue2) + "' will be used instead.");
        }
        if (defValue2 != null && !option.setValue(defValue2)) {
            throw new ParserException("Invalid default value '" + defValue2 + "' for option '" + option.getName() + "'.", this.getNode());
        }
        return true;
    }

    public static class Factory
    implements ValidatorNode.IValidatorFactory<ValidatorOption> {
        private final Class _type;

        public Factory(Class type) {
            this._type = type;
        }

        @Override
        public ValidatorOption createValidator(ValidatorNode parent, Node node) {
            return new ValidatorOption(parent, node, this._type);
        }
    }
}

