/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import info.ata4.minecraft.mineshot.client.accessor.EntityRendererAccessor;
import info.ata4.minecraft.mineshot.client.util.Chat;
import info.ata4.minecraft.profilerevents.ProfilerEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class OrthoViewHandler {
    private static final float ZOOM_STEP = 0.1f;
    private static final float ROTATE_STEP = 15.0f;
    private static final int CLIP_STEP = 4;
    private final KeyBinding keyToggle = new KeyBinding("key.mineshot.ortho.toggle", 76, "key.categories.mineshot");
    private final KeyBinding keyZoomIn = new KeyBinding("key.mineshot.ortho.zoom_in", 78, "key.categories.mineshot");
    private final KeyBinding keyZoomOut = new KeyBinding("key.mineshot.ortho.zoom_out", 74, "key.categories.mineshot");
    private final KeyBinding keyRotateL = new KeyBinding("key.mineshot.ortho.rotate_l", 75, "key.categories.mineshot");
    private final KeyBinding keyRotateR = new KeyBinding("key.mineshot.ortho.rotate_r", 77, "key.categories.mineshot");
    private final KeyBinding keyRotateU = new KeyBinding("key.mineshot.ortho.rotate_u", 72, "key.categories.mineshot");
    private final KeyBinding keyRotateD = new KeyBinding("key.mineshot.ortho.rotate_d", 80, "key.categories.mineshot");
    private final KeyBinding keyRotateT = new KeyBinding("key.mineshot.ortho.rotate_t", 71, "key.categories.mineshot");
    private final KeyBinding keyRotateF = new KeyBinding("key.mineshot.ortho.rotate_f", 79, "key.categories.mineshot");
    private final KeyBinding keyRotateS = new KeyBinding("key.mineshot.ortho.rotate_s", 81, "key.categories.mineshot");
    private final KeyBinding keyClip = new KeyBinding("key.mineshot.ortho.clip", 55, "key.categories.mineshot");
    private final Minecraft mc = Minecraft.func_71410_x();
    private final EntityRendererAccessor era;
    private boolean enable;
    private boolean freeCam;
    private float zoom;
    private float clip;
    private float xRot;
    private float yRot;

    public OrthoViewHandler() {
        this.era = new EntityRendererAccessor(this.mc.field_71460_t);
        this.zoom = 8.0f;
        this.clip = 512.0f;
        this.xRot = 30.0f;
        this.yRot = -45.0f;
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyToggle);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyZoomIn);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyZoomOut);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateL);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateR);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateU);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateD);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateT);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateF);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotateS);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyClip);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent evt) {
        if (this.keyZoomIn.func_151470_d()) {
            this.zoom *= 1.1f;
        } else if (this.keyZoomOut.func_151470_d()) {
            this.zoom *= 0.9f;
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent evt) {
        if (this.keyToggle.func_151468_f()) {
            if (Keyboard.isKeyDown((int)29)) {
                this.freeCam = !this.freeCam;
            } else {
                boolean bl = this.enable = !this.enable;
                if (this.enable) {
                    this.xRot = 30.0f;
                    this.yRot = -45.0f;
                    this.zoom = 8.0f;
                    this.clip = 512.0f;
                }
            }
        } else if (this.keyRotateL.func_151468_f()) {
            this.yRot += 15.0f;
        } else if (this.keyRotateR.func_151468_f()) {
            this.yRot -= 15.0f;
        } else if (this.keyRotateU.func_151468_f()) {
            this.xRot += 15.0f;
        } else if (this.keyRotateD.func_151468_f()) {
            this.xRot -= 15.0f;
        } else if (this.keyRotateT.func_151468_f()) {
            this.xRot = Keyboard.isKeyDown((int)29) ? -90.0f : 90.0f;
            this.yRot = 0.0f;
        } else if (this.keyRotateF.func_151468_f()) {
            this.xRot = 0.0f;
            this.yRot = Keyboard.isKeyDown((int)29) ? -90.0f : 90.0f;
        } else if (this.keyRotateS.func_151468_f()) {
            this.xRot = 0.0f;
            this.yRot = Keyboard.isKeyDown((int)29) ? 180.0f : 0.0f;
        } else if (this.keyClip.func_151468_f()) {
            this.clip += Keyboard.isKeyDown((int)29) ? 4.0f : -4.0f;
            if (this.clip <= 0.0f) {
                this.clip = 4.0f;
            }
        }
    }

    @SubscribeEvent
    public void onProfiling(ProfilerEvent.Client evt) {
        if (this.enable && !evt.isEnd() && evt.getSection().endsWith("frustrum")) {
            if (!this.mc.func_71356_B()) {
                this.enable = false;
                Chat.print("mineshot.orthomp", new Object[0]);
                return;
            }
            float width = this.zoom * ((float)this.mc.field_71443_c / (float)this.mc.field_71440_d);
            float height = this.zoom;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            double cameraZoom = this.era.getCameraZoom();
            double cameraOfsX = this.era.getCameraOffsetX();
            double cameraOfsY = this.era.getCameraOffsetY();
            if (cameraZoom != 1.0) {
                GL11.glTranslated((double)cameraOfsX, (double)(-cameraOfsY), (double)0.0);
                GL11.glScaled((double)cameraZoom, (double)cameraZoom, (double)1.0);
            }
            GL11.glOrtho((double)(-width), (double)width, (double)(-height), (double)height, (double)(-this.clip), (double)this.clip);
            if (this.freeCam) {
                this.xRot = this.mc.field_71439_g.field_70125_A;
                this.yRot = this.mc.field_71439_g.field_70177_z - 180.0f;
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glRotatef((float)this.xRot, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yRot, (float)0.0f, (float)1.0f, (float)0.0f);
            if (!this.freeCam) {
                float pitch = this.xRot;
                float yaw = this.yRot + 180.0f;
                ActiveRenderInfo.field_74588_d = MathHelper.func_76134_b((float)(yaw * (float)Math.PI / 180.0f));
                ActiveRenderInfo.field_74586_f = MathHelper.func_76126_a((float)(yaw * (float)Math.PI / 180.0f));
                ActiveRenderInfo.field_74587_g = -ActiveRenderInfo.field_74586_f * MathHelper.func_76126_a((float)(pitch * (float)Math.PI / 180.0f));
                ActiveRenderInfo.field_74596_h = ActiveRenderInfo.field_74588_d * MathHelper.func_76126_a((float)(pitch * (float)Math.PI / 180.0f));
                ActiveRenderInfo.field_74589_e = MathHelper.func_76134_b((float)(pitch * (float)Math.PI / 180.0f));
            }
        }
    }
}

