/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import info.ata4.minecraft.mineshot.MineshotConfig;
import info.ata4.minecraft.mineshot.client.accessor.MinecraftAccessor;
import info.ata4.minecraft.mineshot.client.gui.GuiScreenSettings;
import info.ata4.minecraft.mineshot.client.util.Chat;
import info.ata4.minecraft.mineshot.client.util.ScreenshotUtils;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class ScreenshotHandler {
    private static final Logger L = LogManager.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final KeyBinding keyCapture = new KeyBinding("key.mineshot.capture", 67, "key.categories.mineshot");
    private final MineshotConfig config;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final MinecraftAccessor mca = new MinecraftAccessor(this.mc);
    private final GameSettingsManager gameSettings = new GameSettingsManager();
    private boolean scheduleCapture;
    private int currentViewportWidth;
    private int currentViewportHeight;
    private int frame;

    public ScreenshotHandler(MineshotConfig config) {
        this.config = config;
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyCapture);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (this.keyCapture.func_151468_f()) {
            if (Keyboard.isKeyDown((int)42)) {
                this.mc.func_147108_a((GuiScreen)new GuiScreenSettings(this.config));
            } else {
                this.scheduleCapture();
            }
        }
    }

    @SubscribeEvent
    public void onProfiling(TickEvent.RenderTickEvent evt) {
        if (!this.scheduleCapture || evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.capture()) {
            this.scheduleCapture = false;
        }
    }

    public void scheduleCapture() {
        this.scheduleCapture = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean capture() {
        block11: {
            int width = this.config.getCaptureWidth();
            int height = this.config.getCaptureHeight();
            try {
                if (this.config.isTiled()) {
                    L.info("Creating tiled screenshot: {}x{}", new Object[]{width, height});
                    this.gameSettings.modify();
                    File file = this.getScreenshotFile();
                    ScreenshotUtils.captureTiled(width, height, file);
                    this.gameSettings.restore();
                    Chat.printFileLink("screenshot.success", file);
                    break block11;
                }
                ++this.frame;
                switch (this.frame) {
                    case 1: {
                        this.currentViewportWidth = this.mc.field_71443_c;
                        this.currentViewportHeight = this.mc.field_71440_d;
                        this.gameSettings.modify();
                        this.mca.resize(width, height);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        L.info("Creating framebuffer screenshot: {}x{}", new Object[]{width, height});
                        try {
                            File file = this.getScreenshotFile();
                            ScreenshotUtils.capture(file);
                            Chat.printFileLink("screenshot.success", file);
                        }
                        finally {
                            this.mca.resize(this.currentViewportWidth, this.currentViewportHeight);
                            this.gameSettings.restore();
                        }
                        this.frame = 0;
                        break;
                    }
                    default: {
                        this.frame = 0;
                    }
                }
            }
            catch (Throwable t) {
                L.error("Screenshot capture failed", t);
                Chat.print("screenshot.failure", t.getMessage());
                this.gameSettings.restore();
            }
        }
        return this.frame == 0;
    }

    private File getScreenshotFile() {
        File file;
        File dir = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
        if (!dir.exists()) {
            dir.mkdir();
        }
        String fileName = "huge_" + DATE_FORMAT.format(new Date());
        String fileExt = "tga";
        int i = 1;
        while ((file = new File(dir, fileName + (i != 1 ? "_" + i : "") + "." + fileExt)).exists()) {
            ++i;
        }
        return file;
    }

    private class GameSettingsManager {
        boolean modified;
        boolean advancedOpengl;
        boolean hideGUI;

        private GameSettingsManager() {
        }

        void modify() {
            this.advancedOpengl = ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71474_y.field_74349_h;
            ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71474_y.field_74349_h = false;
            if (ScreenshotHandler.this.config.isTiled()) {
                this.hideGUI = ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71474_y.field_74319_N;
                ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71474_y.field_74319_N = true;
            }
            for (Entity ent : ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71441_e.field_72996_f) {
                ent.field_70158_ak = true;
                ent.field_70155_l = 16.0;
            }
            this.modified = true;
        }

        void restore() {
            if (!this.modified) {
                return;
            }
            ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71474_y.field_74319_N = this.hideGUI;
            ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71474_y.field_74349_h = this.advancedOpengl;
            for (Entity ent : ((ScreenshotHandler)ScreenshotHandler.this).mc.field_71441_e.field_72996_f) {
                ent.field_70158_ak = false;
                ent.field_70155_l = 1.0;
            }
        }
    }
}

