/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.profilerevents;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.relauncher.Side;
import info.ata4.minecraft.profilerevents.ProfilerEventProxy;
import info.ata4.minecraft.profilerevents.util.UnsafeReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ProfilerEvents", version="1.0")
public class ProfilerEvents {
    private static final Logger L = LogManager.getLogger();
    public static final String MODID = "ProfilerEvents";
    public static final String VERSION = "1.0";

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent evt) {
        ProfilerEvents.initClient();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartedEvent evt) {
        ProfilerEvents.initServer();
    }

    private static void initClient() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71424_I == null) {
            L.warn("Client profiler not yet initialized!");
            return;
        }
        if (mc.field_71424_I instanceof ProfilerEventProxy) {
            L.warn("Client profiler already modified!");
            return;
        }
        try {
            ProfilerEventProxy profiler = new ProfilerEventProxy(mc.field_71424_I, Side.CLIENT);
            int profilerFieldIndex = UnsafeReflectionHelper.findFieldIndex(Minecraft.class, Profiler.class);
            UnsafeReflectionHelper.setFinalValue(Minecraft.class, mc, profiler, profilerFieldIndex);
            L.info("Client profiler hooked successfully");
        }
        catch (Throwable ex) {
            L.error("Client profiler hook error", ex);
        }
    }

    private static void initServer() {
        MinecraftServer mcs = MinecraftServer.func_71276_C();
        if (mcs == null) {
            return;
        }
        if (mcs.field_71304_b == null) {
            L.warn("Server profiler not yet initialized!");
            return;
        }
        if (mcs.field_71304_b instanceof ProfilerEventProxy) {
            L.warn("Server profiler already modified!");
            return;
        }
        try {
            ProfilerEventProxy profiler = new ProfilerEventProxy(mcs.field_71304_b, Side.SERVER);
            int profilerFieldIndex = UnsafeReflectionHelper.findFieldIndex(MinecraftServer.class, Profiler.class);
            UnsafeReflectionHelper.setFinalValue(MinecraftServer.class, mcs, profiler, profilerFieldIndex);
            L.info("Server profiler hooked successfully");
        }
        catch (Throwable ex) {
            L.error("Server profiler hook error", ex);
        }
    }
}

