/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.profilerevents.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import info.ata4.minecraft.profilerevents.util.UnableToFindFieldException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class UnsafeReflectionHelper {
    private UnsafeReflectionHelper() {
    }

    public static void unfinalize(Field field) throws ReflectiveOperationException {
        if (Modifier.isFinal(field.getModifiers())) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
    }

    public static <T, E> void setFinalValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            UnsafeReflectionHelper.unfinalize(f);
            f.set(instance, value);
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
        }
    }

    public static <T, E> void setFinalValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            Field f = ReflectionHelper.findField(classToAccess, (String[])fieldNames);
            UnsafeReflectionHelper.unfinalize(f);
            f.set(instance, value);
        }
        catch (Exception e) {
            throw new ReflectionHelper.UnableToAccessFieldException(fieldNames, e);
        }
    }

    public static int findFieldIndex(Class clazz, Class type) {
        Exception failed = null;
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getType() != type) continue;
                return i;
            }
            catch (Exception e) {
                failed = e;
                break;
            }
        }
        throw new UnableToFindFieldException(failed);
    }
}

