/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineshotConfig {
    private static final Logger L = LogManager.getLogger();
    private static final int DEF_CAPTURE_WIDTH = 3840;
    private static final int DEF_CAPTURE_HEIGHT = 2160;
    private static final boolean DEF_CAPTURE_TILED = false;
    private Configuration config;
    private Property captureWidth;
    private Property captureHeight;
    private Property captureTiled;

    public MineshotConfig(File configFile) {
        try {
            this.config = new Configuration(configFile);
        }
        catch (RuntimeException ex) {
            this.config = new Configuration();
            L.warn("Error in configuration file, using defaults", (Throwable)ex);
        }
        this.captureWidth = this.config.get("capture", "width", 3840);
        this.captureHeight = this.config.get("capture", "height", 2160);
        this.captureTiled = this.config.get("capture", "tiled", false);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void reload() {
        try {
            this.config.load();
        }
        catch (RuntimeException ex) {
            L.warn("Error in configuration file", (Throwable)ex);
        }
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public int getCaptureWidth() {
        return this.captureWidth.getInt(3840);
    }

    public void setCaptureWidth(int width) {
        this.captureWidth.set(width);
    }

    public int getCaptureHeight() {
        return this.captureHeight.getInt(2160);
    }

    public void setCaptureHeight(int height) {
        this.captureHeight.set(height);
    }

    public boolean isTiled() {
        return this.captureTiled.getBoolean(false);
    }

    public void setTiled(boolean tiled) {
        this.captureTiled.set(tiled);
    }
}

