/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot.client.accessor;

import cpw.mods.fml.relauncher.ReflectionHelper;
import info.ata4.minecraft.profilerevents.util.UnableToFindFieldException;
import info.ata4.minecraft.profilerevents.util.UnsafeReflectionHelper;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.util.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftAccessor {
    private static final Logger L = LogManager.getLogger();
    private static int FIELD_TIMER = -1;
    private static int FIELD_EFFECTRENDERER = -1;
    private static Method METHOD_RESIZE;
    private final Minecraft mc;

    public MinecraftAccessor() {
        this(Minecraft.func_71410_x());
    }

    public MinecraftAccessor(Minecraft mc) {
        this.mc = mc;
    }

    public void setTimer(Timer timer) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)this.mc, (Object)timer, (int)FIELD_TIMER);
        }
        catch (Exception ex) {
            L.error("setTimer() failed", (Throwable)ex);
        }
    }

    public Timer getTimer() {
        try {
            return (Timer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)this.mc, (int)FIELD_TIMER);
        }
        catch (Exception ex) {
            L.error("getTimer() failed", (Throwable)ex);
            return null;
        }
    }

    public void resize(int width, int height) {
        try {
            METHOD_RESIZE.invoke((Object)this.mc, width, height);
        }
        catch (Exception ex) {
            L.error("resize() failed", (Throwable)ex);
        }
    }

    public void setEffectRenderer(EffectRenderer effectRenderer) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)this.mc, (Object)effectRenderer, (int)FIELD_EFFECTRENDERER);
        }
        catch (Exception ex) {
            L.error("setEffectRenderer() failed", (Throwable)ex);
        }
    }

    public EffectRenderer getEffectRenderer() {
        try {
            return (EffectRenderer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)this.mc, (int)FIELD_EFFECTRENDERER);
        }
        catch (Exception ex) {
            L.error("getEffectRenderer() failed", (Throwable)ex);
            return null;
        }
    }

    static {
        try {
            FIELD_TIMER = UnsafeReflectionHelper.findFieldIndex(Minecraft.class, Timer.class);
            FIELD_EFFECTRENDERER = UnsafeReflectionHelper.findFieldIndex(Minecraft.class, EffectRenderer.class);
        }
        catch (UnableToFindFieldException ex) {
            L.error("Couldn't find field for class Minecraft!", (Throwable)ex);
        }
        try {
            METHOD_RESIZE = ReflectionHelper.findMethod(Minecraft.class, null, (String[])new String[]{"resize", "func_71370_a", "a"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        }
        catch (ReflectionHelper.UnableToFindMethodException ex) {
            L.error("Couldn't find method for class Minecraft!", (Throwable)ex);
        }
    }
}

