/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.mineshot.client.gui;

import info.ata4.minecraft.mineshot.MineshotConfig;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GuiScreenSettings
extends GuiScreen {
    private static final int TARGA_MAX_DIMENSION = 65535;
    private String strTitle = I18n.func_135052_a((String)"mineshot.gui.title", (Object[])new Object[0]);
    private String strWidth = I18n.func_135052_a((String)"mineshot.gui.width", (Object[])new Object[0]);
    private String strHeight = I18n.func_135052_a((String)"mineshot.gui.height", (Object[])new Object[0]);
    private final MineshotConfig config;
    private GuiTextField textFieldWidth;
    private GuiTextField textFieldHeight;
    private GuiButton doneButton;
    private String fileSize;
    private List<String> warnings = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private int maxViewportWidth;
    private int maxViewportHeight;

    public GuiScreenSettings(MineshotConfig config) {
        this.config = config;
        try {
            IntBuffer dims = BufferUtils.createIntBuffer((int)16);
            GL11.glGetInteger((int)3386, (IntBuffer)dims);
            dims.rewind();
            this.maxViewportWidth = dims.get();
            this.maxViewportHeight = dims.get();
        }
        catch (Throwable t) {
            this.maxViewportWidth = 4096;
            this.maxViewportHeight = 4096;
        }
    }

    public void func_73866_w_() {
        this.doneButton = new GuiButton(0, this.field_146294_l / 2 - 84, 192, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.textFieldWidth = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 80, 64, 64, 20);
        this.textFieldWidth.func_146195_b(true);
        this.textFieldWidth.func_146203_f(6);
        this.textFieldWidth.func_146180_a(String.valueOf(this.config.getCaptureWidth()));
        this.textFieldHeight = new GuiTextField(this.field_146289_q, this.field_146294_l / 2, 64, 64, 20);
        this.textFieldHeight.func_146203_f(6);
        this.textFieldHeight.func_146180_a(String.valueOf(this.config.getCaptureHeight()));
        this.updateValues();
    }

    public void func_73876_c() {
        this.textFieldWidth.func_146178_a();
        this.textFieldHeight.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button == this.doneButton) {
            this.field_146297_k.func_147108_a(null);
            this.config.save();
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par1 > '/' && par1 < ':' || par1 == '\b') {
            this.textFieldWidth.func_146201_a(par1, par2);
            this.textFieldHeight.func_146201_a(par1, par2);
            this.updateValues();
        }
        if (par1 == '\t') {
            if (this.textFieldWidth.func_146206_l()) {
                this.textFieldWidth.func_146180_a(String.valueOf(this.getWidth()));
                this.textFieldWidth.func_146195_b(false);
                this.textFieldHeight.func_146195_b(true);
            } else {
                this.textFieldHeight.func_146180_a(String.valueOf(this.getHeight()));
                this.textFieldWidth.func_146195_b(true);
                this.textFieldHeight.func_146195_b(false);
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.textFieldWidth.func_146192_a(par1, par2, par3);
        this.textFieldHeight.func_146192_a(par1, par2, par3);
    }

    public void func_73863_a(int x, int y, float z) {
        int xs = this.field_146294_l / 2;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.strTitle, xs - 10, 32, 0xFFFFFF);
        this.textFieldWidth.func_146194_f();
        this.textFieldHeight.func_146194_f();
        this.func_73731_b(this.field_146289_q, this.strWidth, xs - 80, 50, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, this.strHeight, xs, 50, 0xA0A0A0);
        this.func_73731_b(this.field_146289_q, "x", xs - 11, 70, 0xFFFFFF);
        int ys = 84;
        int line = 12;
        int ofs = this.field_146289_q.func_78256_a(this.fileSize) / 2;
        this.func_73731_b(this.field_146289_q, this.fileSize, xs - ofs, ys += line, 0xA0A0A0);
        for (String warning : this.warnings) {
            ofs = this.field_146289_q.func_78256_a(warning) / 2;
            this.func_73731_b(this.field_146289_q, warning, xs - ofs, ys += line, 0xEEEE0A);
        }
        for (String error : this.errors) {
            ofs = this.field_146289_q.func_78256_a(error) / 2;
            this.func_73731_b(this.field_146289_q, error, xs - ofs, ys += line, 0xEE0A0A);
        }
        super.func_73863_a(x, y, z);
    }

    private void updateValues() {
        int captureWidth = this.getWidth();
        int captureHeight = this.getHeight();
        long captureSize = (long)captureWidth * (long)captureHeight * 3L;
        this.fileSize = I18n.func_135052_a((String)"mineshot.gui.filesize", (Object[])new Object[]{this.getHumanReadableBytes(captureSize)});
        this.warnings.clear();
        if (captureWidth > this.maxViewportWidth || captureHeight > this.maxViewportHeight) {
            this.warnings.add(I18n.func_135052_a((String)"mineshot.gui.warn.tiled", (Object[])new Object[0]));
            this.warnings.add(I18n.func_135052_a((String)"mineshot.gui.warn.shaders", (Object[])new Object[0]));
            this.warnings.add(I18n.func_135052_a((String)"mineshot.gui.warn.gui", (Object[])new Object[0]));
            this.config.setTiled(true);
        } else {
            this.config.setTiled(false);
        }
        this.errors.clear();
        if (captureWidth > 65535 || captureHeight > 65535) {
            this.errors.add(I18n.func_135052_a((String)"mineshot.gui.err.toolarge.targa", (Object[])new Object[0]));
        } else if (captureSize > Integer.MAX_VALUE) {
            this.errors.add(I18n.func_135052_a((String)"mineshot.gui.err.toolarge.mm", (Object[])new Object[0]));
        }
        if (this.errors.isEmpty()) {
            this.config.setCaptureWidth(captureWidth);
            this.config.setCaptureHeight(captureHeight);
            this.doneButton.field_146124_l = true;
        } else {
            this.doneButton.field_146124_l = false;
        }
    }

    private String getHumanReadableBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "i";
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public int getWidth() {
        try {
            return Math.max(1, Integer.parseInt(this.textFieldWidth.func_146179_b()));
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }

    public int getHeight() {
        try {
            return Math.max(1, Integer.parseInt(this.textFieldHeight.func_146179_b()));
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }
}

