/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebombzen.mods.autoswitch.AutoSwitch;
import thebombzen.mods.autoswitch.NotSoRandom;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;

@SideOnly(value=Side.CLIENT)
public final class Tests {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static ItemStack prevHeldItem = null;
    private static Random prevRandom = null;

    public static ItemStack createStackedBlock(Block block, int metadata) {
        return (ItemStack)ThebombzenAPI.invokePrivateMethod((Object)block, Block.class, (String[])new String[]{"createStackedBlock", "func_149644_j", "j"}, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{metadata});
    }

    public static boolean doesFortuneWorkOnBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (block == null) {
            return false;
        }
        int state = AutoSwitch.instance.getConfiguration().getFortuneOverrideState(block, metadata);
        if (state == -1) {
            return false;
        }
        if (state == 1) {
            return true;
        }
        NotSoRandom maxRandom = new NotSoRandom(false);
        NotSoRandom zeroRandom = new NotSoRandom(true);
        Tests.fakeRandomForWorld(world, maxRandom);
        ArrayList defaultMaxRandom = block.getDrops(world, x, y, z, metadata, 0);
        ArrayList fortuneMaxRandom = block.getDrops(world, x, y, z, metadata, 3);
        Tests.unFakeRandomForWorld(world);
        Tests.fakeRandomForWorld(world, zeroRandom);
        ArrayList defaultZeroRandom = block.getDrops(world, x, y, z, metadata, 0);
        ArrayList fortuneZeroRandom = block.getDrops(world, x, y, z, metadata, 3);
        Tests.unFakeRandomForWorld(world);
        return !ThebombzenAPI.areItemStackCollectionsEqual((Collection)defaultMaxRandom, (Collection)fortuneMaxRandom) || !ThebombzenAPI.areItemStackCollectionsEqual((Collection)defaultZeroRandom, (Collection)fortuneZeroRandom);
    }

    public static boolean doesSilkTouchWorkOnBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (block == null) {
            return false;
        }
        int state = AutoSwitch.instance.getConfiguration().getSilkTouchOverrideState(block, metadata);
        if (state == -1) {
            return false;
        }
        if (state == 1) {
            return true;
        }
        boolean silkHarvest = block.canSilkHarvest(world, (EntityPlayer)Tests.mc.field_71439_g, x, y, z, metadata);
        if (!silkHarvest) {
            return false;
        }
        NotSoRandom zeroRandom = new NotSoRandom(true);
        NotSoRandom maxRandom = new NotSoRandom(false);
        ItemStack stackedBlock = Tests.createStackedBlock(block, metadata);
        List<ItemStack> stackedBlockList = Collections.singletonList(stackedBlock);
        Tests.fakeRandomForWorld(world, maxRandom);
        ArrayList defaultMaxRandom = block.getDrops(world, x, y, z, metadata, 0);
        Tests.unFakeRandomForWorld(world);
        Tests.fakeRandomForWorld(world, zeroRandom);
        ArrayList defaultZeroRandom = block.getDrops(world, x, y, z, metadata, 0);
        Tests.unFakeRandomForWorld(world);
        return !ThebombzenAPI.areItemStackCollectionsEqual(stackedBlockList, (Collection)defaultMaxRandom) || !ThebombzenAPI.areItemStackCollectionsEqual(stackedBlockList, (Collection)defaultZeroRandom);
    }

    private static void fakeItemForPlayer(ItemStack itemstack) {
        prevHeldItem = Tests.mc.field_71439_g.field_71071_by.field_70462_a[Tests.mc.field_71439_g.field_71071_by.field_70461_c];
        Tests.mc.field_71439_g.field_71071_by.field_70462_a[Tests.mc.field_71439_g.field_71071_by.field_70461_c] = itemstack;
        if (prevHeldItem != null) {
            Tests.mc.field_71439_g.func_110140_aT().func_111148_a(prevHeldItem.func_111283_C());
        }
        if (itemstack != null) {
            Tests.mc.field_71439_g.func_110140_aT().func_111147_b(itemstack.func_111283_C());
        }
    }

    private static void fakeRandomForWorld(World world, Random random) {
        prevRandom = world.field_73012_v;
        world.field_73012_v = random;
    }

    public static int getAdjustedBlockStr(double blockStr) {
        if (blockStr <= 0.0) {
            return Integer.MIN_VALUE;
        }
        return -MathHelper.func_76143_f((double)(1.0 / blockStr));
    }

    public static float getBlockHardness(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 0.0f;
        }
        return block.func_149712_f(world, x, y, z);
    }

    public static float getBlockStrength(ItemStack itemstack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Tests.fakeItemForPlayer(itemstack);
        float str = block.func_149737_a((EntityPlayer)Tests.mc.field_71439_g, world, x, y, z);
        Tests.unFakeItemForPlayer();
        return str;
    }

    public static float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        return itemstack == null ? 1.0f : itemstack.func_77973_b().getDigSpeed(itemstack, block, metadata);
    }

    public static float getEff(float str, ItemStack itemstack) {
        if (str <= 1.5f) {
            return str;
        }
        Tests.fakeItemForPlayer(itemstack);
        float effLevel = EnchantmentHelper.func_77509_b((EntityLivingBase)Tests.mc.field_71439_g);
        Tests.unFakeItemForPlayer();
        if (effLevel == 0.0f) {
            return str;
        }
        return str + effLevel * effLevel + 1.0f;
    }

    public static float getEnchantmentModifierLiving(ItemStack itemstack, EntityLivingBase entityover) {
        Tests.fakeItemForPlayer(itemstack);
        float modifier = EnchantmentHelper.func_77512_a((EntityLivingBase)Tests.mc.field_71439_g, (EntityLivingBase)entityover);
        Tests.unFakeItemForPlayer();
        return modifier;
    }

    public static int getHarvestLevel(ItemStack itemstack, Block block, int metadata) {
        int state = AutoSwitch.instance.getConfiguration().getHarvestOverrideState(itemstack, block, metadata);
        if (state == -1) {
            return -2;
        }
        if (state == 1) {
            return 2;
        }
        Tests.fakeItemForPlayer(null);
        boolean noTool = Tests.mc.field_71439_g.func_146099_a(block);
        Tests.unFakeItemForPlayer();
        if (noTool) {
            return 0;
        }
        Tests.fakeItemForPlayer(itemstack);
        boolean can = block.canHarvestBlock((EntityPlayer)Tests.mc.field_71439_g, metadata);
        Tests.unFakeItemForPlayer();
        return can ? 1 : -1;
    }

    public static int getFullTinkersConstructItemStackDamage(ItemStack stack, EntityLivingBase entity) throws ClassNotFoundException {
        float lunge;
        NBTTagCompound tags = stack.func_77978_p();
        NBTTagCompound toolTags = stack.func_77978_p().func_74775_l("InfiTool");
        int damage = toolTags.func_74762_e("Attack");
        boolean broken = toolTags.func_74767_n("Broken");
        int durability = tags.func_74775_l("InfiTool").func_74762_e("Damage");
        float stonebound = tags.func_74775_l("InfiTool").func_74760_g("Shoddy");
        float stoneboundDamage = (float)Math.log((float)durability / 72.0f + 1.0f) * -2.0f * stonebound;
        int earlyModDamage = 0;
        Iterable activeModifiers = (Iterable)ThebombzenAPI.getPrivateField(null, Class.forName("tconstruct.library.TConstructRegistry"), (String[])new String[]{"activeModifiers"});
        Class<?> activeToolModClass = Class.forName("tconstruct.library.ActiveToolMod");
        Class<?> toolCoreClass = Class.forName("tconstruct.library.tools.ToolCore");
        Class[] attackModClasses = new Class[]{Integer.TYPE, Integer.TYPE, toolCoreClass, NBTTagCompound.class, NBTTagCompound.class, ItemStack.class, EntityLivingBase.class, Entity.class};
        Item tool = stack.func_77973_b();
        for (Object activeToolMod : activeModifiers) {
            earlyModDamage = (Integer)ThebombzenAPI.invokePrivateMethod(activeToolMod, activeToolModClass, (String)"baseAttackDamage", (Class[])attackModClasses, (Object[])new Object[]{earlyModDamage, damage, tool, tags, toolTags, stack, Tests.mc.field_71439_g, entity});
        }
        damage += earlyModDamage;
        if (Tests.mc.field_71439_g.func_70644_a(Potion.field_76420_g)) {
            damage += 3 << Tests.mc.field_71439_g.func_70660_b(Potion.field_76420_g).func_76458_c();
        }
        if (Tests.mc.field_71439_g.func_70644_a(Potion.field_76437_t)) {
            damage -= 2 << Tests.mc.field_71439_g.func_70660_b(Potion.field_76437_t).func_76458_c();
        }
        float enchantDamage = 0.0f;
        if (entity instanceof EntityLivingBase) {
            enchantDamage = EnchantmentHelper.func_77512_a((EntityLivingBase)Tests.mc.field_71439_g, (EntityLivingBase)entity);
        }
        if ((damage = (int)((float)damage + stoneboundDamage)) < 1) {
            damage = 1;
        }
        if (Tests.mc.field_71439_g.func_70051_ag() && (lunge = ((Float)ThebombzenAPI.invokePrivateMethod((Object)tool, toolCoreClass, (String)"chargeAttack", (Class[])new Class[0], (Object[])new Object[0])).floatValue()) > 1.0f) {
            damage = (int)((float)damage * lunge);
        }
        int modDamage = 0;
        for (Object activeToolMod : activeModifiers) {
            modDamage = (Integer)ThebombzenAPI.invokePrivateMethod(activeToolMod, activeToolModClass, (String)"attackDamage", (Class[])attackModClasses, (Object[])new Object[]{modDamage, damage, tool, tags, toolTags, stack, Tests.mc.field_71439_g, entity});
        }
        if ((damage += modDamage) > 0 || enchantDamage > 0.0f) {
            boolean criticalHit = Tests.mc.field_71439_g.field_70143_R > 0.0f && !Tests.mc.field_71439_g.field_70122_E && !Tests.mc.field_71439_g.func_70617_f_() && !Tests.mc.field_71439_g.func_70090_H() && !Tests.mc.field_71439_g.func_70644_a(Potion.field_76440_q) && Tests.mc.field_71439_g.field_70154_o == null;
            for (Object activeToolMod : activeModifiers) {
                if (((Boolean)ThebombzenAPI.invokePrivateMethod(activeToolMod, activeToolModClass, (String)"doesCriticalHit", (Class[])new Class[]{toolCoreClass, NBTTagCompound.class, NBTTagCompound.class, ItemStack.class, EntityLivingBase.class, Entity.class}, (Object[])new Object[]{tool, tags, toolTags, stack, Tests.mc.field_71439_g, entity})).booleanValue()) {
                    // empty if block
                }
                criticalHit = true;
            }
            if (criticalHit) {
                damage = (int)((float)damage * 1.5f);
            }
            damage = (int)((float)damage + enchantDamage);
            float damageModifier = ((Float)ThebombzenAPI.invokePrivateMethod((Object)tool, toolCoreClass, (String)"getDamageModifier", (Class[])new Class[0], (Object[])new Object[0])).floatValue();
            if (damageModifier != 1.0f) {
                damage = (int)((float)damage * damageModifier);
            }
            if (broken) {
                damage = 1;
            }
            return damage;
        }
        return 0;
    }

    public static double getFullRegularItemStackDamage(ItemStack itemStack, EntityLivingBase entity) {
        Tests.fakeItemForPlayer(itemStack);
        double damage = AutoSwitch.instance.getConfiguration().getCustomWeaponDamage(itemStack);
        if (damage < 0.0) {
            damage = Tests.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
        double enchDamage = EnchantmentHelper.func_77512_a((EntityLivingBase)Tests.mc.field_71439_g, (EntityLivingBase)entity);
        if (damage > 0.0 || enchDamage > 0.0) {
            boolean critical;
            boolean bl = critical = Tests.mc.field_71439_g.field_70143_R > 0.0f && !Tests.mc.field_71439_g.field_70122_E && !Tests.mc.field_71439_g.func_70617_f_() && !Tests.mc.field_71439_g.func_70090_H() && !Tests.mc.field_71439_g.func_70644_a(Potion.field_76440_q) && Tests.mc.field_71439_g.field_70154_o == null;
            if (critical && damage > 0.0) {
                damage *= 1.5;
            }
            damage += enchDamage;
        }
        Tests.unFakeItemForPlayer();
        return damage;
    }

    public static double getFullItemStackDamage(ItemStack itemStack, EntityLivingBase entity) {
        try {
            Class<?> clazz;
            if (itemStack != null && itemStack.func_77978_p() != null && Loader.isModLoaded((String)"TConstruct") && (clazz = Class.forName("tconstruct.library.tools.ToolCore")).isAssignableFrom(itemStack.func_77973_b().getClass())) {
                return Tests.getFullTinkersConstructItemStackDamage(itemStack, entity);
            }
        }
        catch (ClassNotFoundException e) {
            AutoSwitch.instance.throwException("Error in Tinkers Construct Compatability", e, false);
        }
        return Tests.getFullRegularItemStackDamage(itemStack, entity);
    }

    public static Set<Enchantment> getNonstandardNondamageEnchantmentsOnBothStacks(ItemStack stack1, ItemStack stack2) {
        HashSet bothItemsEnchantments = new HashSet();
        HashSet<Enchantment> ret = new HashSet<Enchantment>();
        if (stack1 != null) {
            bothItemsEnchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)stack1).keySet());
        }
        if (stack2 != null) {
            bothItemsEnchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)stack2).keySet());
        }
        for (Integer effectId : bothItemsEnchantments) {
            if (effectId == Enchantment.field_77349_p.field_77352_x || effectId == Enchantment.field_77348_q.field_77352_x || effectId == Enchantment.field_77346_s.field_77352_x || effectId == Enchantment.field_77347_r.field_77352_x || effectId == Enchantment.field_77335_o.field_77352_x || effectId == Enchantment.field_77337_m.field_77352_x || effectId == Enchantment.field_77334_n.field_77352_x || effectId == Enchantment.field_151369_A.field_77352_x || effectId == Enchantment.field_151370_z.field_77352_x || Enchantment.field_77331_b[effectId].func_77320_a().startsWith("enchantment.damage.")) continue;
            ret.add(Enchantment.field_77331_b[effectId]);
        }
        return ret;
    }

    public static int getStrongToolStandardness(ItemStack itemstack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        int state = AutoSwitch.instance.getConfiguration().getStandardToolOverrideState(itemstack, block, metadata);
        if (state == -1) {
            return -3;
        }
        if (state == 1) {
            return 3;
        }
        return Tests.getHarvestLevel(itemstack, block, metadata);
    }

    public static int getToolStandardness(ItemStack itemstack, World world, int x, int y, int z) {
        return Tests.getStrongToolStandardness(itemstack, world, x, y, z) * 3 + Tests.getWeakToolStandardness(itemstack, world, x, y, z);
    }

    public static int getWeakToolStandardness(ItemStack itemstack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        float hardness = Tests.getBlockHardness(world, x, y, z);
        if (hardness <= 0.0f) {
            return 0;
        }
        float blockStrForNull = Tests.getBlockStrength(null, world, x, y, z);
        Tests.fakeItemForPlayer(null);
        boolean harvestable = Tests.mc.field_71439_g.func_146099_a(block);
        Tests.unFakeItemForPlayer();
        float blockStr = Tests.getBlockStrength(itemstack, world, x, y, z);
        Tests.fakeItemForPlayer(itemstack);
        boolean harvest = block.canHarvestBlock((EntityPlayer)Tests.mc.field_71439_g, metadata);
        Tests.unFakeItemForPlayer();
        if (harvest && !harvestable) {
            blockStr *= 0.3f;
        }
        if (blockStr > blockStrForNull * 1.5f) {
            return 1;
        }
        if (Tests.isItemStackDamageableOnBlock(itemstack, world, x, y, z)) {
            return -1;
        }
        return 0;
    }

    public static boolean isItemStackDamageable(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b().func_77645_m();
    }

    public static boolean isItemStackDamageableOnBlock(ItemStack itemstack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        int state = AutoSwitch.instance.getConfiguration().getDamageableOverrideState(itemstack, block, metadata);
        if (state == -1) {
            return false;
        }
        if (state == 1) {
            return true;
        }
        if (!Tests.isItemStackDamageable(itemstack)) {
            return false;
        }
        return Tests.getBlockHardness(world, x, y, z) != 0.0f;
    }

    public static boolean isSword(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (itemstack.func_77973_b() instanceof ItemSword) {
            return true;
        }
        String name = GameRegistry.findUniqueIdentifierFor((Item)itemstack.func_77973_b()).name.toLowerCase();
        return name.endsWith("sword");
    }

    private static void unFakeItemForPlayer() {
        ItemStack fakedStack = Tests.mc.field_71439_g.field_71071_by.field_70462_a[Tests.mc.field_71439_g.field_71071_by.field_70461_c];
        Tests.mc.field_71439_g.field_71071_by.field_70462_a[Tests.mc.field_71439_g.field_71071_by.field_70461_c] = prevHeldItem;
        if (fakedStack != null) {
            Tests.mc.field_71439_g.func_110140_aT().func_111148_a(fakedStack.func_111283_C());
        }
        if (prevHeldItem != null) {
            Tests.mc.field_71439_g.func_110140_aT().func_111147_b(prevHeldItem.func_111283_C());
        }
    }

    private static void unFakeRandomForWorld(World world) {
        world.field_73012_v = prevRandom;
        prevRandom = null;
    }

    private Tests() {
    }
}

