/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch.configuration;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SingleValueIdentifier {
    private ItemStack itemStack = null;
    private Block block = null;
    private int metadata = 0;
    private boolean isItem;

    public SingleValueIdentifier(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
        this.isItem = false;
    }

    public SingleValueIdentifier(ItemStack stack) {
        this.itemStack = stack.func_77946_l();
        this.isItem = true;
    }

    public SingleValueIdentifier(SingleValueIdentifier id) {
        this.isItem = id.isItem;
        this.itemStack = id.itemStack == null ? null : id.itemStack.func_77946_l();
        this.block = id.block;
        this.metadata = id.metadata;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleValueIdentifier other = (SingleValueIdentifier)obj;
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.isItem != other.isItem) {
            return false;
        }
        if (this.itemStack == null ? other.itemStack != null : !this.itemStack.equals(other.itemStack)) {
            return false;
        }
        return this.metadata == other.metadata;
    }

    public Block getBlock() {
        return GameRegistry.findBlock((String)this.getModId(), (String)this.getName());
    }

    public int getDamageValue() {
        if (this.isItem) {
            return this.itemStack.func_77960_j();
        }
        return this.metadata;
    }

    public Item getItem() {
        return GameRegistry.findItem((String)this.getModId(), (String)this.getName());
    }

    public ItemStack getItemStack() {
        if (!this.isItem) {
            return null;
        }
        return this.itemStack;
    }

    public String getModId() {
        return this.getUniqueIdentifier().modId;
    }

    public String getName() {
        return this.getUniqueIdentifier().name;
    }

    public GameRegistry.UniqueIdentifier getUniqueIdentifier() {
        if (this.isItem) {
            return GameRegistry.findUniqueIdentifierFor((Item)this.itemStack.func_77973_b());
        }
        return GameRegistry.findUniqueIdentifierFor((Block)this.block);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + (this.isItem ? 1231 : 1237);
        result = 31 * result + (this.itemStack == null ? 0 : this.itemStack.hashCode());
        result = 31 * result + this.metadata;
        return result;
    }

    public boolean isItem() {
        return this.isItem;
    }

    public void setDamageValue(int damage) {
        if (this.isItem) {
            this.itemStack.func_77964_b(damage);
        } else {
            this.metadata = damage;
        }
    }
}

