/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch.configuration;

import java.util.Scanner;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import thebombzen.mods.autoswitch.configuration.SingleValueIdentifier;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.configuration.BooleanTester;
import thebombzen.mods.thebombzenapi.configuration.ConfigFormatException;

public class ValueSet
implements BooleanTester<SingleValueIdentifier> {
    private int data;
    private int mask;
    private boolean subtract;
    private int min;
    private int max;
    private Enchantment enchantment;

    public static ValueSet parseValueSet(String s) throws ConfigFormatException {
        int second;
        int first;
        String num;
        boolean subtract;
        switch (s.charAt(0)) {
            case '+': {
                subtract = false;
                break;
            }
            case '-': {
                subtract = true;
                break;
            }
            default: {
                throw new ConfigFormatException("Value Set doesn't start with + or -: " + s);
            }
        }
        Scanner scanner = new Scanner(s.substring(1));
        scanner.useDelimiter(":");
        boolean enchant = false;
        if (scanner.hasNext()) {
            num = scanner.next();
            if (Character.toUpperCase(num.charAt(0)) == 'E') {
                num = num.substring(1);
                enchant = true;
            }
            try {
                first = ThebombzenAPI.parseInteger((String)num);
            }
            catch (NumberFormatException nfe) {
                scanner.close();
                throw new ConfigFormatException("Invalid number: " + num);
            }
            if (enchant && (first < 0 || first >= Enchantment.field_77331_b.length || Enchantment.field_77331_b[first] == null)) {
                scanner.close();
                throw new ConfigFormatException("Invalid Enchantment ID: " + first);
            }
        } else {
            scanner.close();
            return new ValueSet(0, 0, subtract);
        }
        if (scanner.hasNext()) {
            num = scanner.next();
            try {
                second = ThebombzenAPI.parseInteger((String)num);
            }
            catch (NumberFormatException nfe) {
                scanner.close();
                throw new ConfigFormatException("Invalid number: " + num);
            }
        } else {
            scanner.close();
            if (enchant) {
                return new ValueSet(Enchantment.field_77331_b[first], 1, Integer.MAX_VALUE, subtract);
            }
            return new ValueSet(first, Integer.MAX_VALUE, subtract);
        }
        if (enchant) {
            if (scanner.hasNext()) {
                int third;
                num = scanner.next();
                scanner.close();
                try {
                    third = ThebombzenAPI.parseInteger((String)num);
                }
                catch (NumberFormatException e) {
                    throw new ConfigFormatException("Invalid number: " + num);
                }
                return new ValueSet(Enchantment.field_77331_b[first], second, third, subtract);
            }
            scanner.close();
            return new ValueSet(Enchantment.field_77331_b[first], second, Integer.MAX_VALUE, subtract);
        }
        scanner.close();
        return new ValueSet(first, second, subtract);
    }

    public ValueSet() {
        this(0, 0, false);
    }

    public ValueSet(Enchantment enchantment, int min, int max, boolean subtract) {
        this.subtract = subtract;
        this.min = min;
        this.max = max;
        this.enchantment = enchantment;
    }

    public ValueSet(int data, int mask, boolean subtract) {
        this.data = data;
        this.mask = mask;
        this.subtract = subtract;
        this.enchantment = null;
    }

    private boolean contains(int value) {
        return (value & this.mask) == this.data;
    }

    private boolean contains(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.enchantment != null) {
            NBTTagList list = stack.func_77986_q();
            if (list == null) {
                return false;
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                short id = list.func_150305_b(i).func_74765_d("id");
                short lvl = list.func_150305_b(i).func_74765_d("lvl");
                if (id != this.enchantment.field_77352_x) continue;
                return lvl >= this.min && lvl <= this.max;
            }
            return false;
        }
        return (stack.func_77960_j() & this.mask) == this.data;
    }

    public boolean contains(SingleValueIdentifier id) {
        if (id.isItem()) {
            return this.contains(id.getItemStack());
        }
        return this.contains(id.getDamageValue());
    }

    public boolean doesSubtract() {
        return this.subtract;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSet other = (ValueSet)obj;
        if (this.data != other.data) {
            return false;
        }
        if (this.enchantment == null ? other.enchantment != null : !this.enchantment.equals(other.enchantment)) {
            return false;
        }
        if (this.mask != other.mask) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        return this.subtract == other.subtract;
    }

    public int getData() {
        return this.data;
    }

    public int getMask() {
        return this.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.data;
        result = 31 * result + (this.enchantment == null ? 0 : this.enchantment.hashCode());
        result = 31 * result + this.mask;
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        result = 31 * result + (this.subtract ? 1231 : 1237);
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.subtract ? 45 : 43);
        if (this.enchantment != null) {
            b.append('E').append("0x").append(Integer.toHexString(this.enchantment.field_77352_x)).append(":0x").append(Integer.toHexString(this.min)).append(":0x").append(Integer.toHexString(this.max));
        } else {
            b.append("0x").append(Integer.toHexString(this.data)).append(":0x").append(Integer.toHexString(this.mask));
        }
        return b.toString();
    }
}

