/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.ClientProxy;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMecha;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.EnumMechaSlotType;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderMecha
extends Render {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ItemRenderer renderer = new ItemRenderer(Minecraft.func_71410_x());

    public RenderMecha() {
        this.field_76989_e = 0.5f;
    }

    public void render(EntityMecha mecha, double d, double d1, double d2, float f, float f1) {
        ItemStack holdingStack;
        float smoothedPitch;
        float dRoll;
        float dPitch;
        float dYaw;
        this.func_110777_b(mecha);
        float scale = 0.0625f;
        MechaType type = mecha.getMechaType();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = mecha.axes.getYaw() - mecha.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = mecha.axes.getPitch() - mecha.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = mecha.axes.getRoll() - mecha.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GL11.glRotatef((float)(-mecha.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        float modelScale = mecha.getMechaType().modelScale;
        GL11.glPushMatrix();
        GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        ModelMecha model = (ModelMecha)type.model;
        if (model != null) {
            model.render(mecha, f1);
        }
        GL11.glPopMatrix();
        if (mecha.isPartIntact(EnumDriveablePart.leftArm)) {
            this.func_110777_b(mecha);
            GL11.glPushMatrix();
            smoothedPitch = 0.0f;
            if (mecha.seats[0] != null) {
                smoothedPitch = mecha.seats[0].prevLooking.getPitch() + (mecha.seats[0].looking.getPitch() - mecha.seats[0].prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GL11.glTranslatef((float)type.leftArmOrigin.x, (float)mecha.getMechaType().leftArmOrigin.y, (float)mecha.getMechaType().leftArmOrigin.z);
            GL11.glRotatef((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderLeftArm(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)(0.0f + type.leftHandModifierY), (float)(-type.armLength - type.leftHandModifierX), (float)(0.0f + type.leftHandModifierZ));
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            if (holdingStack == null) {
                model.renderLeftHand(scale, mecha, f1);
            } else {
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, true, f1);
            }
            GL11.glPopMatrix();
        }
        if (mecha.isPartIntact(EnumDriveablePart.rightArm)) {
            this.func_110777_b(mecha);
            GL11.glPushMatrix();
            smoothedPitch = 0.0f;
            if (mecha.seats[0] != null) {
                smoothedPitch = mecha.seats[0].prevLooking.getPitch() + (mecha.seats[0].looking.getPitch() - mecha.seats[0].prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GL11.glTranslatef((float)type.rightArmOrigin.x, (float)mecha.getMechaType().rightArmOrigin.y, (float)mecha.getMechaType().rightArmOrigin.z);
            GL11.glRotatef((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderRightArm(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)(0.0f + type.rightHandModifierY), (float)(-type.armLength - type.rightHandModifierX), (float)(0.0f + type.rightHandModifierZ));
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (holdingStack == null) {
                model.renderRightHand(scale, mecha, f1);
            } else {
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, false, f1);
            }
            GL11.glPopMatrix();
        }
        if (FlansMod.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            for (DriveablePart part : mecha.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                RenderMecha.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)((float)part.box.x / 16.0f), (double)((float)part.box.y / 16.0f), (double)((float)part.box.z / 16.0f), (double)((float)(part.box.x + part.box.w) / 16.0f), (double)((float)(part.box.y + part.box.h) / 16.0f), (double)((float)(part.box.z + part.box.d) / 16.0f)));
            }
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (PilotGun gun : type.guns) {
                RenderMecha.func_76980_a((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)(gun.position.x - 0.25f), (double)(gun.position.y - 0.25f), (double)(gun.position.z - 0.25f), (double)(gun.position.x + 0.25f), (double)(gun.position.y + 0.25f), (double)(gun.position.z + 0.25f)));
            }
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        if (mecha.isPartIntact(EnumDriveablePart.hips)) {
            this.func_110777_b(mecha);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
            for (dYaw = mecha.legAxes.getYaw() - mecha.prevLegsYaw; dYaw > 180.0f; dYaw -= 360.0f) {
            }
            while (dYaw <= -180.0f) {
                dYaw += 360.0f;
            }
            GL11.glRotatef((float)(-dYaw * f1 - mecha.prevLegsYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            if (model != null) {
                float legLength = type.legLength;
                float legsYaw = (float)Math.sin(((float)mecha.field_70173_aa + f1) / type.legSwingTime) * mecha.legSwing;
                float footH = (float)Math.sin(legsYaw) * legLength;
                float footV = (float)Math.cos(legsYaw) * legLength;
                model.renderHips(scale, mecha, f1);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)legLength, (float)0.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)footH, (float)(-footV), (float)0.0f);
                model.renderLeftFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(-footH), (float)(-footV), (float)0.0f);
                model.renderRightFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
                model.renderLeftLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
                model.renderRightLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }

    public void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        this.render((EntityMecha)entity, d0, d1, d2, f, f1);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return FlansModResourceHandler.getTexture(((EntityMecha)entity).getMechaType());
    }

    private void renderItem(EntityMecha mecha, ItemStack stack, int par3, boolean leftHand, float dT) {
        GL11.glPushMatrix();
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Item item = stack.func_77973_b();
        if (item instanceof ItemMechaAddon) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            ItemMechaAddon toolItem = (ItemMechaAddon)item;
            MechaItemType toolType = toolItem.type;
            this.func_110776_a(FlansModResourceHandler.getTexture(toolType));
            if (toolType.model != null) {
                toolType.model.render(mecha, dT);
                GL11.glPushMatrix();
                if (leftHand && mecha.leftMouseHeld || !leftHand && mecha.rightMouseHeld) {
                    GL11.glRotatef((float)(25.0f * (float)mecha.field_70173_aa), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                toolType.model.renderDrill(mecha, dT);
                GL11.glPopMatrix();
                toolType.model.renderSaw(mecha, dT, leftHand && mecha.leftMouseHeld || !leftHand && mecha.rightMouseHeld);
            }
        } else if (item instanceof ItemGun && ((ItemGun)item).type.model != null) {
            GunType gunType = ((ItemGun)item).type;
            ModelGun model = gunType.model;
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            texturemanager.func_110577_a(FlansModResourceHandler.getTexture(gunType));
            ClientProxy.gunRenderer.renderGun(stack, gunType, 0.0625f, model, leftHand ? mecha.leftAnimations : mecha.rightAnimations, 0.0f);
        } else {
            IIcon icon = stack.func_77954_c();
            if (icon == null) {
                GL11.glPopMatrix();
                return;
            }
            texturemanager.func_110577_a(texturemanager.func_130087_a(stack.func_94608_d()));
            Tessellator tessellator = Tessellator.field_78398_a;
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            float f4 = 0.0f;
            float f5 = 0.3f;
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
            float f6 = 1.5f;
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.2f, (float)0.7f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-133.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            if (stack.hasEffect(par3)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                texturemanager.func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f7 = 0.76f;
                GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }
}

