/*
 * Decompiled with CFR 0.152.
 */
package jinngine.collision;

import java.util.List;
import jinngine.collision.GJK;
import jinngine.geometry.SupportMap3;
import jinngine.math.Vector3;

public final class RayCast {
    final GJK gjk = new GJK();
    final GJK.State gjkstate = this.gjk.getState();

    public final double run(SupportMap3 Sb, final SupportMap3 Sc, Vector3 point, Vector3 direction, Vector3 pb, Vector3 pc, double lambda, double envelope, double epsilon) {
        int iterations = 0;
        final Vector3 x = point.add(direction.multiply(lambda));
        SupportMap3 Sa = Sc == null ? new SupportMap3(){

            @Override
            public final Vector3 supportPoint(Vector3 direction) {
                return x.copy();
            }

            @Override
            public final void supportFeature(Vector3 d, double epsilon, List<Vector3> returnList) {
            }
        } : new SupportMap3(){

            @Override
            public final Vector3 supportPoint(Vector3 direction) {
                return x.add(Sc.supportPoint(direction));
            }

            @Override
            public final void supportFeature(Vector3 d, double epsilon, List<Vector3> returnList) {
            }
        };
        Vector3 v = this.gjkstate.v;
        Vector3 w = this.gjkstate.w;
        while (true) {
            this.gjk.run(Sa, Sb, pc, pb, envelope, epsilon, 31);
            if (v.norm() < envelope || ++iterations > 31) break;
            if (v.normalize().dot(direction) >= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            Vector3 vs = v.minus(v.normalize().multiply(envelope * 0.5));
            x.assign(point.add(direction.multiply(lambda -= vs.dot(w) / v.dot(direction))));
        }
        return lambda;
    }
}

