/*
 * Decompiled with CFR 0.152.
 */
package jinngine.collision;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jinngine.collision.BroadphaseCollisionDetection;
import jinngine.geometry.BoundingBox;
import jinngine.geometry.Geometry;
import jinngine.math.Vector3;
import jinngine.util.Pair;

public class SweepAndPrune
implements BroadphaseCollisionDetection {
    private final int MAX_GEOMETRIES = 2500;
    private int geometries = 0;
    private final List<BroadphaseCollisionDetection.Handler> handlers = new ArrayList<BroadphaseCollisionDetection.Handler>();
    private final SweepPoint[] xAxis = new SweepPoint[2500];
    private final SweepPoint[] yAxis = new SweepPoint[2500];
    private final SweepPoint[] zAxis = new SweepPoint[2500];
    private final Map<Pair<Geometry>, Integer> counters = new LinkedHashMap<Pair<Geometry>, Integer>();
    private final Set<Pair<Geometry>> overlappingPairs = new LinkedHashSet<Pair<Geometry>>();
    private final Set<Pair<Geometry>> incomming = new LinkedHashSet<Pair<Geometry>>();
    private final Set<Pair<Geometry>> leaving = new LinkedHashSet<Pair<Geometry>>();

    public SweepAndPrune() {
    }

    public SweepAndPrune(BroadphaseCollisionDetection.Handler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void add(Geometry a) {
        this.xAxis[this.geometries * 2] = new SweepPoint(a, 0, true);
        this.xAxis[this.geometries * 2 + 1] = new SweepPoint(a, 0, false);
        this.yAxis[this.geometries * 2] = new SweepPoint(a, 1, true);
        this.yAxis[this.geometries * 2 + 1] = new SweepPoint(a, 1, false);
        this.zAxis[this.geometries * 2] = new SweepPoint(a, 2, true);
        this.zAxis[this.geometries * 2 + 1] = new SweepPoint(a, 2, false);
        ++this.geometries;
    }

    private final void sort(SweepPoint[] A, Map<Pair<Geometry>, Integer> counters, Set<Pair<Geometry>> pairs, Set<Pair<Geometry>> incomming, Set<Pair<Geometry>> leaving) {
        block0: for (int i = 1; i < this.geometries * 2; ++i) {
            SweepPoint pivot = A[i];
            pivot.updateValue();
            double ei = pivot.value;
            int j = i - 1;
            while (j >= 0) {
                Pair<Geometry> pair;
                Integer counter;
                SweepPoint e = A[j];
                e.updateValue();
                if (!(e.value > ei)) continue block0;
                A[j + 1] = A[j];
                A[j] = pivot;
                --j;
                if (!e.begin && pivot.begin) {
                    counter = counters.get(new Pair<Geometry>(e.geometry, pivot.geometry));
                    if (counter == null) {
                        counter = new Integer(0);
                    }
                    counter = counter + 1;
                    counters.put(new Pair<Geometry>(e.geometry, pivot.geometry), counter);
                    if (counter == 3) {
                        pair = new Pair<Geometry>(e.geometry, pivot.geometry);
                        pairs.add(pair);
                        incomming.add(pair);
                        leaving.remove(pair);
                    }
                }
                if (!e.begin || pivot.begin) continue;
                counter = counters.get(new Pair<Geometry>(e.geometry, pivot.geometry));
                if (counter == null) {
                    System.out.println("why does this happen?");
                    System.exit(0);
                    continue block0;
                }
                counter = counter - 1;
                counters.put(new Pair<Geometry>(e.geometry, pivot.geometry), counter);
                if (counter != 2) continue;
                pair = new Pair<Geometry>(e.geometry, pivot.geometry);
                pairs.remove(pair);
                if (incomming.remove(pair)) continue;
                leaving.add(pair);
            }
        }
    }

    public Iterator<Pair<Geometry>> overlappingPairs() {
        return this.overlappingPairs.iterator();
    }

    @Override
    public void remove(Geometry a) {
        SweepPoint p;
        int i = 0;
        int j = 0;
        while (j < this.geometries * 2) {
            p = this.xAxis[j];
            if (p.geometry == a) {
                ++j;
                continue;
            }
            this.xAxis[i] = this.xAxis[j];
            ++i;
            ++j;
        }
        i = 0;
        j = 0;
        while (j < this.geometries * 2) {
            p = this.yAxis[j];
            if (p.geometry == a) {
                ++j;
                continue;
            }
            this.yAxis[i] = this.yAxis[j];
            ++i;
            ++j;
        }
        i = 0;
        j = 0;
        while (j < this.geometries * 2) {
            p = this.zAxis[j];
            if (p.geometry == a) {
                ++j;
                continue;
            }
            this.zAxis[i] = this.zAxis[j];
            ++i;
            ++j;
        }
        Iterator<Pair<Geometry>> iter = this.overlappingPairs.iterator();
        while (iter.hasNext()) {
            Pair<Geometry> gp = iter.next();
            if (!gp.contains(a)) continue;
            this.counters.remove(gp);
            for (BroadphaseCollisionDetection.Handler handler : this.handlers) {
                handler.separation(gp);
            }
            iter.remove();
        }
        --this.geometries;
    }

    @Override
    public void run() {
        this.incomming.clear();
        this.leaving.clear();
        this.sort(this.xAxis, this.counters, this.overlappingPairs, this.incomming, this.leaving);
        this.sort(this.yAxis, this.counters, this.overlappingPairs, this.incomming, this.leaving);
        this.sort(this.zAxis, this.counters, this.overlappingPairs, this.incomming, this.leaving);
        for (Pair<Geometry> p : this.incomming) {
            for (BroadphaseCollisionDetection.Handler handler : this.handlers) {
                handler.overlap(p);
            }
        }
        for (Pair<Geometry> p : this.leaving) {
            for (BroadphaseCollisionDetection.Handler handler : this.handlers) {
                handler.separation(p);
            }
        }
    }

    @Override
    public void addHandler(BroadphaseCollisionDetection.Handler h) {
        this.handlers.add(h);
    }

    @Override
    public void removeHandler(BroadphaseCollisionDetection.Handler h) {
        this.handlers.remove(h);
    }

    @Override
    public Set<Pair<Geometry>> getOverlappingPairs() {
        return new HashSet<Pair<Geometry>>(this.overlappingPairs);
    }

    private final class SweepPoint {
        public final Geometry geometry;
        public final BoundingBox aabb;
        public final boolean begin;
        public final int axis;
        public double value;
        public boolean delete = false;

        public SweepPoint(Geometry geo, int axis, boolean begin) {
            this.geometry = geo;
            this.aabb = geo;
            this.begin = begin;
            this.axis = axis;
            this.updateValue();
        }

        public final void updateValue() {
            Vector3 thisBounds = this.begin ? this.aabb.getMinBounds() : this.aabb.getMaxBounds();
            this.value = thisBounds.get(this.axis);
        }
    }
}

