/*
 * Decompiled with CFR 0.152.
 */
package jinngine.geometry;

import java.util.List;
import jinngine.geometry.Geometry;
import jinngine.geometry.Material;
import jinngine.geometry.SupportMap3;
import jinngine.math.InertiaMatrix;
import jinngine.math.Matrix3;
import jinngine.math.Matrix4;
import jinngine.math.Transforms;
import jinngine.math.Vector3;
import jinngine.physics.Body;

public class Sphere
implements SupportMap3,
Geometry,
Material {
    private Body body;
    private double radius;
    private final Vector3 displacement = new Vector3();
    private final Matrix4 transform4 = new Matrix4();
    private final Matrix4 localtransform4 = new Matrix4();
    private double envelope = 1.0;
    private Object auxiliary;
    private double restitution = 0.7;
    private double friction = 0.5;
    private double mass;

    @Override
    public Object getAuxiliary() {
        return this.auxiliary;
    }

    @Override
    public void setAuxiliary(Object auxiliary) {
        this.auxiliary = auxiliary;
    }

    public Sphere(double radius) {
        this.radius = radius;
        this.mass = 4.1887902047863905 * radius * radius * radius;
        this.envelope = 1.0;
        this.setLocalTransform(Matrix3.identity(), new Vector3());
    }

    public final double getRadius() {
        return this.radius;
    }

    @Override
    public Vector3 supportPoint(Vector3 direction) {
        return direction.normalize().multiply(this.radius).add(this.body.state.position).add(Matrix3.multiply(this.body.state.rotation, this.displacement, new Vector3()));
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public double getEnvelope() {
        return this.envelope;
    }

    @Override
    public Vector3 getMaxBounds() {
        return this.body.state.position.add(Matrix3.multiply(this.body.state.rotation, this.displacement, new Vector3())).add(new Vector3(this.radius + this.envelope, this.radius + this.envelope, this.radius + this.envelope));
    }

    @Override
    public Vector3 getMinBounds() {
        return this.body.state.position.add(Matrix3.multiply(this.body.state.rotation, this.displacement, new Vector3())).add(new Vector3(-this.radius - this.envelope, -this.radius - this.envelope, -this.radius - this.envelope));
    }

    @Override
    public InertiaMatrix getInertialMatrix() {
        double r = this.radius;
        InertiaMatrix I = new InertiaMatrix();
        Matrix3.set(I, (double)0.4f * this.mass * r * r, 0.0, 0.0, 0.0, (double)0.4f * this.mass * r * r, 0.0, 0.0, 0.0, (double)0.4f * this.mass * r * r);
        return I;
    }

    @Override
    public void setBody(Body b) {
        this.body = b;
    }

    @Override
    public void setLocalTransform(Matrix3 B, Vector3 b2) {
        this.displacement.assign(b2);
        Matrix4.set(Transforms.transformAndTranslate4(Matrix3.identity().multiply(this.radius), this.displacement), this.localtransform4);
    }

    @Override
    public void getLocalTranslation(Vector3 t) {
        t.assign(this.displacement);
    }

    @Override
    public Matrix4 getTransform() {
        return Matrix4.multiply(this.body.state.transform, this.localtransform4, this.transform4);
    }

    @Override
    public void setEnvelope(double envelope) {
    }

    @Override
    public void supportFeature(Vector3 d, double epsilon, List<Vector3> ret) {
        ret.add(d.normalize().multiply(this.radius).add(this.body.state.position).add(Matrix3.multiply(this.body.state.rotation, this.displacement, new Vector3())));
    }

    @Override
    public double getFrictionCoefficient() {
        return this.friction;
    }

    @Override
    public double getRestitution() {
        return this.restitution;
    }

    @Override
    public void setFrictionCoefficient(double f) {
        this.friction = f;
    }

    @Override
    public void setRestitution(double e) {
        this.restitution = e;
    }

    @Override
    public void getLocalTransform(Matrix3 R, Vector3 b) {
        R.assign(Matrix3.identity());
        b.assign(this.displacement);
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public void setLocalScale(Vector3 s) {
        throw new UnsupportedOperationException();
    }
}

