/*
 * Decompiled with CFR 0.152.
 */
package jinngine.math;

import jinngine.math.Matrix3;
import jinngine.math.Matrix4;
import jinngine.math.Quaternion;
import jinngine.math.Vector3;

public final class Transforms {
    public static final Matrix4 translate4(Vector3 r) {
        Matrix4 T = new Matrix4();
        Matrix4.identity(T);
        T.a14 = r.x;
        T.a24 = r.y;
        T.a34 = r.z;
        return T;
    }

    public static final Vector3 translation(Matrix4 M) {
        return new Vector3(M.a14, M.a24, M.a34);
    }

    public static final Matrix4 rotate4(Quaternion q) {
        Matrix4 M = new Matrix4();
        Vector3 v = q.v;
        double s = q.s;
        M.a11 = 1.0 - 2.0 * (v.y * v.y + v.z * v.z);
        M.a12 = 2.0 * v.x * v.y - 2.0 * s * v.z;
        M.a13 = 2.0 * s * v.y + 2.0 * v.x * v.z;
        M.a21 = 2.0 * v.x * v.y + 2.0 * s * v.z;
        M.a22 = 1.0 - 2.0 * (v.x * v.x + v.z * v.z);
        M.a23 = -2.0 * s * v.x + 2.0 * v.y * v.z;
        M.a31 = -2.0 * s * v.y + 2.0 * v.x * v.z;
        M.a32 = 2.0 * s * v.x + 2.0 * v.y * v.z;
        M.a33 = 1.0 - 2.0 * (v.x * v.x + v.y * v.y);
        M.a44 = 1.0;
        return M;
    }

    public static final Matrix4 rotateAndTranslate4(Quaternion q, Vector3 r) {
        Matrix4 M = new Matrix4();
        Vector3 v = q.v;
        double s = q.s;
        M.a11 = 1.0 - 2.0 * (v.y * v.y + v.z * v.z);
        M.a12 = 2.0 * v.x * v.y - 2.0 * s * v.z;
        M.a13 = 2.0 * s * v.y + 2.0 * v.x * v.z;
        M.a14 = r.x;
        M.a21 = 2.0 * v.x * v.y + 2.0 * s * v.z;
        M.a22 = 1.0 - 2.0 * (v.x * v.x + v.z * v.z);
        M.a23 = -2.0 * s * v.x + 2.0 * v.y * v.z;
        M.a24 = r.y;
        M.a31 = -2.0 * s * v.y + 2.0 * v.x * v.z;
        M.a32 = 2.0 * s * v.x + 2.0 * v.y * v.z;
        M.a33 = 1.0 - 2.0 * (v.x * v.x + v.y * v.y);
        M.a34 = r.z;
        M.a44 = 1.0;
        return M;
    }

    public static final Matrix4 transformAndTranslate4(Matrix3 B, Vector3 r) {
        Matrix4 M = new Matrix4();
        M.a11 = B.a11;
        M.a12 = B.a12;
        M.a13 = B.a13;
        M.a14 = r.x;
        M.a21 = B.a21;
        M.a22 = B.a22;
        M.a23 = B.a23;
        M.a24 = r.y;
        M.a31 = B.a31;
        M.a32 = B.a32;
        M.a33 = B.a33;
        M.a34 = r.z;
        M.a44 = 1.0;
        return M;
    }

    public static final Matrix4 scale(Vector3 s) {
        Matrix4 M = new Matrix4();
        M.a11 = s.x;
        M.a12 = 0.0;
        M.a13 = 0.0;
        M.a14 = 0.0;
        M.a21 = 0.0;
        M.a22 = s.y;
        M.a23 = 0.0;
        M.a24 = 0.0;
        M.a31 = 0.0;
        M.a32 = 0.0;
        M.a33 = s.z;
        M.a34 = 0.0;
        M.a44 = 1.0;
        return M;
    }
}

