/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics;

import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.DeactivationPolicy;

public class DefaultDeactivationPolicy
implements DeactivationPolicy {
    @Override
    public boolean shouldBeDeactivated(Body b) {
        double accel = b.deltavelocity.add(b.externaldeltavelocity).squaredNorm();
        return b.totalKinetic() / b.state.mass + (accel += b.deltaomega.add(b.externaldeltaomega).squaredNorm()) < 0.001;
    }

    @Override
    public boolean shouldBeActivated(Body b) {
        double accel = b.deltavelocity.add(b.externaldeltavelocity).squaredNorm();
        return (accel += b.deltaomega.add(b.externaldeltaomega).squaredNorm()) > 0.1;
    }

    @Override
    public void activate(Body b) {
        b.deactivated = false;
    }

    @Override
    public void deactivate(Body b) {
        b.deactivated = true;
        b.state.velocity.assign(Vector3.zero);
        b.state.omega.assign(Vector3.zero);
    }
}

