/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver;

import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.solver.Solver;

public class ConjugateGradients
implements Solver {
    int maxIterations = 0;

    @Override
    public void setMaximumIterations(int n) {
        this.maxIterations = n;
    }

    @Override
    public double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        double delta_low;
        this.maxIterations = constraints.size();
        double delta_new = 0.0;
        double delta_old = 0.0;
        double delta_zero = 0.0;
        double delta_best = delta_low = Double.POSITIVE_INFINITY;
        double division_epsilon = 1.0E-12;
        int iterations = 0;
        for (Body b : bodies) {
            b.auxDeltav.assignZero();
            b.auxDeltaOmega.assignZero();
        }
        for (Solver.NCPConstraint ci : constraints) {
            ci.residual = -ci.b - ci.j1.dot(ci.body1.deltavelocity.add(ci.body1.externaldeltavelocity)) - ci.j2.dot(ci.body1.deltaomega.add(ci.body1.externaldeltaomega)) - ci.j3.dot(ci.body2.deltavelocity.add(ci.body2.externaldeltavelocity)) - ci.j4.dot(ci.body2.deltaomega.add(ci.body2.externaldeltaomega)) - ci.lambda * ci.damper;
            ci.d = ci.residual / (ci.diagonal + ci.damper);
            if (Math.abs(ci.diagonal) < 1.0E-13) {
                System.exit(0);
            }
            Vector3.add(ci.body1.auxDeltav, ci.b1.multiply(ci.d));
            Vector3.add(ci.body1.auxDeltaOmega, ci.b2.multiply(ci.d));
            Vector3.add(ci.body2.auxDeltav, ci.b3.multiply(ci.d));
            Vector3.add(ci.body2.auxDeltaOmega, ci.b4.multiply(ci.d));
            delta_new += ci.residual * ci.d;
        }
        delta_old = delta_new;
        delta_zero = delta_new;
        delta_best = delta_new;
        while (iterations < this.maxIterations && delta_new > epsilon * epsilon * delta_zero && delta_new > epsilon) {
            double dTq = 0.0;
            for (Solver.NCPConstraint ci : constraints) {
                ci.q = ci.j1.dot(ci.body1.auxDeltav) + ci.j2.dot(ci.body1.auxDeltaOmega) + ci.j3.dot(ci.body2.auxDeltav) + ci.j4.dot(ci.body2.auxDeltaOmega) + ci.d * ci.damper;
                dTq += ci.d * ci.q;
            }
            if (Math.abs(dTq) < division_epsilon) {
                if (iterations != 0) break;
                delta_best = Double.POSITIVE_INFINITY;
                break;
            }
            double alpha = delta_new / dTq;
            delta_old = delta_new;
            delta_new = 0.0;
            for (Solver.NCPConstraint ci : constraints) {
                ci.dlambda += alpha * ci.d;
                ci.residual -= alpha * ci.q;
                ci.s = ci.residual / (ci.diagonal + ci.damper);
                delta_new += ci.residual * ci.s;
            }
            boolean best_updated = false;
            if (delta_new < delta_best) {
                delta_best = delta_new;
                best_updated = true;
            }
            if (Math.abs(delta_old) < division_epsilon || delta_new > 100.0 * delta_zero) break;
            double beta = delta_new / delta_old;
            for (Body b : bodies) {
                Vector3.multiply(b.auxDeltav, beta);
                Vector3.multiply(b.auxDeltaOmega, beta);
            }
            for (Solver.NCPConstraint ci : constraints) {
                ci.d = ci.s + beta * ci.d;
                Vector3.add(ci.body1.auxDeltav, ci.b1.multiply(ci.s));
                Vector3.add(ci.body1.auxDeltaOmega, ci.b2.multiply(ci.s));
                Vector3.add(ci.body2.auxDeltav, ci.b3.multiply(ci.s));
                Vector3.add(ci.body2.auxDeltaOmega, ci.b4.multiply(ci.s));
                if (!best_updated) continue;
                ci.bestdlambda = ci.dlambda;
            }
            ++iterations;
        }
        for (Solver.NCPConstraint ci : constraints) {
            ci.lambda += ci.bestdlambda;
            Vector3.add(ci.body1.deltavelocity, ci.b1.multiply(ci.bestdlambda));
            Vector3.add(ci.body1.deltaomega, ci.b2.multiply(ci.bestdlambda));
            Vector3.add(ci.body2.deltavelocity, ci.b3.multiply(ci.bestdlambda));
            Vector3.add(ci.body2.deltaomega, ci.b4.multiply(ci.bestdlambda));
            ci.dlambda = 0.0;
            ci.bestdlambda = 0.0;
        }
        return iterations + 1;
    }
}

