/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver.experimental;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.solver.Solver;

public class FischerNewton
implements Solver {
    private int linemax = 25;
    private int imax = 25;
    private int cgmax = 25;
    private double epsilon = 1.0E-29;
    double damper = 0.0;
    List<Solver.NCPConstraint> normals = new ArrayList<Solver.NCPConstraint>();

    @Override
    public void setMaximumIterations(int n) {
    }

    public void setMaximumCGIterations(int n) {
    }

    public void setLinesearchIterations(int n) {
    }

    public void setDamping(double d) {
    }

    public void setFrictionDamping(double d) {
    }

    private static double fisher(double a, double b) {
        return Math.sqrt(a * a + b * b) - (a + b);
    }

    @Override
    public double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        this.normals.clear();
        for (Solver.NCPConstraint ci : constraints) {
            if (ci.coupling != null) continue;
            this.normals.add(ci);
        }
        this.solveInternal(this.normals, bodies);
        this.damper = 0.0;
        this.solveInternal(constraints, bodies);
        return 0.0;
    }

    public double solveInternal(List<Solver.NCPConstraint> constraints, List<Body> bodies) {
        int n = constraints.size();
        double error = 0.0;
        double besterror = Double.POSITIVE_INFINITY;
        double squarederror = 0.0;
        int i = 0;
        double mu = 1.0;
        double truncatevelocity = 0.0;
        for (Solver.NCPConstraint ci : constraints) {
            double w = ci.j1.dot(ci.body1.deltavelocity) + ci.j2.dot(ci.body1.deltaomega) + ci.j3.dot(ci.body2.deltavelocity) + ci.j4.dot(ci.body2.deltaomega) + ci.b + this.damper * ci.lambda;
            if (ci.lower == Double.NEGATIVE_INFINITY && ci.upper == Double.POSITIVE_INFINITY) {
                ci.fischer = w;
            } else if (ci.coupling == null) {
                ci.fischer = Math.sqrt(w * w + ci.lambda * ci.lambda) - w - ci.lambda;
            } else {
                double limit = Math.abs(ci.coupling.lambda) * mu;
                ci.lower = -limit;
                ci.upper = limit;
                if (Math.abs(w) < truncatevelocity) {
                    w = 0.0;
                }
                ci.fischer = FischerNewton.fisher(ci.lambda - ci.lower, FischerNewton.fisher(ci.upper - ci.lambda, -w));
            }
            squarederror += ci.fischer * ci.fischer;
        }
        error = Math.sqrt(squarederror);
        while (true) {
            double delta;
            if (error < this.epsilon || i > this.imax) {
                System.out.println("e=" + error + ", i = " + i + " imax=" + this.imax);
                if (besterror < error) {
                    for (Body b : bodies) {
                        Vector3.assign(b.deltavelocity, b.auxDeltav2);
                        Vector3.assign(b.deltaomega, b.auxDeltaOmega2);
                    }
                    return besterror;
                }
                return error;
            }
            double tol = 0.0;
            tol = error < 1.0 ? 0.5 * error * error : 0.5 * Math.sqrt(error);
            double[] r = new double[n];
            double[] d = new double[n];
            double[] z = new double[n];
            double[] z_low = new double[n];
            double[] dk = new double[n];
            double[] q = new double[n];
            double delta_new = 0.0;
            double h = 1.0E-6;
            int k = 0;
            int j = 0;
            for (Solver.NCPConstraint ci : constraints) {
                r[j] = ci.fischer;
                d[j] = r[j];
                ++j;
            }
            for (j = 0; j < n; ++j) {
                delta_new += r[j] * r[j];
            }
            double delta_old = delta_new;
            double delta_low = Double.POSITIVE_INFINITY;
            while (true) {
                if (delta_new < tol) {
                    for (j = 0; j < n; ++j) {
                        dk[j] = z[j];
                    }
                    break;
                }
                if (delta_new < delta_low) {
                    delta_low = delta_new;
                    for (j = 0; j < n; ++j) {
                        z_low[j] = z[j];
                    }
                }
                if (k > this.cgmax) {
                    for (j = 0; j < n; ++j) {
                        dk[j] = z_low[j];
                    }
                    break;
                }
                for (Body b : bodies) {
                    b.auxDeltaOmega.assignZero();
                    b.auxDeltav.assignZero();
                }
                j = 0;
                for (Solver.NCPConstraint ci : constraints) {
                    delta = d[j] * h;
                    Vector3.add(ci.body1.auxDeltav, ci.b1.multiply(delta));
                    Vector3.add(ci.body1.auxDeltaOmega, ci.b2.multiply(delta));
                    Vector3.add(ci.body2.auxDeltav, ci.b3.multiply(delta));
                    Vector3.add(ci.body2.auxDeltaOmega, ci.b4.multiply(delta));
                    ++j;
                }
                j = 0;
                for (Solver.NCPConstraint ci : constraints) {
                    double lambda = ci.lambda + d[j] * h;
                    double w = ci.j1.dot(ci.body1.deltavelocity.add(ci.body1.auxDeltav)) + ci.j2.dot(ci.body1.deltaomega.add(ci.body1.auxDeltaOmega)) + ci.j3.dot(ci.body2.deltavelocity.add(ci.body2.auxDeltav)) + ci.j4.dot(ci.body2.deltaomega.add(ci.body2.auxDeltaOmega)) + ci.b + this.damper * lambda;
                    if (ci.lower == Double.NEGATIVE_INFINITY && ci.upper == Double.POSITIVE_INFINITY) {
                        q[j] = (w - ci.fischer) / h;
                    } else if (ci.coupling == null) {
                        q[j] = (Math.sqrt(w * w + lambda * lambda) - w - lambda - ci.fischer) / h;
                    } else {
                        double limit = Math.abs(ci.coupling.lambda) * mu;
                        ci.lower = -limit;
                        ci.upper = limit;
                        q[j] = (FischerNewton.fisher(lambda - ci.lower, FischerNewton.fisher(ci.upper - lambda, -w)) - ci.fischer) / h;
                    }
                    ++j;
                }
                double dTq = 0.0;
                for (j = 0; j < n; ++j) {
                    dTq += d[j] * q[j];
                }
                double alpha = delta_new / dTq;
                for (j = 0; j < n; ++j) {
                    int n2 = j;
                    z[n2] = z[n2] - alpha * d[j];
                }
                for (j = 0; j < n; ++j) {
                    int n3 = j;
                    r[n3] = r[n3] - alpha * q[j];
                }
                delta_old = delta_new;
                delta_new = 0.0;
                for (j = 0; j < n; ++j) {
                    delta_new += r[j] * r[j];
                }
                double beta = delta_new / delta_old;
                for (j = 0; j < n; ++j) {
                    d[j] = r[j] + beta * d[j];
                }
                ++k;
            }
            for (Body b : bodies) {
                b.auxDeltaOmega.assignZero();
                b.auxDeltav.assignZero();
            }
            j = 0;
            for (Solver.NCPConstraint ci : constraints) {
                delta = dk[j];
                ci.lambda += dk[j];
                Vector3.add(ci.body1.auxDeltav, ci.b1.multiply(delta));
                Vector3.add(ci.body1.auxDeltaOmega, ci.b2.multiply(delta));
                Vector3.add(ci.body2.auxDeltav, ci.b3.multiply(delta));
                Vector3.add(ci.body2.auxDeltaOmega, ci.b4.multiply(delta));
                Vector3.add(ci.body1.deltavelocity, ci.b1.multiply(delta));
                Vector3.add(ci.body1.deltaomega, ci.b2.multiply(delta));
                Vector3.add(ci.body2.deltavelocity, ci.b3.multiply(delta));
                Vector3.add(ci.body2.deltaomega, ci.b4.multiply(delta));
                ++j;
            }
            k = 0;
            double step = 1.0;
            double oldsquarederror = squarederror;
            block19: while (true) {
                squarederror = 0.0;
                j = 0;
                for (Solver.NCPConstraint ci : constraints) {
                    double w = ci.j1.dot(ci.body1.deltavelocity) + ci.j2.dot(ci.body1.deltaomega) + ci.j3.dot(ci.body2.deltavelocity) + ci.j4.dot(ci.body2.deltaomega) + ci.b + this.damper * ci.lambda;
                    if (k > 0) {
                        ci.lambda += -step * dk[j];
                    }
                    if (ci.lower == Double.NEGATIVE_INFINITY && ci.upper == Double.POSITIVE_INFINITY) {
                        ci.fischer = w;
                    } else if (ci.coupling == null) {
                        ci.fischer = Math.sqrt(w * w + ci.lambda * ci.lambda) - w - ci.lambda;
                    } else {
                        double limit = Math.abs(ci.coupling.lambda) * mu;
                        ci.lower = -limit;
                        ci.upper = limit;
                        if (Math.abs(w) < truncatevelocity) {
                            w = 0.0;
                        }
                        ci.fischer = FischerNewton.fisher(ci.lambda - ci.lower, FischerNewton.fisher(ci.upper - ci.lambda, -w));
                    }
                    squarederror += ci.fischer * ci.fischer;
                    ++j;
                }
                error = Math.sqrt(squarederror);
                if (0.5 * squarederror <= 0.5 * oldsquarederror + step * 0.01 * -oldsquarederror || k >= this.linemax) break;
                step = Math.pow(2.0, -(++k));
                Iterator<Object> i$ = bodies.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block19;
                    Body b = (Body)i$.next();
                    Vector3.add(b.deltavelocity, b.auxDeltav.multiply(-step));
                    Vector3.add(b.deltaomega, b.auxDeltaOmega.multiply(-step));
                }
                break;
            }
            if (error < besterror) {
                besterror = error;
                for (Body b : bodies) {
                    Vector3.assign(b.auxDeltav2, b.deltavelocity);
                    Vector3.assign(b.auxDeltaOmega2, b.deltaomega);
                }
            }
            ++i;
        }
    }

    public static double fischerMerit(List<Solver.NCPConstraint> constraints, List<Body> bodies) {
        double phi = 0.0;
        for (Solver.NCPConstraint ci : constraints) {
            double p;
            double w = ci.j1.dot(ci.body1.deltavelocity) + ci.j2.dot(ci.body1.deltaomega) + ci.j3.dot(ci.body2.deltavelocity) + ci.j4.dot(ci.body2.deltaomega) + ci.b + ci.lambda * ci.damper;
            double upper = ci.upper;
            double lower = ci.lower;
            if (ci.coupling != null) {
                upper = Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                lower = -Math.abs(ci.coupling.lambda) * ci.coupling.mu;
            }
            if (lower == Double.NEGATIVE_INFINITY && upper == Double.POSITIVE_INFINITY) {
                phi += w * w;
                continue;
            }
            if (lower == Double.NEGATIVE_INFINITY) {
                p = -FischerNewton.fisher(upper - ci.lambda, -w);
                phi += p * p;
                continue;
            }
            if (upper == Double.POSITIVE_INFINITY) {
                p = FischerNewton.fisher(ci.lambda - lower, w);
                phi += p * p;
                continue;
            }
            p = FischerNewton.fisher(ci.lambda - lower, FischerNewton.fisher(upper - ci.lambda, -w));
            phi += p * p;
        }
        return phi * 0.5;
    }

    public static double fischer(Solver.NCPConstraint ci) {
        double p;
        double phi = 0.0;
        double w = ci.j1.dot(ci.body1.deltavelocity) + ci.j2.dot(ci.body1.deltaomega) + ci.j3.dot(ci.body2.deltavelocity) + ci.j4.dot(ci.body2.deltaomega) + ci.b + ci.lambda * ci.damper;
        phi = ci.lower == Double.NEGATIVE_INFINITY && ci.upper == Double.POSITIVE_INFINITY ? w : (ci.lower == Double.NEGATIVE_INFINITY ? (p = -FischerNewton.fisher(ci.upper - ci.lambda, -w)) : (ci.upper == Double.POSITIVE_INFINITY ? (p = FischerNewton.fisher(ci.lambda - ci.lower, w)) : (p = FischerNewton.fisher(ci.lambda - ci.lower, FischerNewton.fisher(ci.upper - ci.lambda, -w)))));
        return phi;
    }

    public static void printA(List<Solver.NCPConstraint> constraints) {
        System.out.println("A = [ ");
        int k = 0;
        for (Solver.NCPConstraint ci : constraints) {
            System.out.println("");
            double[] ai = new double[10000];
            int j = 0;
            for (Solver.NCPConstraint cj : constraints) {
                ++k;
                ai[j] = 0.0;
                if (ci.body1 == cj.body1) {
                    ai[j] = ci.j1.dot(cj.b1) + ci.j2.dot(cj.b2);
                }
                if (ci.body2 == cj.body2) {
                    ai[j] = ai[j] + ci.j3.dot(cj.b3) + ci.j4.dot(cj.b4);
                }
                if (ci.body1 == cj.body2) {
                    ai[j] = ai[j] + ci.j1.dot(cj.b3) + ci.j2.dot(cj.b4);
                }
                if (ci.body2 == cj.body1) {
                    ai[j] = ai[j] + ci.j3.dot(cj.b1) + ci.j4.dot(cj.b2);
                }
                System.out.print(ai[j] + " ");
                ++j;
            }
            System.out.println("; ");
        }
        System.out.println("]\n b = [ ");
        for (Solver.NCPConstraint ci : constraints) {
            System.out.print(-ci.b + " ");
        }
        System.out.println("]");
    }

    public static void fillInA(List<Solver.NCPConstraint> constraints, double[][] A) {
        int k = 0;
        for (Solver.NCPConstraint ci : constraints) {
            int j = 0;
            for (Solver.NCPConstraint cj : constraints) {
                A[k][j] = 0.0;
                if (ci.body1 == cj.body1) {
                    A[k][j] = ci.j1.dot(cj.b1) + ci.j2.dot(cj.b2);
                }
                if (ci.body2 == cj.body2) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] + (ci.j3.dot(cj.b3) + ci.j4.dot(cj.b4));
                }
                if (ci.body1 == cj.body2) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] + (ci.j1.dot(cj.b3) + ci.j2.dot(cj.b4));
                }
                if (ci.body2 == cj.body1) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] + (ci.j3.dot(cj.b1) + ci.j4.dot(cj.b2));
                }
                ++j;
            }
            ++k;
        }
    }

    public static void fillInA(List<Solver.NCPConstraint> constraint1, List<Solver.NCPConstraint> constraint2, double[][] A) {
        int k = 0;
        for (Solver.NCPConstraint ci : constraint1) {
            int j = 0;
            for (Solver.NCPConstraint cj : constraint2) {
                A[k][j] = 0.0;
                if (ci.body1 == cj.body1) {
                    A[k][j] = ci.j1.dot(cj.b1) + ci.j2.dot(cj.b2);
                }
                if (ci.body2 == cj.body2) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] + (ci.j3.dot(cj.b3) + ci.j4.dot(cj.b4));
                }
                if (ci.body1 == cj.body2) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] + (ci.j1.dot(cj.b3) + ci.j2.dot(cj.b4));
                }
                if (ci.body2 == cj.body1) {
                    double[] dArray = A[k];
                    int n = j;
                    dArray[n] = dArray[n] + (ci.j3.dot(cj.b1) + ci.j4.dot(cj.b2));
                }
                ++j;
            }
            ++k;
        }
    }

    public static void fillInb(List<Solver.NCPConstraint> constraints, double[] b) {
        int i = 0;
        for (Solver.NCPConstraint ci : constraints) {
            b[i] = ci.b;
            ++i;
        }
    }

    public static void fillInLambda(List<Solver.NCPConstraint> constraints, double[] lambda) {
        int i = 0;
        for (Solver.NCPConstraint ci : constraints) {
            lambda[i] = ci.lambda;
            ++i;
        }
    }
}

