/*
 * Decompiled with CFR 0.152.
 */
package rafradek.blocklauncher;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import rafradek.blocklauncher.BlockLauncher;
import rafradek.blocklauncher.EntityFallingEnchantedBlock;

public class TNTCannon
extends Item {
    private IIcon rifleIcon;
    private IIcon cannonIcon;
    public IIcon shotgunIcon;
    private IIcon tntlauncherIcon;
    private IIcon tntcannonIcon;
    private IIcon tntlauncherEmptyIcon;
    private IIcon throwerIcon;

    public TNTCannon() {
        this.func_77655_b("blocklauncher");
        this.func_77637_a(BlockLauncher.tabblocklauncher);
        this.func_77625_d(1);
        this.func_77656_e(180);
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World par2World, EntityPlayer player) {
        if ((!stack.func_77942_o() || stack.func_77978_p().func_74762_e("wait") <= 0) && this.allowShot(player, stack, par2World)) {
            if (!this.usesBowAnimation(stack)) {
                this.use(stack, par2World, player, 1.8f, player.field_71071_by.func_70301_a(this.getSlotForUse(player, stack)), false);
            } else {
                player.func_71008_a(stack, this.func_77626_a(stack));
            }
        }
        return stack;
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int i, boolean p_77663_5_) {
        if (!p_77663_2_.field_72995_K && p_77663_1_.func_77942_o()) {
            EntityPlayer player = (EntityPlayer)p_77663_3_;
            if (p_77663_1_.field_77990_d.func_74762_e("wait") > 0) {
                p_77663_1_.field_77990_d.func_74768_a("wait", p_77663_1_.field_77990_d.func_74762_e("wait") - 1);
            }
            if (this.isRepeatable(p_77663_1_) && i == player.field_71071_by.field_70461_c && p_77663_1_.field_77990_d.func_74762_e("repeat") > 0 && p_77663_2_.func_72820_D() % 2L == 0L && this.allowShot(player, p_77663_1_, player.field_70170_p)) {
                this.use(p_77663_1_, player.field_70170_p, player, 1.8f, player.field_71071_by.func_70301_a(this.getSlotForUse(player, p_77663_1_)), true);
                p_77663_1_.field_77990_d.func_74768_a("repeat", p_77663_1_.field_77990_d.func_74762_e("repeat") - 1);
            }
        }
    }

    public boolean isRepeatable(ItemStack stack) {
        return this.getType(stack) == 3;
    }

    public int getSlotForUse(EntityPlayer player, ItemStack stack) {
        if (player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c + 1) != null && player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c + 1).func_77973_b() instanceof ItemBlock && this.allowBlock(stack, Block.func_149634_a((Item)player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c + 1).func_77973_b()), player.field_70170_p)) {
            return player.field_71071_by.field_70461_c + 1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemBlock) || !this.allowBlock(stack, Block.func_149634_a((Item)player.field_71071_by.func_70301_a(i).func_77973_b()), player.field_70170_p)) continue;
            return i;
        }
        return -1;
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        if (!this.isRepeatable(par1ItemStack)) {
            int j = this.func_77626_a(par1ItemStack) - par4;
            float f = (float)j / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.04) {
                return;
            }
            if (f > 1.5f) {
                f = 1.5f;
            }
            this.use(par1ItemStack, par2World, par3EntityPlayer, (f += 1.0f) * 1.8f, par3EntityPlayer.field_71071_by.func_70301_a(this.getSlotForUse(par3EntityPlayer, par1ItemStack)), false);
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public void use(ItemStack stack, World par2World, EntityPlayer player, float force, ItemStack stackToUse, boolean fEfficent) {
        force *= this.speedMult(stack);
        float rFloat = player.func_70681_au().nextFloat();
        boolean efficient = fEfficent || rFloat <= (float)EnchantmentHelper.func_77506_a((int)BlockLauncher.enchEff.field_77352_x, (ItemStack)stack) * 2.5f / 10.0f || this.isHarmless(stack) && rFloat < 0.8f;
        int stackSize = stackToUse.field_77994_a;
        for (int i = 0; i < (this.isSpreader(stack) ? Math.min(stackSize, this.getSpreaderBlockCount(stack)) : 1); ++i) {
            EntityFallingEnchantedBlock entity;
            int waitAmount;
            if (Block.func_149634_a((Item)stackToUse.func_77973_b()) == Blocks.field_150335_W && this.isActivator(stack)) {
                float radius = this.getExplosionSize(stack) * (this.biggerExplosion(stack) ? 1.4f : 1.0f);
                int fuse = Math.max(18, (int)(10.0 + (double)(force * 30.0f) * (this.biggerExplosion(stack) ? 1.4 : 1.0))) + i * 2;
                float dropChance = EnchantmentHelper.func_77506_a((int)BlockLauncher.enchLoot.field_77352_x, (ItemStack)stack) + 1;
                waitAmount = (int)(10.0f * this.fireRateMult(stack));
                entity = new EntityFallingEnchantedBlock(par2World, player.field_70165_t, player.field_70163_u, player.field_70161_v, (EntityLivingBase)player, this.isSticky(stack) ? 1 : (this.isBouncy(stack) ? 2 : 0), fuse, this.explodesOnImpact(stack), radius, dropChance, this.isHarmless(stack));
            } else if (!this.isActivator(stack)) {
                if (!stack.func_77942_o()) {
                    stack.field_77990_d = new NBTTagCompound();
                }
                int shrink = EnchantmentHelper.func_77506_a((int)BlockLauncher.enchShrink.field_77352_x, (ItemStack)stack) + 1;
                waitAmount = (int)Math.max(BlockLauncher.getHardness(Block.func_149634_a((Item)stackToUse.func_77973_b()), par2World) * this.fireRateMult(stack), (float)this.fireRateMin(stack));
                entity = new EntityFallingEnchantedBlock(par2World, player.field_70165_t, player.field_70163_u, player.field_70161_v, Block.func_149634_a((Item)stackToUse.func_77973_b()), stackToUse.func_77960_j(), this.isSticky(stack) ? 1 : (this.isBouncy(stack) ? 2 : 0), (EntityLivingBase)player, this.getScale(stack), efficient, shrink, this.damageMult(stack));
                if (this.getType(stack) == 3) {
                    entity.isFired = true;
                    entity.fireBlock = EnchantmentHelper.func_77506_a((int)BlockLauncher.enchFire.field_77352_x, (ItemStack)stack) == 0 ? Blocks.field_150480_ab : BlockLauncher.fireench;
                }
                entity.field_70156_m = false;
            } else {
                return;
            }
            stack.field_77990_d.func_74768_a("wait", waitAmount);
            if (this.isRepeatable(stack) && stack.field_77990_d.func_74762_e("repeat") == 0) {
                stack.field_77990_d.func_74768_a("repeat", 3);
            }
            par2World.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (par2World.field_72995_K) continue;
            entity.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
            entity.field_70165_t -= (double)(MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * 0.3f);
            entity.field_70163_u -= 0.5;
            entity.field_70161_v -= (double)(MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * 0.3f);
            entity.field_70165_t += (double)(-MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * this.getScale(stack) / 2.0f);
            entity.field_70161_v += (double)(MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * this.getScale(stack) / 2.0f);
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            entity.field_70129_M = 0.0f;
            entity.field_70159_w = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
            entity.field_70179_y = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
            entity.field_70181_x = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
            float f2 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y));
            Random random = new Random();
            entity.field_70159_w /= (double)f2;
            entity.field_70181_x /= (double)f2;
            entity.field_70179_y /= (double)f2;
            double spread = this.isSpreader(stack) ? (this.getType(stack) == 2 && !this.firesEntireStack(stack) ? 0.012 + 0.01 * (double)Math.min(i, this.getSpreaderBlockCount(stack)) : 0.012 + 0.01 * (double)this.getSpreaderBlockCount(stack)) : (this.isRepeatable(stack) ? 0.13 : 0.0075);
            entity.field_70159_w = entity.field_70159_w + random.nextGaussian() * (double)(random.nextBoolean() ? -1 : 1) * spread;
            entity.field_70181_x = entity.field_70181_x + random.nextGaussian() * (double)(random.nextBoolean() ? -1 : 1) * spread;
            entity.field_70179_y = entity.field_70179_y + random.nextGaussian() * (double)(random.nextBoolean() ? -1 : 1) * spread;
            entity.field_70159_w *= (double)force;
            entity.field_70181_x *= (double)force;
            entity.field_70179_y *= (double)force;
            float f3 = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            entity.field_70126_B = entity.field_70177_z = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            entity.field_70127_C = entity.field_70125_A = (float)(Math.atan2(entity.field_70181_x, f3) * 180.0 / Math.PI);
            par2World.func_72838_d((Entity)entity);
            if (player.field_71075_bZ.field_75098_d || efficient) continue;
            --stackToUse.field_77994_a;
            if (stackToUse.field_77994_a >= 1) continue;
            player.field_71071_by.func_70299_a(this.getSlotForUse(player, stack), null);
        }
        stack.func_77972_a(1, (EntityLivingBase)player);
    }

    public float getScale(ItemStack stack) {
        float base = 1.0f;
        if (this.getType(stack) == 0) {
            base = 0.6f;
        } else if (this.getType(stack) == 2 || this.getType(stack) == 3) {
            base = 0.4f;
        }
        return base * (1.0f + (float)EnchantmentHelper.func_77506_a((int)BlockLauncher.enchShrink.field_77352_x, (ItemStack)stack) * 0.33f);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        if (this.isSticky(stack)) {
            par2List.add("Sticky");
        }
        if (this.isBouncy(stack)) {
            par2List.add("Bouncing");
        }
        if (this.isHarmless(stack)) {
            par2List.add("Harmless");
        }
        if (this.firesEntireStack(stack)) {
            par2List.add("Super Spread");
        }
    }

    public boolean isHarmless(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Harmless");
    }

    public boolean firesEntireStack(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Stack");
    }

    public boolean isSticky(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Sticky");
    }

    public boolean isBouncy(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Bouncy");
    }

    public boolean isActivator(ItemStack stack) {
        return this.getType(stack) > 15;
    }

    public boolean usesBowAnimation(ItemStack stack) {
        return this.getType(stack) == 1 || this.getType(stack) == 17;
    }

    public boolean biggerExplosion(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Powder");
    }

    public boolean explodesOnImpact(ItemStack stack) {
        return this.getType(stack) == 17;
    }

    public boolean isSpreader(ItemStack stack) {
        return this.getType(stack) == 2;
    }

    public int getSpreaderBlockCount(ItemStack stack) {
        return this.getType(stack) == 2 && !this.firesEntireStack(stack) ? 8 : 64;
    }

    public float getExplosionSize(ItemStack stack) {
        float base = this.getType(stack) == 17 ? 3.0f : 4.0f;
        return base + (float)EnchantmentHelper.func_77506_a((int)BlockLauncher.enchPower.field_77352_x, (ItemStack)stack) * (this.explodesOnImpact(stack) ? 0.6f : 1.0f);
    }

    public int getType(ItemStack stack) {
        return stack.func_77978_p() != null ? stack.func_77978_p().func_74762_e("Type") : 0;
    }

    public float fireRateMult(ItemStack stack) {
        float base = 1.0f;
        if (this.getType(stack) == 0) {
            base = 2.4f;
        }
        if (this.getType(stack) == 2) {
            base = 10.0f;
        }
        if (this.getType(stack) == 17) {
            base = 3.7f;
        }
        return (base - (float)EnchantmentHelper.func_77506_a((int)BlockLauncher.enchHeavy.field_77352_x, (ItemStack)stack) * 0.2f) * (this.isHarmless(stack) ? 0.2f : 1.0f);
    }

    public float speedMult(ItemStack stack) {
        float base = this.getType(stack) == 17 ? 1.5f : (this.getType(stack) == 3 ? 0.6f : 1.0f);
        return base * (1.0f + (float)EnchantmentHelper.func_77506_a((int)BlockLauncher.enchPower.field_77352_x, (ItemStack)stack) * 0.33f);
    }

    public int fireRateMin(ItemStack stack) {
        int base = this.getType(stack) == 1 ? 25 : (this.getType(stack) == 2 ? 15 : 0);
        return base - EnchantmentHelper.func_77506_a((int)BlockLauncher.enchHeavy.field_77352_x, (ItemStack)stack) * 2;
    }

    public float damageMult(ItemStack stack) {
        return 1.0f;
    }

    public boolean allowShot(EntityPlayer player, ItemStack stack, World world) {
        return this.getSlotForUse(player, stack) != -1;
    }

    public boolean allowBlock(ItemStack stack, Block block, World world) {
        float speed = BlockLauncher.getHardness(block, world);
        float mult = 1.0f + (float)EnchantmentHelper.func_77506_a((int)BlockLauncher.enchHeavy.field_77352_x, (ItemStack)stack) * 0.6f;
        if (this.getType(stack) == 0) {
            return speed <= 2.5f * mult;
        }
        if (this.getType(stack) == 2) {
            return speed <= 2.0f * mult;
        }
        if (this.getType(stack) == 1) {
            return speed >= 2.5f / mult;
        }
        if (this.getType(stack) == 3) {
            return block.func_149688_o().func_76217_h() && block != Blocks.field_150335_W;
        }
        if (this.getType(stack) > 15) {
            return block == Blocks.field_150335_W;
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        if (this.getType(stack) == 0) {
            return 800;
        }
        if (this.getType(stack) == 1) {
            return 300;
        }
        if (this.getType(stack) == 2) {
            return 400;
        }
        if (this.getType(stack) == 3) {
            return 2000;
        }
        if (this.getType(stack) == 16) {
            return 450;
        }
        if (this.getType(stack) == 17) {
            return 300;
        }
        return this.func_77612_l();
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 18; ++i) {
            if (i == 4) {
                i = 16;
            }
            ItemStack stack = new ItemStack(par1);
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("Type", i);
            par3List.add(stack);
            ItemStack stack2 = stack.func_77946_l();
            stack2.field_77990_d.func_74757_a("Sticky", true);
            par3List.add(stack2);
            ItemStack stack3 = stack.func_77946_l();
            stack3.field_77990_d.func_74757_a("Bouncy", true);
            par3List.add(stack3);
            if (this.isActivator(stack)) {
                ItemStack stack4 = stack.func_77946_l();
                stack4.field_77990_d.func_74757_a("Harmless", true);
                par3List.add(stack4);
            }
            if (i != 2) continue;
            ItemStack stack5 = stack.func_77946_l();
            stack5.field_77990_d.func_74757_a("Stack", true);
            par3List.add(stack5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        this.rifleIcon = par1IconRegister.func_94245_a("blocklauncher:block_rifle");
        this.cannonIcon = par1IconRegister.func_94245_a("blocklauncher:block_cannon");
        this.shotgunIcon = par1IconRegister.func_94245_a("blocklauncher:block_shotgun");
        this.throwerIcon = par1IconRegister.func_94245_a("blocklauncher:block_thrower");
        this.tntcannonIcon = par1IconRegister.func_94245_a("blocklauncher:tnt_launcher");
        this.tntlauncherIcon = par1IconRegister.func_94245_a("blocklauncher:tnt_launcher_2");
        this.tntlauncherEmptyIcon = par1IconRegister.func_94245_a("blocklauncher:tnt_launcher_2_empty");
    }

    public String func_77667_c(ItemStack p_77667_1_) {
        int type = this.getType(p_77667_1_);
        if (type == 0) {
            return "item.blockrifle";
        }
        if (type == 1) {
            return "item.blockcannon";
        }
        if (type == 2) {
            return "item.shotblock";
        }
        if (type == 3) {
            return "item.blockthrower";
        }
        if (type == 16) {
            return "item.TNTcannon";
        }
        if (type == 17) {
            return "item.TNTlauncher";
        }
        return super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        int type = this.getType(stack);
        if (type == 0) {
            return this.rifleIcon;
        }
        if (type == 1) {
            return this.cannonIcon;
        }
        if (type == 2) {
            return this.shotgunIcon;
        }
        if (type == 3) {
            return this.throwerIcon;
        }
        if (type == 16) {
            return this.tntcannonIcon;
        }
        if (type == 17) {
            return this.tntlauncherIcon;
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }
}

