/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.logic;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.Server;
import noppes.animalbikes.constants.EnumPackets;
import noppes.animalbikes.entity.types.EntityRidable;

public class DinoLogic {
    public NBTTagCompound compound;
    private long lastGrabbed = 0L;
    private EntityAnimal entity;
    private EntityRidable bike;

    public DinoLogic(EntityRidable bike) {
        this.bike = bike;
    }

    public void applyEntityCollision(Entity entity) {
        if (entity == this.bike.rider) {
            return;
        }
        if (!this.bike.field_70170_p.field_72995_K && this.bike.rider != null && this.compound == null && entity instanceof EntityAnimal && this.lastGrabbed + 2000L < System.currentTimeMillis()) {
            EntityAnimal grabbed = (EntityAnimal)entity;
            this.compound = new NBTTagCompound();
            grabbed.func_70039_c(this.compound);
            entity = grabbed;
            Server.sendAssociatedData((EntityPlayerMP)this.bike.rider, EnumPackets.DinoGrabbed, this.bike.rider.func_70005_c_(), this.compound);
            Server.sendData((EntityPlayerMP)this.bike.rider, EnumPackets.DinoGrabbed, this.bike.rider.func_70005_c_(), this.compound);
            grabbed.field_70128_L = true;
        }
    }

    public void spawnGrabbed() {
        if (!this.bike.field_70170_p.field_72995_K && this.compound != null) {
            Entity animal = EntityList.func_75615_a((NBTTagCompound)this.compound, (World)this.bike.field_70170_p);
            if (animal == null) {
                return;
            }
            double dx = -MathHelper.func_76126_a((float)((float)((double)(this.bike.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70125_A / 180.0f) * Math.PI)));
            double dz = MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70125_A / 180.0f) * Math.PI)));
            animal.func_70107_b(this.bike.field_70165_t + dx, this.bike.field_70163_u, this.bike.field_70161_v + dz);
            this.bike.field_70170_p.func_72838_d(animal);
        }
        this.compound = null;
        this.entity = null;
        this.lastGrabbed = System.currentTimeMillis();
    }

    public EntityAnimal getGrabbedEntity() {
        if (this.compound == null) {
            return this.entity;
        }
        if (this.entity != null) {
            return this.entity;
        }
        this.entity = (EntityAnimal)EntityList.func_75615_a((NBTTagCompound)this.compound, (World)this.bike.field_70170_p);
        return this.entity;
    }
}

