/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.NPCGuiHelper;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.IChatComponent;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.constants.EnumOptionType;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.entity.EntityNPCInterface;
import org.lwjgl.opengl.GL11;

public class GuiDialogInteract
extends GuiNPCInterface {
    private Dialog dialog;
    private int selected = 0;
    private List<TextBlockClient> lines = new ArrayList<TextBlockClient>();
    private List<Integer> options = new ArrayList<Integer>();
    private int rowStart = 0;
    private int rowTotal = 0;
    private int dialogHeight = 210;

    public GuiDialogInteract(EntityNPCInterface npc, Dialog dialog) {
        super(npc);
        this.dialog = dialog;
        this.appendDialog(dialog);
        this.ySize = 238;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop = this.field_146295_m - this.ySize;
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float l = (float)(this.guiLeft - 60) * 0.88f;
        float i1 = (float)(this.guiTop + 50 + this.dialogHeight) * 0.88f;
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)l, (float)i1, (float)50.0f);
        float zoomed = this.npc.field_70131_O;
        if (this.npc.field_70130_N * 2.0f > zoomed) {
            zoomed = this.npc.field_70130_N * 2.0f;
        }
        System.out.println(zoomed);
        zoomed = 2.0f / zoomed * 40.0f;
        GL11.glScalef((float)(-zoomed), (float)zoomed, (float)zoomed);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = this.npc.field_70761_aq;
        float f3 = this.npc.field_70177_z;
        float f4 = this.npc.field_70125_A;
        float f7 = this.npc.field_70759_as;
        float f5 = l - (float)i;
        float f6 = i1 - 50.0f - (float)j;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(f6 / 80.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.npc.field_70761_aq = 0.0f;
        this.npc.field_70177_z = (float)Math.atan(f5 / 80.0f) * 40.0f;
        this.npc.field_70125_A = -((float)Math.atan(f6 / 80.0f)) * 20.0f;
        this.npc.field_70758_at = this.npc.field_70759_as = this.npc.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)this.npc.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        try {
            RenderManager.field_78727_a.func_147940_a((Entity)this.npc, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.npc.field_70761_aq = f2;
        this.npc.field_70177_z = f3;
        this.npc.field_70125_A = f4;
        this.npc.field_70758_at = this.npc.field_70759_as = f7;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        super.func_73863_a(i, j, f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)100.065f);
        float scale = 0.88f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        int count = 0;
        for (TextBlockClient block : this.lines) {
            int size = this.field_146289_q.func_78256_a(block.name + ": ");
            this.drawString(block.name + ": ", -4 - size, block.color, count, scale);
            for (IChatComponent line : block.lines) {
                this.drawString(line.func_150254_d(), 0, block.color, count, scale);
                ++count;
            }
            ++count;
        }
        if (!this.options.isEmpty()) {
            int selected;
            this.func_73730_a(this.guiLeft - 60, this.guiLeft + this.xSize + 120, this.guiTop + this.dialogHeight, -1);
            int offset = 214;
            if (j >= (int)((float)(this.guiTop + offset) * scale) && (selected = (int)(((float)j - (float)(this.guiTop + offset) * scale) / ((float)this.field_146289_q.field_78288_b * scale))) < this.options.size()) {
                this.selected = selected;
            }
            if (this.selected >= this.options.size()) {
                this.selected = 0;
            }
            if (this.selected < 0) {
                this.selected = 0;
            }
            count = 0;
            for (int k = 0; k < this.options.size(); ++k) {
                int id = this.options.get(k);
                DialogOption option = this.dialog.options.get(id);
                int y = this.guiTop + offset + count * this.field_146289_q.field_78288_b;
                if (this.selected == k) {
                    this.func_73731_b(this.field_146289_q, ">", this.guiLeft - 60, y, 0xE0E0E0);
                }
                this.func_73731_b(this.field_146289_q, NoppesStringUtils.formatText(option.title, this.player.getDisplayName()), this.guiLeft - 30, y, option.optionColor);
                ++count;
            }
        }
        GL11.glPopMatrix();
    }

    private void drawString(String text, int left, int color, int count, float scale) {
        int height = count - this.rowStart;
        super.func_73731_b(this.field_146289_q, text, this.guiLeft + left, this.guiTop + height * this.field_146289_q.field_78288_b, color);
    }

    private int getSelected() {
        if (this.selected <= 0) {
            return 0;
        }
        if (this.selected < this.options.size()) {
            return this.selected;
        }
        return this.options.size() - 1;
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || i == 200) {
            --this.selected;
        }
        if (i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i() || i == 208) {
            ++this.selected;
        }
        if (i == 28) {
            this.handleDialogSelection();
        }
        if (i == 1 || this.isInventoryKey(i)) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.Dialog, this.dialog.id, -1);
            this.closed();
            this.close();
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        if (this.selected == -1 && this.options.isEmpty() || this.selected >= 0) {
            this.handleDialogSelection();
        }
    }

    private void handleDialogSelection() {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.Dialog, this.dialog.id, this.options.isEmpty() ? -1 : this.options.get(this.selected));
        if (this.dialog == null || !this.dialog.hasOtherOptions() || this.options.isEmpty()) {
            this.close();
            this.closed();
            return;
        }
        DialogOption option = this.dialog.options.get(this.options.get(this.selected));
        if (option == null || option.optionType == EnumOptionType.QuitOption || option.optionType == EnumOptionType.Disabled) {
            this.close();
            this.closed();
            return;
        }
        this.lines.add(new TextBlockClient(this.player.getDisplayName(), option.title, 280, option.optionColor));
        this.calculateRowHeight();
        NPCGuiHelper.clickSound();
    }

    private void closed() {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CheckQuestCompletion, new Object[0]);
    }

    @Override
    public void save() {
    }

    public void appendDialog(Dialog dialog) {
        this.dialog = dialog;
        this.options = new ArrayList<Integer>();
        if (dialog.sound != null && !dialog.sound.isEmpty()) {
            MusicController.Instance.playSound(dialog.sound, (float)this.npc.field_70165_t, (float)this.npc.field_70163_u, (float)this.npc.field_70161_v);
        }
        this.lines.add(new TextBlockClient(this.npc.func_70005_c_(), dialog.text, 280));
        for (int slot : dialog.options.keySet()) {
            DialogOption option = dialog.options.get(slot);
            if (option == null || option.optionType == EnumOptionType.Disabled) continue;
            this.options.add(slot);
        }
        this.calculateRowHeight();
    }

    private void calculateRowHeight() {
        this.rowTotal = 0;
        for (TextBlockClient block : this.lines) {
            this.rowTotal += block.lines.size() + 1;
        }
        int max = this.dialogHeight / Minecraft.func_71410_x().field_71466_p.field_78288_b;
        this.rowStart = this.rowTotal - max;
        if (this.rowStart < 0) {
            this.rowStart = 0;
        }
    }
}

