/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobFollower
extends JobInterface {
    public EntityNPCInterface following = null;
    private int ticks = 40;
    private int range = 20;
    public String name = "";

    public JobFollower(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("FollowingEntityName", this.name);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("FollowingEntityName");
    }

    @Override
    public boolean aiShouldExecute() {
        if (this.npc.isAttacking()) {
            return false;
        }
        if (this.ticks > 0) {
            --this.ticks;
            return false;
        }
        this.ticks = 20;
        List list = this.npc.field_70170_p.func_72872_a(EntityNPCInterface.class, this.npc.field_70121_D.func_72314_b((double)this.getRange(), (double)this.getRange(), (double)this.getRange()));
        for (EntityNPCInterface entity : list) {
            if (entity == this.npc || entity.isKilled() || !entity.display.name.equalsIgnoreCase(this.name)) continue;
            this.following = entity;
            break;
        }
        return this.following != null;
    }

    @Override
    public void aiStartExecuting() {
        this.ticks = 0;
    }

    @Override
    public void aiUpdateTask() {
        if (this.ticks-- > 0) {
            return;
        }
        this.ticks = 10;
        double distance = this.npc.func_70068_e((Entity)this.following);
        if (distance < 16.0) {
            return;
        }
        double speed = 0.8 + distance / (double)(this.getRange() * this.getRange());
        this.npc.func_70661_as().func_75497_a((Entity)this.following, speed);
    }

    private int getRange() {
        if (this.range > CustomNpcs.NpcNavRange) {
            return CustomNpcs.NpcNavRange;
        }
        return this.range;
    }

    public boolean isFollowing() {
        return this.following != null;
    }

    @Override
    public boolean aiContinueExecute() {
        double distance = this.npc.func_70068_e((Entity)this.following);
        return !this.following.isKilled() && !this.following.isAttacking() && distance < (double)(this.getRange() * this.getRange());
    }

    @Override
    public void reset() {
        this.resetTask();
    }

    @Override
    public void resetTask() {
        this.following = null;
        this.ticks = 20;
    }
}

