/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.combo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SandwichCombo {
    protected ArrayList<String> comboLayers = new ArrayList();
    protected String name = "default";
    protected EnumRarity rarity = EnumRarity.common;
    protected int extraHeal = 0;
    public static SandwichCombo[] combos = new SandwichCombo[16];
    public static SandwichCombo big_mac;
    public static SandwichCombo blt;
    public static SandwichCombo only_bread;
    public static SandwichCombo retro_roast_beef;
    public static SandwichCombo smart_chicken;
    public static SandwichCombo veggie;

    public SandwichCombo(int id, String localizableName, EnumRarity enumRarity) {
        if (combos[id] == null) {
            SandwichCombo.combos[id] = this;
        }
        this.setName(localizableName);
        this.setRarity(enumRarity);
    }

    public static void load() {
        big_mac = new SandwichCombo(1, "big_mac", EnumRarity.rare).setComboLayers(new String[]{"bread_slice", "cheese_slice", "roast_beef", "lettuce_leaf", "bread_slice", "roast_beef", "lettuce_leaf", "bread_slice"}).setExtraHeal(1);
        blt = new SandwichCombo(2, "blt", EnumRarity.uncommon).setComboLayers(new String[]{"toast", "bacon_cooked", "lettuce_leaf", "tomato_slice", "toast"}).setExtraHeal(1);
        only_bread = new SandwichCombo(3, "only_bread", EnumRarity.common).setComboLayers(new String[]{"bread_slice", "bread_slice"});
        retro_roast_beef = new SandwichCombo(4, "rrb", EnumRarity.uncommon).setComboLayers(new String[]{"bread_slice", "roast_beef", "roast_beef", "tomato_slice", "lettuce_leaf", "bread_slice"}).setExtraHeal(3);
        smart_chicken = new SandwichCombo(5, "smart_chicken", EnumRarity.uncommon).setComboLayers(new String[]{"toast", "chicken_fillet_cooked", "tomato_slice", "lettuce_leaf", "toast"});
        veggie = new SandwichCombo(6, "veggie", EnumRarity.rare).setComboLayers(new String[]{"bread_slice", "carrot_slice", "lettuce_leaf", "tomato_slice", "cheese_slice", "bread_slice"});
    }

    public SandwichCombo setName(String name) {
        this.name = name;
        return this;
    }

    public String getUnlocalizedName() {
        return "combo." + this.name;
    }

    public String getLocalizedName() {
        if (StatCollector.func_94522_b((String)(this.getUnlocalizedName() + ".name"))) {
            return StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".name"));
        }
        return this.getUnlocalizedName() + ".name";
    }

    public SandwichCombo setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public SandwichCombo setComboLayers(String[] array) {
        this.comboLayers = new ArrayList<String>(Arrays.asList(array));
        return this;
    }

    public ArrayList<String> getComboLayers() {
        return this.comboLayers;
    }

    public void onFoodEaten(ItemStack itemStack, World world, EntityPlayer player) {
    }

    public SandwichCombo setExtraHeal(int extraHeal) {
        this.extraHeal = extraHeal;
        return this;
    }

    public int getExtraHeal() {
        return this.extraHeal;
    }

    public void addCustomInfo(List list) {
        list.add("");
        if (StatCollector.func_94522_b((String)(this.getUnlocalizedName() + ".name"))) {
            list.add(StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".name")));
        } else {
            list.add(this.getUnlocalizedName() + ".name");
        }
    }

    public boolean matches(ItemStack sandwich) {
        ArrayList<String> layersInSandwich = new ArrayList<String>();
        NBTTagList layersList = sandwich.field_77990_d.func_150295_c("SandwichLayers", 10);
        for (int i = 0; i < layersList.func_74745_c(); ++i) {
            NBTTagCompound layerCompound = layersList.func_150305_b(i);
            String name = ItemStack.func_77949_a((NBTTagCompound)layerCompound).func_77973_b().func_77658_a().replace("item.", "");
            layersInSandwich.add(name);
        }
        return layersInSandwich.containsAll(this.comboLayers) && this.comboLayers.containsAll(layersInSandwich);
    }
}

