/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import dk.mrspring.kitchen.item.ItemSandwich;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityPlate
extends TileEntity {
    protected ArrayList<ItemStack> items = new ArrayList();
    protected boolean isFull = false;
    protected Random random = new Random();

    public boolean addItem(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() != null) {
                if (itemStack.func_77973_b() instanceof ItemSandwich) {
                    if (!this.isFull && this.items.size() == 0) {
                        ItemStack item = itemStack.func_77946_l();
                        item.field_77994_a = 1;
                        this.items.add(item);
                        this.isFull = true;
                        itemStack = null;
                        return true;
                    }
                    return false;
                }
                if (!this.isFull) {
                    ItemStack item = itemStack.func_77946_l();
                    item.field_77994_a = 1;
                    this.items.add(item);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public ItemStack removeTopItem() {
        int index = this.items.size();
        if (index != 0) {
            ItemStack item = this.items.get(index - 1);
            if (item != null) {
                if (item.func_77973_b() != null) {
                    this.items.remove(index - 1);
                    if (this.isFull) {
                        this.isFull = false;
                    }
                    return item;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public ItemStack[] getItemsAsArray() {
        return this.items.toArray(new ItemStack[1]);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeItemsToNBT(compound);
        compound.func_74757_a("IsFull", this.isFull);
    }

    public void writeItemsToNBT(NBTTagCompound compound) {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack item : this.items) {
            if (item == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound = item.func_77955_b(itemCompound);
            itemList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readItemsFromNBT(compound);
        this.isFull = compound.func_74767_n("IsFull");
    }

    public void readItemsFromNBT(NBTTagCompound compound) {
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        this.items = new ArrayList();
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            if (itemList.func_150305_b(i) == null) continue;
            NBTTagCompound item = itemList.func_150305_b(i);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)item);
            this.items.add(itemStack);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, compound);
    }
}

