/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.aquaculture;

import java.io.File;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import rebelkeithy.mods.aquaculture.enchantments.EnchantmentSlotReserve;

public enum Config {
    INSTANCE;

    public static final String categoryEnchantments = "ENCHANTMENTS";
    public static int appealingID;
    public static int magneticID;
    public static int longcastID;
    public static int shortcastID;
    public static int fastcastID;
    public static int barbedHookID;
    public static int doubleHookID;
    public static int effeciencyID;
    public static int heavyLineID;

    public void init(File file) {
        Configuration config = new Configuration(file);
        config.load();
        appealingID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Appealing", appealingID)).getInt();
        magneticID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Magnetic", magneticID)).getInt();
        longcastID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Long Cast", longcastID)).getInt();
        shortcastID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Short Cast", shortcastID)).getInt();
        barbedHookID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Barbed Hook", barbedHookID)).getInt();
        doubleHookID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Double Hook", doubleHookID)).getInt();
        effeciencyID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Efficency", effeciencyID)).getInt();
        heavyLineID = this.isIdAvailableOrSet(config.get(categoryEnchantments, "Heavy Line", heavyLineID)).getInt();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private Property isIdAvailableOrSet(Property property) {
        int propertyInt = property.getInt();
        if (Enchantment.field_77331_b[propertyInt] == null) {
            return property;
        }
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] != null) continue;
            new EnchantmentSlotReserve(i);
            property.set(i);
            return property;
        }
        throw new RuntimeException("No more enchantment ids are available");
    }

    static {
        appealingID = 60;
        magneticID = 61;
        longcastID = 62;
        shortcastID = 63;
        fastcastID = 64;
        barbedHookID = 65;
        doubleHookID = 66;
        effeciencyID = 67;
        heavyLineID = 68;
    }
}

