/*
 * Decompiled with CFR 0.152.
 */
package igwmod;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import igwmod.IGWMod;
import igwmod.api.IRecipeIntegrator;
import igwmod.api.WikiRegistry;
import igwmod.gui.IReservedSpace;
import igwmod.gui.IWidget;
import igwmod.gui.LocatedStack;
import igwmod.gui.LocatedString;
import igwmod.lib.IGWLog;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class InfoSupplier {
    private static HashMap<String, ResourceLocation> infoMap = new HashMap();
    private static final int MAX_TEXT_X = 475;
    private static int currentTextColor;
    private static String curPrefix;
    private static String curLink;

    public static List<String> getInfo(String objectName) {
        return InfoSupplier.getInfo(objectName, FMLClientHandler.instance().getCurrentLanguage());
    }

    public static List<String> getInfo(String objectName, String language) {
        String oldObjectName = objectName;
        objectName = "igwmod:wiki/" + language + "/" + objectName + ".txt";
        if (!infoMap.containsKey(objectName)) {
            infoMap.put(objectName, new ResourceLocation(objectName));
        }
        try {
            InputStream stream;
            if (oldObjectName.startsWith("server/")) {
                String s = IGWMod.proxy.getSaveLocation() + "\\igwmod\\" + oldObjectName.substring(7) + ".txt";
                stream = new FileInputStream(new File(s));
            } else {
                IResourceManager manager = FMLClientHandler.instance().getClient().func_110442_L();
                ResourceLocation location = infoMap.get(objectName);
                IResource resource = manager.func_110536_a(location);
                stream = resource.func_110527_b();
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            ArrayList<String> textList = new ArrayList<String>();
            String line = br.readLine();
            while (line != null) {
                textList.add(line);
                line = br.readLine();
            }
            br.close();
            return textList;
        }
        catch (Exception e) {
            if (!language.equals("en_US")) {
                return InfoSupplier.getInfo(oldObjectName, "en_US");
            }
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void analyseInfo(FontRenderer fontRenderer, List<String> fileInfo, List<IReservedSpace> reservedSpaces, List<LocatedString> locatedStrings, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures) {
        currentTextColor = -16777216;
        curPrefix = "";
        curLink = "";
        locatedStacks.clear();
        locatedStrings.clear();
        locatedTextures.clear();
        for (int k = 0; k < fileInfo.size(); ++k) {
            String line = fileInfo.get(k);
            block5: for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) != '[') continue;
                for (int j = i; j < line.length(); ++j) {
                    if (line.charAt(j) != ']') continue;
                    try {
                        if (!InfoSupplier.decomposeTemplate(line.substring(i + 1, j), reservedSpaces, locatedStrings, locatedStacks, locatedTextures)) continue block5;
                        String cutString = line.substring(0, i) + line.substring(j + 1, line.length());
                        if (cutString.equals("")) {
                            fileInfo.remove(k--);
                            continue block5;
                        }
                        fileInfo.set(k, cutString);
                    }
                    catch (IllegalArgumentException e) {
                        fileInfo.add(EnumChatFormatting.RED + "Problem when parsing \"" + line.substring(i + 1, j) + "\":");
                        fileInfo.add(EnumChatFormatting.RED + e.getMessage());
                        IGWLog.warning(e.getMessage());
                    }
                    continue block5;
                }
            }
        }
        int currentY = 20;
        block7: for (int k = 0; k < fileInfo.size(); ++k) {
            String line = " " + fileInfo.get(k);
            ArrayList<String> sentenceWordList = new ArrayList<String>(Arrays.asList(line.split(" ")));
            for (int i = 0; i < sentenceWordList.size(); ++i) {
                String word = (String)sentenceWordList.get(i);
                int index = word.indexOf("[");
                int otherIndex = word.indexOf("]");
                if (otherIndex > 0) {
                    ++otherIndex;
                }
                if (index == -1) {
                    index = otherIndex;
                } else if (otherIndex != -1) {
                    index = Math.min(index, otherIndex);
                }
                if (index <= 0 || index >= word.length() - 1) continue;
                sentenceWordList.set(i, word.substring(0, index));
                sentenceWordList.add(i + 1, word.substring(index));
            }
            String[] sentenceWords = sentenceWordList.toArray(new String[sentenceWordList.size()]);
            int currentWord = 0;
            int currentX = 0;
            String textPart = "";
            int newX = 0;
            while (currentWord < sentenceWords.length || sentenceWords.length == 0) {
                int curTextColor = currentTextColor;
                String prefix = curPrefix;
                String link = curLink;
                boolean newLine = false;
                while (true) {
                    String potentialString;
                    String string = currentWord >= sentenceWords.length ? "" : (potentialString = textPart + (textPart.equals("") ? "" : " ") + sentenceWords[currentWord]);
                    if (currentWord >= sentenceWords.length || fontRenderer.func_78256_a(prefix + potentialString) + currentX > 475 && fontRenderer.func_78256_a(prefix + sentenceWords[currentWord]) <= 275) {
                        newLine = true;
                        newX = 0;
                        break;
                    }
                    newX = InfoSupplier.getNewXFromIntersection(new Rectangle(currentX, currentY, fontRenderer.func_78256_a(prefix + potentialString), fontRenderer.field_78288_b), reservedSpaces, locatedStacks, locatedTextures);
                    if (textPart.equals("") && fontRenderer.func_78256_a(prefix + potentialString) + newX <= 475) {
                        currentX = newX;
                    } else if (newX != currentX) break;
                    textPart = potentialString;
                    boolean foundCode = false;
                    if (++currentWord >= sentenceWords.length) continue;
                    String potentialCode = sentenceWords[currentWord];
                    int i = potentialCode.indexOf(91);
                    int j = potentialCode.indexOf(93);
                    while (i != -1 && j != -1) {
                        try {
                            sentenceWords[currentWord] = potentialCode.substring(0, i) + potentialCode.substring(j + 1, potentialCode.length());
                            InfoSupplier.decomposeInLineTemplate(potentialCode.substring(i + 1, j));
                            newX += fontRenderer.func_78256_a(textPart + " ");
                            foundCode = true;
                        }
                        catch (IllegalArgumentException e) {
                            fileInfo.add(EnumChatFormatting.RED + e.getMessage());
                            IGWLog.warning(e.getMessage());
                        }
                        potentialCode = sentenceWords[currentWord];
                        i = potentialCode.indexOf(91);
                        j = potentialCode.indexOf(93);
                    }
                    if (foundCode) break;
                }
                locatedStrings.add(link.equals("") ? new LocatedString(prefix + textPart, currentX, currentY, curTextColor, false) : new LocatedString(prefix + textPart, currentX, currentY, false, link));
                if (newLine) {
                    currentY += fontRenderer.field_78288_b + 1;
                }
                currentX = newX;
                textPart = "";
                if (sentenceWords.length != 0) continue;
                continue block7;
            }
        }
    }

    private static int getNewXFromIntersection(Rectangle rect, List<IReservedSpace> reservedSpaces, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures) {
        Rectangle space;
        int oldX = rect.x;
        boolean modified = false;
        for (IReservedSpace reservedSpace : reservedSpaces) {
            space = reservedSpace.getReservedSpace();
            if (space.x + space.width <= rect.x || !space.intersects(rect)) continue;
            rect = new Rectangle(space.x + space.width, rect.y, rect.width, rect.height);
            modified = true;
        }
        for (LocatedStack locatedStack : locatedStacks) {
            space = locatedStack.getReservedSpace();
            if (space.x + space.width <= rect.x || !space.intersects(rect)) continue;
            rect = new Rectangle(space.x + space.width, rect.y, rect.width, rect.height);
            modified = true;
        }
        for (IWidget locatedTexture : locatedTextures) {
            if (!(locatedTexture instanceof IReservedSpace)) continue;
            space = ((IReservedSpace)((Object)locatedTexture)).getReservedSpace();
            if (space.x + space.width <= rect.x || !space.intersects(rect)) continue;
            rect = new Rectangle(space.x + space.width, rect.y, rect.width, rect.height);
            modified = true;
        }
        return modified ? rect.x : oldX;
    }

    private static boolean decomposeTemplate(String code, List<IReservedSpace> reservedSpaces, List<LocatedString> locatedStrings, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures) throws IllegalArgumentException {
        for (IRecipeIntegrator integrator : WikiRegistry.recipeIntegrators) {
            if (!code.startsWith(integrator.getCommandKey() + "{")) continue;
            String[] args = code.substring(integrator.getCommandKey().length() + 1, code.length() - 1).split(",");
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].trim();
            }
            integrator.onCommandInvoke(args, reservedSpaces, locatedStrings, locatedStacks, locatedTextures);
            return true;
        }
        return false;
    }

    private static void decomposeInLineTemplate(String code) throws IllegalArgumentException {
        if (!code.endsWith("}")) {
            throw new IllegalArgumentException("Code misses a '}' at the end! Full code: " + code);
        }
        if (code.startsWith("color{")) {
            InfoSupplier.colorCommand(code);
        } else if (code.startsWith("prefix{")) {
            InfoSupplier.prefixCommand(code);
        } else if (code.startsWith("link{")) {
            curLink = code.substring(5, code.length() - 1);
        }
    }

    private static void colorCommand(String code) throws IllegalArgumentException {
        String colorCode = code.substring(6, code.length() - 1);
        if (colorCode.startsWith("0x")) {
            colorCode = colorCode.substring(2);
        }
        try {
            currentTextColor = 0xFF000000 | Integer.parseInt(colorCode, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Using an invalid color parameter. Only use hexadecimal (0123456789ABCDEF) numbers! Also only use 6 digits (no alpha digits). Full code: " + code + ", color code: " + colorCode);
        }
    }

    private static void prefixCommand(String code) throws IllegalArgumentException {
        String prefixCode = code.substring(7, code.length() - 1);
        curPrefix = "";
        for (int i = 0; i < prefixCode.length(); ++i) {
            if (prefixCode.charAt(i) == 'r') continue;
            curPrefix = curPrefix + "\u00a7" + prefixCode.charAt(i);
        }
    }

    static {
        curPrefix = "";
        curLink = "";
    }
}

