/*
 * Decompiled with CFR 0.152.
 */
package igwmod.gui.tabs;

import igwmod.gui.GuiWiki;
import igwmod.gui.IPageLink;
import igwmod.gui.IReservedSpace;
import igwmod.gui.LocatedString;
import igwmod.gui.tabs.IWikiTab;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseWikiTab
implements IWikiTab {
    protected List<String> pageEntries = new ArrayList<String>();
    private final List<Integer> lineSkips = new ArrayList<Integer>();

    @Override
    public List<IReservedSpace> getReservedSpaces() {
        return null;
    }

    @Override
    public List<IPageLink> getPages(int[] pageIndexes) {
        ArrayList<IPageLink> pages = new ArrayList<IPageLink>();
        if (pageIndexes == null) {
            for (int i = 0; i < this.pageEntries.size(); ++i) {
                pages.add(new LocatedString(this.getPageName(this.pageEntries.get(i)), 80, 64 + 11 * i, false, this.getPageLocation(this.pageEntries.get(i))));
            }
        } else {
            int skipOffset = 0;
            for (int i = 0; i < pageIndexes.length; ++i) {
                if (pageIndexes.length == this.pageEntries.size() && this.lineSkips.contains(i)) {
                    skipOffset += 11;
                }
                pages.add(new LocatedString(this.getPageName(this.pageEntries.get(pageIndexes[i])), 80, 64 + 11 * i + skipOffset, false, this.getPageLocation(this.pageEntries.get(pageIndexes[i]))).capTextWidth(this.pagesPerTab() > pageIndexes.length ? 100 : 77));
            }
        }
        return pages;
    }

    protected void skipLine() {
        this.lineSkips.add(this.pageEntries.size());
    }

    @Override
    public int pagesPerTab() {
        return 36;
    }

    @Override
    public int pagesPerScroll() {
        return 1;
    }

    @Override
    public int getSearchBarAndScrollStartY() {
        return 18;
    }

    @Override
    public void renderForeground(GuiWiki gui, int mouseX, int mouseY) {
    }

    @Override
    public void renderBackground(GuiWiki gui, int mouseX, int mouseY) {
    }

    @Override
    public void onMouseClick(GuiWiki gui, int mouseX, int mouseY, int mouseKey) {
    }

    @Override
    public void onPageChange(GuiWiki gui, String pageName, Object ... metadata) {
    }

    protected abstract String getPageName(String var1);

    protected abstract String getPageLocation(String var1);
}

