/*
 * Decompiled with CFR 0.152.
 */
package igwmod.recipeintegration;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import igwmod.TextureSupplier;
import igwmod.WikiUtils;
import igwmod.api.CraftingRetrievalEvent;
import igwmod.api.IRecipeIntegrator;
import igwmod.gui.IReservedSpace;
import igwmod.gui.IWidget;
import igwmod.gui.LocatedStack;
import igwmod.gui.LocatedString;
import igwmod.gui.LocatedTexture;
import igwmod.lib.IGWLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class IntegratorCraftingRecipe
implements IRecipeIntegrator {
    public static Map<String, IRecipe> autoMappedRecipes = new HashMap<String, IRecipe>();
    public static final int STACKS_X_OFFSET = 1;
    public static final int STACKS_Y_OFFSET = 1;
    private static final int RESULT_STACK_X_OFFSET = 95;
    private static final int RESULT_STACK_Y_OFFSET = 19;

    @Override
    public String getCommandKey() {
        return "crafting";
    }

    @Override
    public void onCommandInvoke(String[] arguments, List<IReservedSpace> reservedSpaces, List<LocatedString> locatedStrings, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures) throws IllegalArgumentException {
        int y;
        int x;
        if (arguments.length < 3) {
            throw new IllegalArgumentException("Code needs at least 3 arguments!");
        }
        try {
            x = Integer.parseInt(arguments[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The first parameter (the x coordinate) contains an invalid number. Check for spaces or invalid characters!");
        }
        try {
            y = Integer.parseInt(arguments[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The second parameter (the y coordinate) contains an invalid number. Check for spaces or invalid characters!");
        }
        locatedTextures.add(new LocatedTexture(TextureSupplier.getTexture("igwmod:textures/GuiCrafting.png"), x, y, 232, 108));
        if (arguments[2].startsWith("key=")) {
            if (arguments.length != 3) {
                throw new IllegalArgumentException("An RecipeRetrievalEvent crafting code can only have 3 parameters: x, y and the key!");
            }
            this.addAutomaticCraftingRecipe(arguments[2], locatedStacks, locatedTextures, (int)((double)x * 0.5), (int)((double)y * 0.5));
        } else {
            this.addManualCraftingRecipe(arguments, locatedStacks, locatedTextures, (int)((double)x * 0.5), (int)((double)y * 0.5));
        }
    }

    private void addAutomaticCraftingRecipe(String code, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures, int x, int y) throws IllegalArgumentException {
        String key = code.substring(4);
        CraftingRetrievalEvent recipeEvent = new CraftingRetrievalEvent(key);
        IRecipe autoMappedRecipe = autoMappedRecipes.get(key);
        if (autoMappedRecipe != null) {
            recipeEvent.recipe = autoMappedRecipe;
        } else {
            MinecraftForge.EVENT_BUS.post((Event)recipeEvent);
        }
        if (recipeEvent.recipe instanceof ShapedRecipes) {
            ShapedRecipes recipe = (ShapedRecipes)recipeEvent.recipe;
            for (int i = 0; i < recipe.field_77577_c; ++i) {
                for (int j = 0; j < recipe.field_77576_b; ++j) {
                    ItemStack ingredientStack = recipe.field_77574_d[i * 3 + j];
                    if (ingredientStack == null) continue;
                    locatedStacks.add(new LocatedStack(ingredientStack, x + 1 + j * 18, y + 1 + i * 18));
                }
            }
            locatedStacks.add(new LocatedStack(recipe.func_77571_b(), x + 95, y + 19));
        } else if (recipeEvent.recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe recipe = (ShapedOreRecipe)recipeEvent.recipe;
            int recipeHeight = 0;
            int recipeWidth = 0;
            try {
                recipeHeight = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"height"}).getInt(recipe);
                recipeWidth = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"width"}).getInt(recipe);
            }
            catch (Exception e) {
                IGWLog.error("Something went wrong while trying to get the width and height fields from ShapedOreRecipe!");
                e.printStackTrace();
            }
            for (int i = 0; i < recipeHeight; ++i) {
                for (int j = 0; j < recipeWidth; ++j) {
                    ItemStack ingredientStack;
                    Object ingredient = recipe.getInput()[i * recipeWidth + j];
                    if (ingredient == null) continue;
                    ItemStack itemStack = ingredientStack = ingredient instanceof ItemStack ? (ItemStack)ingredient : (ItemStack)((List)ingredient).get(0);
                    if (ingredientStack == null) continue;
                    locatedStacks.add(new LocatedStack(ingredientStack, x + 1 + j * 18, y + 1 + i * 18));
                }
            }
            locatedStacks.add(new LocatedStack(recipe.func_77571_b(), x + 95, y + 19));
        } else if (recipeEvent.recipe instanceof ShapelessRecipes) {
            ShapelessRecipes recipe = (ShapelessRecipes)recipeEvent.recipe;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    ItemStack ingredientStack;
                    if (i * 3 + j >= recipe.field_77579_b.size() || (ingredientStack = (ItemStack)recipe.field_77579_b.get(i * 3 + j)) == null) continue;
                    locatedStacks.add(new LocatedStack(ingredientStack, x + 1 + j * 18, y + 1 + i * 18));
                }
            }
            locatedStacks.add(new LocatedStack(recipe.func_77571_b(), x + 95, y + 19));
        } else {
            if (recipeEvent.recipe == null) {
                throw new IllegalArgumentException("RecipeRetrievalEvent: For the given key, no subscriber returned a recipe! key = " + key);
            }
            throw new IllegalArgumentException("RecipeRetrievalEvent: Don't pass anything other than ShapedRecipes, ShapedOreRecipes or ShapelessRecipes! key = " + key);
        }
    }

    private void addManualCraftingRecipe(String[] codeParts, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures, int x, int y) throws IllegalArgumentException {
        int i;
        String[] ingredients = new String[codeParts.length - 3];
        for (int i2 = 3; i2 < codeParts.length; ++i2) {
            ingredients[i2 - 3] = codeParts[i2];
        }
        String result = codeParts[2];
        HashMap<String, ItemStack> ingredientMap = new HashMap<String, ItemStack>();
        for (i = 3; i < ingredients.length; ++i) {
            String[] ingredient = ingredients[i].split("=");
            ingredientMap.put(ingredient[0], WikiUtils.getStackFromName(ingredient[1]));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack ingredientStack = (ItemStack)ingredientMap.get(ingredients[i].substring(j, j + 1));
                if (ingredientStack == null) continue;
                locatedStacks.add(new LocatedStack(ingredientStack, x + 1 + j * 18, y + 1 + i * 18));
            }
        }
        ItemStack resultStack = WikiUtils.getStackFromName(result);
        if (resultStack != null) {
            locatedStacks.add(new LocatedStack(resultStack, x + 95, y + 19));
        }
    }
}

