/*
 * Decompiled with CFR 0.152.
 */
package igwmod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import igwmod.IProxy;
import igwmod.lib.Constants;
import igwmod.network.NetworkHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;

@Mod(modid="IGWMod", name="In-Game Wiki Mod")
public class IGWMod {
    @SidedProxy(clientSide="igwmod.ClientProxy", serverSide="igwmod.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="IGWMod")
    public IGWMod instance;

    @NetworkCheckHandler
    public boolean onConnectRequest(Map<String, String> installedMods, Side side) {
        if (side == Side.SERVER) {
            return true;
        }
        File serverFolder = new File(proxy.getSaveLocation() + "\\igwmodServer\\");
        if (serverFolder.exists()) {
            String version;
            String str = proxy.getSaveLocation() + "\\igwmodServer\\properties.txt";
            File file = new File(str);
            if (file.exists()) {
                try {
                    FileInputStream stream = new FileInputStream(file);
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
                    ArrayList<String> textList = new ArrayList<String>();
                    String line = br.readLine();
                    while (line != null) {
                        textList.add(line);
                        line = br.readLine();
                    }
                    br.close();
                    if (textList != null) {
                        for (String s : textList) {
                            String[] entry = s.split("=");
                            if (!entry[0].equals("optional") || !Boolean.parseBoolean(entry[1])) continue;
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((version = installedMods.get("IGWMod")).equals("${version}")) {
                return true;
            }
            return version != null && version.equals(Constants.fullVersionString());
        }
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = Constants.fullVersionString();
        proxy.preInit(event);
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        proxy.processIMC(event);
    }
}

