/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.client;

import info.jbcs.minecraft.chisel.Configurations;
import info.jbcs.minecraft.chisel.block.BlockHolystone;
import info.jbcs.minecraft.chisel.block.BlockLavastone;
import info.jbcs.minecraft.chisel.block.BlockSnakestoneObsidian;
import info.jbcs.minecraft.chisel.entity.EntityBallOMossFX;
import info.jbcs.minecraft.chisel.entity.EntityHolystoneFX;
import info.jbcs.minecraft.chisel.entity.EntitySnakestoneObsidianFX;
import info.jbcs.minecraft.utilities.GeneralClient;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityLavaFX;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneralChiselClient {
    public static Random rand = new Random();
    public static int tick = 0;

    public static void spawnLavastoneFX(World world, BlockLavastone block, int x, int y, int z) {
        if (Configurations.particlesTickrate != 0 && tick++ % Configurations.particlesTickrate != 0) {
            return;
        }
        float f = 0.15f;
        double x1 = (double)x + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double y1 = (double)y + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double z1 = (double)z + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        switch (rand.nextInt(6)) {
            case 0: {
                y1 = (double)y + block.func_149665_z() - (double)f;
                --y;
                break;
            }
            case 1: {
                y1 = (double)y + block.func_149669_A() + (double)f;
                ++y;
                break;
            }
            case 2: {
                z1 = (double)z + block.func_149706_B() - (double)f;
                --z;
                break;
            }
            case 3: {
                z1 = (double)z + block.func_149693_C() + (double)f;
                ++z;
                break;
            }
            case 4: {
                x1 = (double)x + block.func_149704_x() - (double)f;
                --x;
                break;
            }
            case 5: {
                x1 = (double)x + block.func_149753_y() + (double)f;
                ++x;
            }
        }
        if (world.func_147439_a(x, y, z).func_149662_c()) {
            return;
        }
        EntityLavaFX res = new EntityLavaFX(world, x1, y1, z1);
        double multiplier = 0.45;
        res.field_70159_w = -multiplier * (x1 - (double)x - 0.5);
        res.field_70181_x = multiplier * (y1 - (double)y - 0.5);
        res.field_70179_y = -multiplier * (z1 - (double)z - 0.5);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)res);
    }

    public static void spawnHolystoneFX(World world, BlockHolystone block, int x, int y, int z) {
        if (Configurations.particlesTickrate != 0 && tick++ % Configurations.particlesTickrate != 0) {
            return;
        }
        float f = 0.15f;
        double x1 = (double)x + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double y1 = (double)y + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double z1 = (double)z + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        switch (rand.nextInt(6)) {
            case 0: {
                y1 = (double)y + block.func_149665_z() - (double)f;
                --y;
                break;
            }
            case 1: {
                y1 = (double)y + block.func_149669_A() + (double)f;
                ++y;
                break;
            }
            case 2: {
                z1 = (double)z + block.func_149706_B() - (double)f;
                --z;
                break;
            }
            case 3: {
                z1 = (double)z + block.func_149693_C() + (double)f;
                ++z;
                break;
            }
            case 4: {
                x1 = (double)x + block.func_149704_x() - (double)f;
                --x;
                break;
            }
            case 5: {
                x1 = (double)x + block.func_149753_y() + (double)f;
                ++x;
            }
        }
        if (world.func_147439_a(x, y, z).func_149662_c()) {
            return;
        }
        EntityHolystoneFX res = new EntityHolystoneFX(world, block, x1, y1, z1);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)res);
    }

    public static void spawnSnakestoneObsidianFX(World world, BlockSnakestoneObsidian block, int x, int y, int z) {
        if (Configurations.particlesTickrate == 0 || tick++ % Configurations.particlesTickrate == 0) {
            EntitySnakestoneObsidianFX res = new EntitySnakestoneObsidianFX(world, block, x, y, z);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)res);
        }
    }

    public static void spawnBallOMossFX(World world, double x, double y, double z) {
        if (Configurations.particlesTickrate == 0 || tick++ % Configurations.particlesTickrate == 0) {
            EntityBallOMossFX res = new EntityBallOMossFX(world, x, y, z);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)res);
        }
    }

    public static EntityDiggingFX addBlockHitEffects(World world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return null;
        }
        EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
        float f = 0.1f;
        double d0 = (double)x + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double d1 = (double)y + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double d2 = (double)z + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        switch (side) {
            case 0: {
                d1 = (double)y + block.func_149665_z() - (double)f;
                break;
            }
            case 1: {
                d1 = (double)y + block.func_149669_A() + (double)f;
                break;
            }
            case 2: {
                d2 = (double)z + block.func_149706_B() - (double)f;
                break;
            }
            case 3: {
                d2 = (double)z + block.func_149693_C() + (double)f;
                break;
            }
            case 4: {
                d0 = (double)x + block.func_149704_x() - (double)f;
                break;
            }
            case 5: {
                d0 = (double)x + block.func_149753_y() + (double)f;
            }
        }
        EntityDiggingFX res = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, block, world.func_72805_g(x, y, z), side);
        res.field_70159_w = d0 - ((double)x + 0.5);
        res.field_70181_x = d1 - ((double)y + 0.5);
        res.field_70179_y = d2 - ((double)z + 0.5);
        renderer.func_78873_a((EntityFX)res);
        return res;
    }

    public static void spawnChiselEffect(int x, int y, int z, String sound) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (int side = 0; side < 6; ++side) {
            for (int j = 0; j < 16; ++j) {
                EntityDiggingFX fx = GeneralChiselClient.addBlockHitEffects((World)Minecraft.func_71410_x().field_71441_e, x, y, z, side);
                if (fx == null) {
                    return;
                }
                fx.func_70541_f(0.25f + 0.5f * rand.nextFloat());
                fx.func_70543_e(0.3f * rand.nextFloat());
            }
        }
        GeneralClient.playChiselSound((World)world, x, y, z, sound);
    }

    public static void speedupPlayer(World world, Entity entity, double concreteVelocity) {
        double velocity = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y);
        if (!(entity instanceof EntityPlayerSP)) {
            return;
        }
        if (velocity == 0.0) {
            return;
        }
        if (velocity >= Configurations.concreteVelocity) {
            return;
        }
        EntityPlayerSP player = (EntityPlayerSP)entity;
        if (Math.abs(player.field_71158_b.field_78900_b) < 0.75f && Math.abs(player.field_71158_b.field_78902_a) < 0.75f) {
            return;
        }
        entity.field_70159_w = Configurations.concreteVelocity * entity.field_70159_w / velocity;
        entity.field_70179_y = Configurations.concreteVelocity * entity.field_70179_y / velocity;
    }
}

