/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.item;

import cpw.mods.fml.common.FMLCommonHandler;
import info.jbcs.minecraft.chisel.Chisel;
import info.jbcs.minecraft.chisel.ChiselBlocks;
import info.jbcs.minecraft.chisel.Configurations;
import info.jbcs.minecraft.chisel.carving.CarvableHelper;
import info.jbcs.minecraft.chisel.carving.Carving;
import info.jbcs.minecraft.chisel.carving.CarvingVariation;
import info.jbcs.minecraft.chisel.client.GeneralChiselClient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemChisel
extends ItemTool {
    Random random = new Random();
    public Carving carving;
    private static final HashSet<String> toolSet = new HashSet();
    HashMap<String, Long> chiselUseTime = new HashMap();
    HashMap<String, String> chiselUseLocation = new HashMap();

    public ItemChisel(Carving c) {
        super(1.0f, Item.ToolMaterial.IRON, CarvableHelper.getChiselBlockSet());
        this.func_77625_d(1);
        this.func_77656_e(500);
        this.field_77864_a = 100.0f;
        this.func_77655_b("chisel");
        toolSet.add("chisel");
        this.carving = c;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return toolSet;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.openGui((Object)Chisel.instance, 0, world, 0, 0, 0);
        return itemstack;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        int blockMeta;
        if (!Configurations.enableChiseling) {
            return true;
        }
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (!ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)(blockMeta = world.func_72805_g(x, y, z)))) {
            return false;
        }
        ItemStack chiselTarget = null;
        if (stack.field_77990_d != null) {
            chiselTarget = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("chiselTarget"));
        }
        boolean chiselHasBlockInside = true;
        boolean noReplace = false;
        if (chiselTarget == null) {
            CarvingVariation[] variations;
            chiselHasBlockInside = false;
            Long useTime = this.chiselUseTime.get(player.func_70005_c_());
            String loc = this.chiselUseLocation.get(player.func_70005_c_());
            if (useTime != null && this.chiselUseLocation != null && loc.equals(x + "|" + y + "|" + z)) {
                long cooldown = 20L;
                long time = world.func_72912_H().func_82573_f();
                if (time > useTime - cooldown && time < useTime + cooldown) {
                    noReplace = true;
                }
            }
            if ((variations = this.carving.getVariations(block, blockMeta)) == null || variations.length < 2) {
                noReplace = true;
            } else {
                int index = this.random.nextInt(variations.length - 1);
                while (variations[index].block.equals(block) && variations[index].damage == blockMeta) {
                    if (++index < variations.length) continue;
                    index = 0;
                }
                CarvingVariation var = variations[index];
                chiselTarget = new ItemStack(var.block, 1, var.damage);
            }
        }
        Item result = null;
        int targetMeta = 0;
        if (!noReplace) {
            Item target = chiselTarget.func_77973_b();
            targetMeta = chiselTarget.func_77960_j();
            boolean match = this.carving.isVariationOfSameClass(Block.func_149634_a((Item)target), targetMeta, block, blockMeta);
            result = target;
            if (Configurations.chiselStoneToCobbleBricks) {
                if (!match && block.equals(Blocks.field_150348_b) && Block.func_149634_a((Item)target).equals(ChiselBlocks.blockCobblestone)) {
                    match = true;
                }
                if (!match && block.equals(Blocks.field_150348_b) && Block.func_149634_a((Item)target).equals(ChiselBlocks.stoneBrick)) {
                    match = true;
                }
            }
            if (!match) {
                noReplace = true;
            }
        }
        int updateValue = 2;
        if (noReplace) {
            result = Item.func_150898_a((Block)block);
            targetMeta = blockMeta;
        }
        if (!world.field_72995_K || chiselHasBlockInside) {
            world.func_147465_d(x, y, z, Block.func_149634_a((Item)result), targetMeta, updateValue);
        }
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case SERVER: {
                this.chiselUseTime.put(player.func_70005_c_(), world.func_72912_H().func_82573_f());
                this.chiselUseLocation.put(player.func_70005_c_(), x + "|" + y + "|" + z);
                break;
            }
            case CLIENT: {
                if (!chiselHasBlockInside) break;
                String sound = this.carving.getVariationSound(result, chiselTarget.func_77960_j());
                GeneralChiselClient.spawnChiselEffect(x, y, z, sound);
                break;
            }
        }
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (stack.field_77994_a == 0) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = chiselHasBlockInside ? chiselTarget : null;
        }
        return true;
    }
}

