/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.ai;

import mods.helpfulvillagers.entity.EntitySoldier;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.util.AIHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class EntityAIGuardVillageSoldier
extends EntityAITarget {
    EntitySoldier soldier;
    EntityLivingBase villageAgressorTarget;
    private float speed;

    public EntityAIGuardVillageSoldier(EntitySoldier soldier) {
        super((EntityCreature)soldier, false, false);
        this.soldier = soldier;
        this.speed = 0.75f;
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        if (this.soldier.currentActivity == EnumActivity.RETURN || this.soldier.currentActivity == EnumActivity.FOLLOW) {
            return false;
        }
        if (this.soldier.func_110143_aJ() < this.soldier.func_110143_aJ() / 2.0f) {
            this.soldier.currentActivity = EnumActivity.STORE;
            return true;
        }
        if (this.soldier.func_70643_av() != null && this.soldier.func_70643_av().func_70089_S() && this.soldier.func_70643_av() instanceof EntityMob) {
            this.villageAgressorTarget = this.soldier.func_70643_av();
            return true;
        }
        if (!this.soldier.field_70170_p.field_72995_K && this.soldier.homeVillage != null) {
            this.villageAgressorTarget = this.soldier.homeVillage.findNearestVillageAggressor((EntityLivingBase)this.soldier);
            if (this.villageAgressorTarget != null) {
                return true;
            }
        }
        if (!this.soldier.hasTool) {
            this.soldier.currentActivity = EnumActivity.STORE;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.soldier.func_70624_b(this.villageAgressorTarget);
        super.func_75249_e();
    }

    public boolean func_75253_b() {
        if (this.soldier.currentActivity == EnumActivity.RETURN || this.soldier.currentActivity == EnumActivity.FOLLOW) {
            return false;
        }
        if (this.soldier.currentActivity == EnumActivity.STORE) {
            return this.soldier.func_110143_aJ() < this.soldier.func_110143_aJ() / 2.0f || !this.soldier.hasTool;
        }
        return this.villageAgressorTarget != null && this.villageAgressorTarget.func_70089_S();
    }

    public void func_75246_d() {
        if (this.soldier.currentActivity == EnumActivity.STORE) {
            this.resupply();
        } else {
            this.attack();
        }
    }

    private void resupply() {
        if (this.soldier.homeGuildHall == null) {
            this.soldier.currentActivity = EnumActivity.IDLE;
            return;
        }
        if (!this.soldier.insideHall()) {
            this.soldier.currentActivity = EnumActivity.RETURN;
            return;
        }
        this.villageAgressorTarget = this.soldier.homeVillage.findNearestVillageAggressor((EntityLivingBase)this.soldier);
        if (this.soldier.func_110143_aJ() >= this.soldier.func_110143_aJ() / 2.0f && this.villageAgressorTarget != null) {
            this.soldier.currentActivity = EnumActivity.IDLE;
        }
        this.soldier.homeGuildHall.checkChests();
        TileEntityChest chest2 = this.soldier.homeGuildHall.getAvailableChest();
        if (!this.soldier.inventory.isEmpty() || !this.soldier.hasTool) {
            if (chest2 != null) {
                this.soldier.func_70661_as().func_75492_a((double)chest2.field_145851_c, (double)chest2.field_145848_d, (double)chest2.field_145849_e, (double)this.speed);
            }
            if (chest2 != null && AIHelper.findDistance((int)this.soldier.field_70165_t, chest2.field_145851_c) <= 2 && AIHelper.findDistance((int)this.soldier.field_70163_u, chest2.field_145848_d) <= 2 && AIHelper.findDistance((int)this.soldier.field_70161_v, chest2.field_145849_e) <= 2) {
                try {
                    this.soldier.inventory.dumpInventory(chest2);
                }
                catch (NullPointerException e) {
                    chest2.func_70305_f();
                }
                if (!this.soldier.hasTool) {
                    block2: for (TileEntityChest chest2 : this.soldier.homeGuildHall.guildChests) {
                        for (ItemStack i : this.soldier.getValidTools()) {
                            if (AIHelper.chestContains(chest2, i) < 0) continue;
                            int index = AIHelper.chestContains(chest2, i);
                            this.soldier.inventory.swapEquipment(chest2, index, 0);
                            this.soldier.currentActivity = EnumActivity.IDLE;
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    private void attack() {
        boolean canMove;
        if (this.soldier.func_70643_av() != null && this.soldier.func_70643_av().func_70089_S() && this.soldier.func_70643_av() instanceof EntityMob && this.villageAgressorTarget != this.soldier.func_70643_av()) {
            this.villageAgressorTarget = this.soldier.func_70643_av();
        }
        if (!(canMove = this.soldier.func_70661_as().func_75497_a((Entity)this.villageAgressorTarget, (double)this.speed))) {
            ChunkCoordinates target = new ChunkCoordinates((int)this.villageAgressorTarget.field_70165_t, (int)this.villageAgressorTarget.field_70163_u, (int)this.villageAgressorTarget.field_70161_v);
            Vec3 vector = Vec3.func_72443_a((double)target.field_71574_a, (double)target.field_71572_b, (double)target.field_71573_c);
            Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.soldier, (int)10, (int)3, (Vec3)vector);
            this.soldier.func_110171_b((int)this.soldier.field_70165_t, (int)this.soldier.field_70163_u, (int)this.soldier.field_70161_v, 20);
            if (tempVec != null) {
                this.soldier.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
            }
        }
        if (this.soldier.func_70068_e((Entity)this.villageAgressorTarget) <= 5.0) {
            this.soldier.func_70661_as().func_75499_g();
            this.soldier.func_71038_i();
            boolean attackSuccess = this.villageAgressorTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.soldier), (float)this.soldier.getAttackDamage());
            if (attackSuccess) {
                this.soldier.damageItem();
            }
        }
    }
}

