/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import mods.helpfulvillagers.ai.EntityAILumberjack;
import mods.helpfulvillagers.entity.AbstractVillager;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.main.HelpfulVillagers;
import mods.helpfulvillagers.network.SaplingPacket;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class EntityLumberjack
extends AbstractVillager {
    public boolean foundTree;
    public boolean shouldPlant;
    private int previousTime;
    private int currentTime;
    private final int SAPLING_TIME = 120;
    private final ItemStack[] lumberjackTools = new ItemStack[]{new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151006_E), new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151049_t), new ItemStack(Items.field_151053_p)};

    public EntityLumberjack(World world) {
        super(world);
        this.init();
    }

    public EntityLumberjack(AbstractVillager villager) {
        super(villager);
        this.init();
    }

    private void init() {
        this.profession = 1;
        this.profName = "Lumberjack";
        this.currentActivity = EnumActivity.IDLE;
        this.searchRadius = 10;
        this.foundTree = false;
        this.shouldPlant = false;
        this.previousTime = 0;
        this.currentTime = 0;
        this.setTools(this.lumberjackTools);
        this.getNewGuildHall();
        this.addThisAI();
    }

    @Override
    public boolean shouldReturn() {
        return !this.inventory.isFull() && this.hasTool && this.field_70170_p.func_72935_r();
    }

    private void addThisAI() {
        this.func_70661_as().func_75491_a(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, (double)0.3f, (double)0.35f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILumberjack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
    }

    @Override
    public void syncAll() {
        super.syncAll();
        if (!this.field_70170_p.field_72995_K) {
            HelpfulVillagers.network.sendToAll((IMessage)new SaplingPacket(this.func_145782_y(), this.shouldPlant));
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.pickupSaplings();
        this.shouldPlantSapling();
        if (this.shouldPlant) {
            this.plantSapling();
        }
        if (!this.field_70170_p.func_72935_r()) {
            if (this.foundTree) {
                this.foundTree = false;
            } else {
                this.lastResource = null;
            }
        }
    }

    private void shouldPlantSapling() {
        if (this.homeVillage != null && !this.field_70170_p.field_72995_K) {
            this.shouldPlant = !this.homeVillage.isInRange(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void plantSapling() {
        int index = this.inventory.containsItem(new ItemStack(Blocks.field_150345_g));
        if (this.previousTime <= 0) {
            this.previousTime = this.field_70173_aa;
        }
        this.currentTime = this.field_70173_aa;
        if (this.currentTime - this.previousTime >= 120) {
            this.previousTime = 0;
            if (index >= 0) {
                int y = (int)this.field_70163_u;
                while (true) {
                    Block air = this.field_70170_p.func_147439_a((int)this.field_70165_t, y, (int)this.field_70161_v);
                    Block dirt = this.field_70170_p.func_147439_a((int)this.field_70165_t, y - 1, (int)this.field_70161_v);
                    if (air.equals(Blocks.field_150350_a) && (dirt.equals(Blocks.field_150349_c) || dirt.equals(Blocks.field_150346_d))) {
                        ItemStack saplingItem = this.inventory.func_70301_a(index);
                        int metadata = saplingItem.func_77960_j();
                        this.field_70170_p.func_147465_d((int)this.field_70165_t, y, (int)this.field_70161_v, Block.func_149634_a((Item)saplingItem.func_77973_b()), metadata, 2);
                        this.inventory.decrementSlot(index);
                        return;
                    }
                    if (!air.equals(Blocks.field_150350_a)) {
                        return;
                    }
                    --y;
                }
            }
        }
    }

    private void pickupSaplings() {
        if (this.inventory.isFull()) {
            return;
        }
        List items = this.field_70170_p.func_72872_a(EntityItem.class, this.searchBox);
        for (EntityItem currentItem : items) {
            ItemStack currentStack = currentItem.func_92059_d();
            if (currentStack.func_82833_r() == null || !currentStack.func_82833_r().contains("Sapling")) continue;
            this.inventory.addItem(currentItem.func_92059_d());
            currentItem.func_70106_y();
        }
    }

    @Override
    public ArrayList getValidCoords() {
        this.updateBoxes();
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        AxisAlignedBB searchBox = this.searchBox;
        int x = (int)searchBox.field_72340_a;
        while ((double)x <= searchBox.field_72336_d) {
            int y = (int)searchBox.field_72338_b;
            while ((double)y <= searchBox.field_72337_e) {
                int z = (int)searchBox.field_72339_c;
                while ((double)z <= searchBox.field_72334_f) {
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (block.func_149688_o() == Material.field_151575_d) {
                        coords.add(new ChunkCoordinates(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return coords;
    }
}

