/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.entity;

import java.util.ArrayList;
import mods.helpfulvillagers.ai.EntityAIMiner;
import mods.helpfulvillagers.entity.AbstractVillager;
import mods.helpfulvillagers.enums.EnumActivity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class EntityMiner
extends AbstractVillager {
    private final ItemStack[] minerTools = new ItemStack[]{new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151005_D), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151039_o)};
    private final Block[] excludeBlocksArray = new Block[]{Blocks.field_150350_a, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150352_o, Blocks.field_150366_p, Blocks.field_150365_q, Blocks.field_150369_x, Blocks.field_150482_ag, Blocks.field_150450_ax, Blocks.field_150412_bA};
    public ArrayList excludeBlocks = new ArrayList();
    public ArrayList shaftCoords = new ArrayList();
    public ChunkCoordinates topCoords;
    public int topDir;
    public boolean bReturn;
    public boolean beingFollowed;

    public EntityMiner(World world) {
        super(world);
        this.init();
    }

    public EntityMiner(AbstractVillager villager) {
        super(villager);
        this.init();
    }

    private void init() {
        this.topCoords = null;
        this.topDir = 0;
        this.bReturn = false;
        this.beingFollowed = false;
        this.profession = 2;
        this.profName = "Miner";
        this.currentActivity = EnumActivity.IDLE;
        this.searchRadius = 5;
        this.setTools(this.minerTools);
        this.getNewGuildHall();
        this.addExcludeBlocks();
        this.addThisAI();
    }

    private void addExcludeBlocks() {
        for (int i = 0; i < this.excludeBlocksArray.length; ++i) {
            this.excludeBlocks.add(this.excludeBlocksArray[i]);
        }
    }

    private void addThisAI() {
        this.func_70661_as().func_75491_a(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, (double)0.3f, (double)0.35f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMiner(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
    }

    @Override
    public boolean shouldReturn() {
        return !this.inventory.isFull() && this.hasTool && this.field_70170_p.func_72935_r() && !this.bReturn;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public ArrayList getValidCoords() {
        this.updateBoxes();
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        AxisAlignedBB searchBox = this.searchBox;
        int x = (int)searchBox.field_72340_a;
        while ((double)x <= searchBox.field_72336_d) {
            int z = (int)searchBox.field_72339_c;
            while ((double)z <= searchBox.field_72334_f) {
                Block block = this.field_70170_p.func_147439_a(x, (int)this.field_70163_u, z);
                if (block.func_149688_o() == Material.field_151576_e) {
                    coords.add(new ChunkCoordinates(x, (int)this.field_70163_u, z));
                }
                ++z;
            }
            ++x;
        }
        return coords;
    }

    public int nearestShaftCoord() {
        for (int i = 0; i < this.shaftCoords.size(); ++i) {
            ChunkCoordinates currentCoords = (ChunkCoordinates)this.shaftCoords.get(i);
            if (currentCoords.field_71572_b != (int)this.field_70163_u) continue;
            return i;
        }
        if (this.topCoords != null && this.getCoords().field_71572_b >= this.topCoords.field_71572_b) {
            return 0;
        }
        return this.shaftCoords.size() - 1;
    }

    public boolean areCoordsInMine(ChunkCoordinates coords) {
        for (int i = 0; i < 4; ++i) {
            ChunkCoordinates check = (ChunkCoordinates)this.shaftCoords.get(i);
            if (coords.field_71574_a != check.field_71574_a || coords.field_71573_c != check.field_71573_c) continue;
            return true;
        }
        return false;
    }

    public boolean isInMine() {
        return this.areCoordsInMine(this.getCoords());
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        NBTTagList tagList = new NBTTagList();
        if (this.topCoords != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ChunkCoordinates topCoords = this.topCoords;
            int[] coords = new int[]{topCoords.field_71574_a, topCoords.field_71572_b, topCoords.field_71573_c};
            nbttagcompound.func_74783_a("Coords", coords);
            tagList.func_74742_a((NBTBase)nbttagcompound);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74768_a("Direction", this.topDir);
            tagList.func_74742_a((NBTBase)nbttagcompound1);
            par1NBTTagCompound.func_74782_a("Mineshaft", (NBTBase)tagList);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("Mineshaft")) {
            NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Mineshaft", (int)par1NBTTagCompound.func_74732_a());
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(0);
            int[] coords = nbttagcompound.func_74759_k("Coords");
            this.topCoords = new ChunkCoordinates(coords[0], coords[1], coords[2]);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(1);
            this.topDir = nbttagcompound1.func_74762_e("Direction");
        }
    }
}

