/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.village;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.helpfulvillagers.village.GuildHall;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HelpfulVillage {
    private final int NUM_PROFESSIONS = 13;
    public World world;
    public ChunkCoordinates initialCenter;
    public int radius;
    public ArrayList<GuildHall> guildHallList;
    public boolean[] unlockedHalls = new boolean[13];
    public int numVillagers;
    public AxisAlignedBB villageBounds;
    public AxisAlignedBB actualBounds;
    public ArrayList<ChunkCoordinates> villageDoors;
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public boolean dayCheck;

    public HelpfulVillage() {
    }

    public HelpfulVillage(World world, ChunkCoordinates center) {
        this.world = world;
        this.initialCenter = center;
        this.radius = 32;
        this.villageBounds = AxisAlignedBB.func_72330_a((double)(this.initialCenter.field_71574_a - this.radius), (double)(this.initialCenter.field_71572_b - this.radius), (double)(this.initialCenter.field_71573_c - this.radius), (double)(this.initialCenter.field_71574_a + this.radius), (double)(this.initialCenter.field_71572_b + this.radius), (double)(this.initialCenter.field_71573_c + this.radius));
        this.actualBounds = AxisAlignedBB.func_72330_a((double)this.initialCenter.field_71574_a, (double)this.initialCenter.field_71572_b, (double)this.initialCenter.field_71573_c, (double)this.initialCenter.field_71574_a, (double)this.initialCenter.field_71572_b, (double)this.initialCenter.field_71573_c);
        this.guildHallList = new ArrayList();
        this.villageDoors = new ArrayList();
        this.numVillagers = 0;
        this.dayCheck = false;
        this.initBounds();
    }

    public HelpfulVillage(World world, Village village) {
        this.world = world;
        this.initialCenter = village.func_75577_a();
        this.radius = village.func_75568_b();
        this.villageBounds = AxisAlignedBB.func_72330_a((double)(this.initialCenter.field_71574_a - this.radius), (double)(this.initialCenter.field_71572_b - this.radius), (double)(this.initialCenter.field_71573_c - this.radius), (double)(this.initialCenter.field_71574_a + this.radius), (double)(this.initialCenter.field_71572_b + this.radius), (double)(this.initialCenter.field_71573_c + this.radius));
        this.actualBounds = AxisAlignedBB.func_72330_a((double)this.initialCenter.field_71574_a, (double)this.initialCenter.field_71572_b, (double)this.initialCenter.field_71573_c, (double)this.initialCenter.field_71574_a, (double)this.initialCenter.field_71572_b, (double)this.initialCenter.field_71573_c);
        this.guildHallList = new ArrayList();
        this.villageDoors = new ArrayList();
        this.numVillagers = 0;
        this.dayCheck = false;
        this.initBounds();
    }

    private void initBounds() {
        this.minX = this.initialCenter.field_71574_a;
        this.maxX = this.initialCenter.field_71574_a;
        this.minY = this.initialCenter.field_71572_b;
        this.maxY = this.initialCenter.field_71572_b;
        this.minZ = this.initialCenter.field_71573_c;
        this.maxZ = this.initialCenter.field_71573_c;
    }

    public void updateVillageBox() {
        for (int i = 0; i < this.villageDoors.size(); ++i) {
            ChunkCoordinates currDoor = this.villageDoors.get(i);
            if (!this.world.func_147439_a(currDoor.field_71574_a, currDoor.field_71572_b, currDoor.field_71573_c).equals(Blocks.field_150466_ao)) {
                this.villageDoors.remove(i);
                continue;
            }
            if (this.getDoorFromCoords(currDoor.field_71574_a, currDoor.field_71572_b, currDoor.field_71573_c) != null) continue;
            this.villageDoors.remove(i);
        }
        int x = (int)this.villageBounds.field_72340_a;
        while ((double)x <= this.villageBounds.field_72336_d) {
            int y = (int)this.villageBounds.field_72338_b;
            while ((double)y <= this.villageBounds.field_72337_e) {
                int z = (int)this.villageBounds.field_72339_c;
                while ((double)z <= this.villageBounds.field_72334_f) {
                    ChunkCoordinates currCoords = new ChunkCoordinates(x, y, z);
                    if (this.world.func_147439_a(x, y, z).equals(Blocks.field_150466_ao) && !this.villageDoors.contains(currCoords)) {
                        ChunkCoordinates aboveCoords = new ChunkCoordinates(x, y + 1, z);
                        ChunkCoordinates belowCoords = new ChunkCoordinates(x, y - 1, z);
                        if (!(this.villageDoors.contains(aboveCoords) && this.villageDoors.contains(belowCoords) || this.getDoorFromCoords(currCoords.field_71574_a, currCoords.field_71572_b, currCoords.field_71573_c) == null)) {
                            this.villageDoors.add(currCoords);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int dist = 0;
        for (int i = 0; i < this.villageDoors.size(); ++i) {
            ChunkCoordinates currDoor = this.villageDoors.get(i);
            if (currDoor.field_71574_a < this.minX) {
                this.minX = currDoor.field_71574_a;
            } else if (currDoor.field_71574_a > this.maxX) {
                this.maxX = currDoor.field_71574_a;
            }
            if (currDoor.field_71572_b < this.minY) {
                this.minY = currDoor.field_71572_b;
            } else if (currDoor.field_71572_b > this.maxY) {
                this.maxY = currDoor.field_71572_b;
            }
            if (currDoor.field_71573_c < this.minZ) {
                this.minZ = currDoor.field_71573_c;
            } else if (currDoor.field_71573_c > this.maxZ) {
                this.maxZ = currDoor.field_71573_c;
            }
            dist = (int)Math.max(currDoor.func_82371_e(this.initialCenter), (float)dist);
        }
        this.radius = Math.max(32, (int)Math.sqrt(dist) + 10);
        this.villageBounds = AxisAlignedBB.func_72330_a((double)(this.initialCenter.field_71574_a - this.radius), (double)(this.initialCenter.field_71572_b - this.radius), (double)(this.initialCenter.field_71573_c - this.radius), (double)(this.initialCenter.field_71574_a + this.radius), (double)(this.initialCenter.field_71572_b + this.radius), (double)(this.initialCenter.field_71573_c + this.radius));
        this.actualBounds = AxisAlignedBB.func_72330_a((double)(this.minX - 5), (double)this.minY, (double)(this.minZ - 5), (double)(this.maxX + 5), (double)this.maxY, (double)(this.maxZ + 5));
    }

    public ChunkCoordinates getCenter() {
        return this.initialCenter;
    }

    public boolean isInRange(double x, double y, double z) {
        return x < this.villageBounds.field_72336_d && x > this.villageBounds.field_72340_a && y < this.villageBounds.field_72337_e && y > this.villageBounds.field_72338_b && z < this.villageBounds.field_72334_f & z > this.villageBounds.field_72339_c;
    }

    public VillageDoorInfo findNearestDoorUnrestricted(int x, int y, int z) {
        Village village = this.world.field_72982_D.func_75550_a(x, y, z, this.radius);
        if (village != null) {
            return village.func_75569_c(x, y, z);
        }
        VillageDoorInfo targetDoor = null;
        ChunkCoordinates currCoords = new ChunkCoordinates(x, y, z);
        Iterator<ChunkCoordinates> iterator = this.villageDoors.iterator();
        int dist = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            ChunkCoordinates currDoor = iterator.next();
            if ((int)Math.sqrt(currDoor.func_71569_e(x, y, z)) >= dist) continue;
            dist = (int)Math.sqrt(currDoor.func_71569_e(x, y, z));
            targetDoor = this.getDoorFromCoords(currDoor.field_71574_a, currDoor.field_71572_b, currDoor.field_71573_c);
        }
        return targetDoor;
    }

    private VillageDoorInfo getDoorFromCoords(int p_75542_1_, int p_75542_2_, int p_75542_3_) {
        int l = ((BlockDoor)Blocks.field_150466_ao).func_150013_e((IBlockAccess)this.world, p_75542_1_, p_75542_2_, p_75542_3_);
        if (l != 0 && l != 2) {
            int j1;
            int i1 = 0;
            for (j1 = -5; j1 < 0; ++j1) {
                if (!this.world.func_72937_j(p_75542_1_, p_75542_2_, p_75542_3_ + j1)) continue;
                --i1;
            }
            for (j1 = 1; j1 <= 5; ++j1) {
                if (!this.world.func_72937_j(p_75542_1_, p_75542_2_, p_75542_3_ + j1)) continue;
                ++i1;
            }
            if (i1 != 0) {
                return new VillageDoorInfo(p_75542_1_, p_75542_2_, p_75542_3_, 0, i1 > 0 ? -2 : 2, 0);
            }
        } else {
            int j1;
            int i1 = 0;
            for (j1 = -5; j1 < 0; ++j1) {
                if (!this.world.func_72937_j(p_75542_1_ + j1, p_75542_2_, p_75542_3_)) continue;
                --i1;
            }
            for (j1 = 1; j1 <= 5; ++j1) {
                if (!this.world.func_72937_j(p_75542_1_ + j1, p_75542_2_, p_75542_3_)) continue;
                ++i1;
            }
            if (i1 != 0) {
                return new VillageDoorInfo(p_75542_1_, p_75542_2_, p_75542_3_, i1 > 0 ? -2 : 2, 0, 0);
            }
        }
        return null;
    }

    public int getVillageRadius() {
        return this.radius;
    }

    public EntityLivingBase findNearestVillageAggressor(EntityLivingBase entity) {
        if (this.actualBounds == null) {
            return null;
        }
        List entities = this.world.func_72872_a(IMob.class, this.actualBounds);
        Iterator iterator = entities.iterator();
        double d0 = Double.MAX_VALUE;
        EntityLivingBase target = null;
        while (iterator.hasNext()) {
            Entity curr = (Entity)iterator.next();
            double d1 = entity.func_70068_e(curr);
            if (!(d1 < d0)) continue;
            d0 = d1;
            target = (EntityLivingBase)curr;
        }
        return target;
    }

    public GuildHall lookForExistingHall(int profession) {
        for (GuildHall guildHall : this.guildHallList) {
            if (guildHall.getTypeNum() != profession) continue;
            return guildHall;
        }
        return null;
    }

    public void checkUnlocked() {
        if (this.guildHallList == null) {
            return;
        }
        for (int i = 0; i < this.guildHallList.size(); ++i) {
            GuildHall guildHall = this.guildHallList.get(i);
            guildHall.checkFrame();
        }
    }

    public void findHalls() {
        for (int i = 1; i <= 13; ++i) {
            GuildHall adder = new GuildHall(this.world, this);
            adder.findCoords(i);
            if (adder.typeNum <= 0 || this.containsHall(adder) || adder.insideCoords.size() <= 0) continue;
            this.guildHallList.add(adder);
            this.unlockedHalls[adder.typeNum - 1] = true;
        }
    }

    public boolean containsHall(GuildHall hall) {
        for (int i = 0; i < this.guildHallList.size(); ++i) {
            if (!hall.equals(this.guildHallList.get(i))) continue;
            return true;
        }
        return false;
    }
}

