/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.ai;

import java.util.ArrayList;
import java.util.Random;
import mods.helpfulvillagers.entity.EntityMiner;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.util.AIHelper;
import mods.helpfulvillagers.util.ResourceCluster;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class EntityAIMiner
extends EntityAIBase {
    private EntityMiner miner;
    private ChunkCoordinates target;
    private float speed;
    private int shaftIndex;
    private ArrayList digCoords;
    private boolean dugSection;
    private ArrayList tunnelCoords;
    private ArrayList returnPath;
    private int currentTime;
    private int previousTime;
    private float harvestTime;
    private final int WAIT_TIME = 40;
    private int previousWait;
    private Block lastBlock;
    private Block lastAbove;
    private Block lastAbove2;
    private ArrayList surroundingCoords;
    private boolean reset;
    private boolean skipResource;
    Random gen;

    public EntityAIMiner(EntityMiner miner) {
        this.miner = miner;
        this.gen = new Random();
        this.target = null;
        this.speed = 0.5f;
        this.shaftIndex = miner.nearestShaftCoord();
        this.digCoords = new ArrayList();
        this.dugSection = false;
        this.tunnelCoords = new ArrayList();
        this.returnPath = new ArrayList();
        this.currentTime = 0;
        this.previousTime = 0;
        this.harvestTime = 0.0f;
        this.previousWait = 0;
        this.lastBlock = null;
        this.lastAbove = null;
        this.lastAbove2 = null;
        this.surroundingCoords = new ArrayList();
        this.reset = true;
        this.skipResource = false;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        switch (this.miner.currentActivity) {
            case GATHER: {
                return true;
            }
            case RETURN: {
                return true;
            }
            case CRAFT: {
                return true;
            }
            case STORE: {
                return true;
            }
            case IDLE: {
                return this.idle();
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        switch (this.miner.currentActivity) {
            case GATHER: {
                return this.gather();
            }
            case RETURN: {
                return this.mReturn();
            }
            case CRAFT: {
                return this.craft();
            }
            case STORE: {
                return this.store();
            }
            case IDLE: {
                return this.idle();
            }
        }
        return false;
    }

    private boolean idle() {
        this.miner.currentActivity = EnumActivity.IDLE;
        boolean dummyFlag = false;
        if (!this.miner.field_70170_p.field_72995_K && this.miner.homeVillage == null) {
            System.out.println("No Home Village");
            return false;
        }
        this.miner.checkGuildHall();
        if (this.miner.homeGuildHall == null) {
            System.out.println("No Guild Hall");
            return false;
        }
        if (this.miner.bReturn) {
            if (this.miner.insideHall()) {
                this.miner.currentActivity = EnumActivity.STORE;
                this.miner.topCoords = null;
                this.miner.topDir = 0;
                this.miner.shaftCoords.clear();
                return true;
            }
            return this.mReturn();
        }
        if (this.miner.inventory.isFull() || !this.miner.hasTool) {
            if (this.miner.insideHall()) {
                if (dummyFlag) {
                    this.miner.currentActivity = EnumActivity.CRAFT;
                    return true;
                }
                if (!this.miner.inventory.isEmpty() || !this.miner.hasTool) {
                    this.miner.currentActivity = EnumActivity.STORE;
                    return true;
                }
                return false;
            }
            System.out.println("Returning to Hall");
            return this.mReturn();
        }
        if (this.miner.field_70170_p.func_72935_r()) {
            this.miner.currentActivity = EnumActivity.GATHER;
            return true;
        }
        if (!this.miner.insideHall()) {
            return this.mReturn();
        }
        if (dummyFlag) {
            this.miner.currentActivity = EnumActivity.CRAFT;
            return true;
        }
        if (!this.miner.inventory.isEmpty() || !this.miner.hasTool) {
            this.miner.currentActivity = EnumActivity.STORE;
            return true;
        }
        return true;
    }

    private boolean gather() {
        if (this.miner.topCoords == null) {
            this.findMine();
        } else if (this.miner.shaftCoords.isEmpty()) {
            this.buildStairs(this.miner.topCoords, this.miner.topDir);
        } else if (!this.skipResource) {
            if (this.miner.currentResource == null) {
                this.getNewResource();
            }
            if (this.miner.currentResource == null) {
                if (this.returnPath.isEmpty()) {
                    this.digSection(this.shaftIndex, true);
                } else {
                    this.digTunnel(true);
                }
            } else if (!this.tunnelCoords.isEmpty()) {
                this.digTunnel(false);
            } else {
                this.mineResource();
            }
        } else {
            if (this.returnPath.isEmpty()) {
                this.digSection(this.shaftIndex, true);
            } else {
                this.digTunnel(true);
            }
            if ((int)this.miner.field_70163_u < (int)this.miner.field_70137_T) {
                this.skipResource = false;
            }
        }
        return this.idle();
    }

    private boolean store() {
        if (this.miner.homeGuildHall == null) {
            return this.idle();
        }
        TileEntityChest chest2 = this.miner.homeGuildHall.getAvailableChest();
        if (!this.miner.inventory.isEmpty() || !this.miner.hasTool) {
            if (chest2 != null) {
                this.miner.func_70661_as().func_75492_a((double)chest2.field_145851_c, (double)chest2.field_145848_d, (double)chest2.field_145849_e, (double)this.speed);
            } else {
                this.miner.bReturn = false;
            }
            if (chest2 != null && AIHelper.findDistance((int)this.miner.field_70165_t, chest2.field_145851_c) <= 2 && AIHelper.findDistance((int)this.miner.field_70163_u, chest2.field_145848_d) <= 2 && AIHelper.findDistance((int)this.miner.field_70161_v, chest2.field_145849_e) <= 2) {
                int solidIndex = this.miner.inventory.findSolidBlock(this.miner.excludeBlocks);
                ItemStack temp = null;
                if (solidIndex >= 0) {
                    temp = this.miner.inventory.func_70301_a(solidIndex);
                    this.miner.inventory.setMainContents(solidIndex, null);
                }
                try {
                    this.miner.inventory.dumpInventory(chest2);
                }
                catch (NullPointerException e) {
                    chest2.func_70305_f();
                }
                if (solidIndex >= 0) {
                    this.miner.inventory.addItem(temp);
                }
                if (!this.miner.hasTool) {
                    block2: for (TileEntityChest chest2 : this.miner.homeGuildHall.guildChests) {
                        for (ItemStack i : this.miner.getValidTools()) {
                            if (AIHelper.chestContains(chest2, i) < 0) continue;
                            int index = AIHelper.chestContains(chest2, i);
                            this.miner.inventory.swapEquipment(chest2, index, 0);
                            continue block2;
                        }
                    }
                }
                this.miner.bReturn = false;
            }
        }
        return this.idle();
    }

    private boolean craft() {
        return false;
    }

    private boolean mReturn() {
        System.out.println("RETURNING");
        if (this.miner.currentResource != null) {
            this.miner.currentResource = null;
        }
        this.tunnelCoords.clear();
        if (this.miner.topCoords == null || this.miner.homeVillage.isInRange(this.miner.field_70165_t, this.miner.field_70163_u, this.miner.field_70161_v)) {
            this.miner.currentActivity = EnumActivity.RETURN;
            this.reset = true;
            return false;
        }
        if (this.reset) {
            this.shaftIndex = this.miner.nearestShaftCoord();
            this.dugSection = false;
            this.digCoords.clear();
            this.reset = false;
        }
        if (this.returnPath.isEmpty()) {
            if (this.miner.shaftCoords.isEmpty()) {
                this.buildStairs(this.miner.topCoords, this.miner.topDir);
            }
            if (this.miner.nearestShaftCoord() == 0 || AIHelper.findDistance((int)this.miner.field_70165_t, this.miner.topCoords.field_71574_a) > 5 && AIHelper.findDistance((int)this.miner.field_70161_v, this.miner.topCoords.field_71573_c) > 5) {
                this.miner.currentActivity = EnumActivity.RETURN;
                this.reset = true;
                return false;
            }
            this.digSection(this.shaftIndex, false);
            return true;
        }
        this.digTunnel(true);
        return true;
    }

    private void findMine() {
        if (this.target == null) {
            this.target = this.miner.lastResource == null ? AIHelper.getRandOutsideCoords(this.miner, 20) : AIHelper.getRandOutsideCoords(this.miner, 40);
        }
        if (this.target != null) {
            Vec3 vector = Vec3.func_72443_a((double)this.target.field_71574_a, (double)this.target.field_71572_b, (double)this.target.field_71573_c);
            Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.miner, (int)10, (int)3, (Vec3)vector);
            this.miner.func_110171_b((int)this.miner.field_70165_t, (int)this.miner.field_70163_u, (int)this.miner.field_70161_v, 10);
            if (tempVec != null) {
                this.miner.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
            }
        }
        if (!this.miner.homeVillage.isInRange(this.miner.field_70165_t, this.miner.field_70163_u, this.miner.field_70161_v)) {
            ChunkCoordinates currCoords = new ChunkCoordinates((int)this.miner.field_70165_t, (int)this.miner.field_70163_u - 1, (int)this.miner.field_70161_v);
            Block currBlock = this.miner.field_70170_p.func_147439_a(currCoords.field_71574_a, currCoords.field_71572_b, currCoords.field_71573_c);
            if (currBlock.equals(Blocks.field_150366_p) || currBlock.equals(Blocks.field_150365_q) || currBlock.equals(Blocks.field_150348_b)) {
                this.miner.topCoords = new ChunkCoordinates(currCoords.field_71574_a, currCoords.field_71572_b, currCoords.field_71573_c);
                this.miner.topDir = this.miner.getDirection();
                this.miner.lastResource = new ResourceCluster(this.miner.field_70170_p, this.miner.topCoords);
            }
        }
        if (Math.abs(this.miner.field_70165_t - (double)this.target.field_71574_a) <= 2.0 && Math.abs(this.miner.field_70161_v - (double)this.target.field_71573_c) <= 2.0) {
            Block topBlock;
            this.miner.lastResource = null;
            this.surroundingCoords = this.miner.getSurroundingCoords();
            for (int i = 0; i < this.surroundingCoords.size(); ++i) {
                ChunkCoordinates coord = (ChunkCoordinates)this.surroundingCoords.get(i);
                Block block = this.miner.field_70170_p.func_147439_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
                if (!block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l)) continue;
                this.target = null;
                return;
            }
            ChunkCoordinates topCoords = this.miner.getCoords();
            while ((topBlock = this.miner.field_70170_p.func_147439_a(topCoords.field_71574_a, topCoords.field_71572_b, topCoords.field_71573_c)).equals(Blocks.field_150350_a)) {
                --topCoords.field_71572_b;
            }
            this.miner.topCoords = topCoords;
            this.miner.topDir = this.miner.getDirection();
        }
    }

    private void buildStairs(ChunkCoordinates coords, int direction) {
        Block currentBlock = this.miner.field_70170_p.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (coords.field_71572_b <= 0 || currentBlock.equals(Blocks.field_150357_h) || currentBlock.equals(Blocks.field_150353_l) || currentBlock.equals(Blocks.field_150355_j)) {
            return;
        }
        this.miner.shaftCoords.add(coords);
        ChunkCoordinates nextCoords = new ChunkCoordinates(coords.field_71574_a, coords.field_71572_b - 1, coords.field_71573_c);
        switch (direction) {
            case 0: {
                ++nextCoords.field_71573_c;
                break;
            }
            case 1: {
                --nextCoords.field_71574_a;
                break;
            }
            case 2: {
                --nextCoords.field_71573_c;
                break;
            }
            case 3: {
                ++nextCoords.field_71574_a;
            }
        }
        if (++direction > 3) {
            direction = 0;
        }
        this.buildStairs(nextCoords, direction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void digSection(int index, boolean down) {
        boolean shouldSwing;
        block22: {
            ChunkCoordinates stairCoords;
            block25: {
                block23: {
                    block26: {
                        block24: {
                            if (index >= this.miner.shaftCoords.size()) {
                                this.miner.bReturn = true;
                                return;
                            }
                            if (index < 0) {
                                this.shaftIndex = 0;
                                return;
                            }
                            shouldSwing = false;
                            stairCoords = (ChunkCoordinates)this.miner.shaftCoords.get(index);
                            this.miner.func_70661_as().func_75492_a((double)stairCoords.field_71574_a, (double)stairCoords.field_71572_b, (double)stairCoords.field_71573_c, (double)this.speed);
                            if (AIHelper.findDistance((int)this.miner.field_70165_t, stairCoords.field_71574_a) > 3 || AIHelper.findDistance((int)this.miner.field_70163_u, stairCoords.field_71572_b) > 3 || AIHelper.findDistance((int)this.miner.field_70161_v, stairCoords.field_71573_c) > 3) break block23;
                            if (this.dugSection) break block24;
                            break block25;
                        }
                        if (this.digCoords.isEmpty()) break block26;
                        ChunkCoordinates currentCoords = (ChunkCoordinates)this.digCoords.get(0);
                        Block currentBlock = this.miner.field_70170_p.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
                        if (this.previousTime <= 0) {
                            this.previousTime = this.miner.field_70173_aa;
                            if (this.miner.getCurrentItem() != null) {
                                this.harvestTime = 60.0f / this.miner.getCurrentItem().func_77973_b().getDigSpeed(this.miner.getCurrentItem(), currentBlock, this.miner.getCurrentItem().func_77973_b().func_77647_b(0));
                            }
                            shouldSwing = true;
                            break block22;
                        } else {
                            this.currentTime = this.miner.field_70173_aa;
                            if ((float)(this.currentTime - this.previousTime) >= this.harvestTime) {
                                this.previousTime = 0;
                                shouldSwing = false;
                                this.digCoords.remove(0);
                                AIHelper.breakBlock(currentCoords, this.miner);
                                break block22;
                            } else {
                                shouldSwing = true;
                            }
                        }
                        break block22;
                    }
                    Block stairBlock = this.miner.field_70170_p.func_147439_a(stairCoords.field_71574_a, stairCoords.field_71572_b, stairCoords.field_71573_c);
                    if (!stairBlock.isSideSolid((IBlockAccess)this.miner.field_70170_p, stairCoords.field_71574_a, stairCoords.field_71572_b, stairCoords.field_71573_c, ForgeDirection.UP) || stairBlock.equals(Blocks.field_150351_n) || stairBlock.equals(Blocks.field_150354_m)) {
                        int solidIndex = this.miner.inventory.findSolidBlock(this.miner.excludeBlocks);
                        if (solidIndex < 0) {
                            System.out.println("CANNOT FIND SOLID BLOCK, RETURNING TO SURFACE");
                            this.miner.bReturn = true;
                            return;
                        }
                        Block newBlock = Block.func_149634_a((Item)this.miner.inventory.func_70301_a(solidIndex).func_77973_b());
                        if (!(stairBlock.equals(Blocks.field_150350_a) || stairBlock.equals(Blocks.field_150355_j) || stairBlock.equals(Blocks.field_150353_l))) {
                            int metadata = this.miner.field_70170_p.func_72805_g(stairCoords.field_71574_a, stairCoords.field_71572_b, stairCoords.field_71573_c);
                            ItemStack item = new ItemStack(stairBlock, 1, metadata);
                            try {
                                this.miner.inventory.addItem(item);
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                        }
                        this.miner.field_70170_p.func_147449_b(stairCoords.field_71574_a, stairCoords.field_71572_b, stairCoords.field_71573_c, newBlock);
                        this.miner.inventory.decrementSlot(solidIndex);
                    } else {
                        ChunkCoordinates upCoords = new ChunkCoordinates(stairCoords.field_71574_a, stairCoords.field_71572_b + 2, stairCoords.field_71573_c);
                        if (!this.miner.beingFollowed && upCoords.field_71572_b < this.miner.topCoords.field_71572_b) {
                            ArrayList adjacentCoords = AIHelper.getAdjacentCoords(upCoords);
                            for (int i = 0; i < adjacentCoords.size(); ++i) {
                                ChunkCoordinates aCoords = (ChunkCoordinates)adjacentCoords.get(i);
                                Block aBlock = this.miner.field_70170_p.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
                                if (!this.miner.isInMine() || aBlock.isSideSolid((IBlockAccess)this.miner.field_70170_p, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, ForgeDirection.UP)) continue;
                                this.replaceBlock((ChunkCoordinates)adjacentCoords.get(i));
                            }
                        }
                    }
                    if (this.miner.func_70661_as().func_75500_f()) {
                        this.shaftIndex = down ? ++this.shaftIndex : --this.shaftIndex;
                        this.dugSection = false;
                    }
                    break block22;
                }
                if (AIHelper.findDistance((int)this.miner.field_70165_t, stairCoords.field_71574_a) > 10 || AIHelper.findDistance((int)this.miner.field_70161_v, stairCoords.field_71573_c) > 10) {
                    Vec3 vector = Vec3.func_72443_a((double)stairCoords.field_71574_a, (double)stairCoords.field_71572_b, (double)stairCoords.field_71573_c);
                    Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.miner, (int)10, (int)3, (Vec3)vector);
                    this.miner.func_110171_b((int)this.miner.field_70165_t, (int)this.miner.field_70163_u, (int)this.miner.field_70161_v, 10);
                    if (tempVec != null) {
                        this.miner.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
                    }
                    break block22;
                } else {
                    this.shaftIndex = this.miner.nearestShaftCoord();
                }
                break block22;
            }
            for (int i = 3; i >= 1; --i) {
                ChunkCoordinates aboveCoords = new ChunkCoordinates(stairCoords.field_71574_a, stairCoords.field_71572_b + i, stairCoords.field_71573_c);
                Block currentBlock = this.miner.field_70170_p.func_147439_a(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c);
                if (currentBlock.equals(Blocks.field_150357_h) || currentBlock.equals(Blocks.field_150355_j) || currentBlock.equals(Blocks.field_150353_l)) {
                    this.miner.bReturn = true;
                    return;
                }
                if (!currentBlock.isSideSolid((IBlockAccess)this.miner.field_70170_p, aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c, ForgeDirection.UP)) continue;
                this.digCoords.add(aboveCoords);
            }
            this.dugSection = true;
        }
        if (shouldSwing) {
            this.miner.func_71038_i();
        }
    }

    private boolean replaceBlock(ChunkCoordinates coords) {
        Block block = this.miner.field_70170_p.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        for (int i = 0; i < 4; ++i) {
            ChunkCoordinates checkCoords = (ChunkCoordinates)this.miner.shaftCoords.get(i);
            if (checkCoords.field_71574_a != coords.field_71574_a || checkCoords.field_71573_c != coords.field_71573_c) continue;
            return false;
        }
        int solidIndex = this.miner.inventory.findSolidBlock(this.miner.excludeBlocks);
        if (solidIndex >= 0) {
            Block newBlock = Block.func_149634_a((Item)this.miner.inventory.func_70301_a(solidIndex).func_77973_b());
            if (!(block.equals(Blocks.field_150350_a) || block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l))) {
                int metadata = this.miner.field_70170_p.func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                ItemStack item = new ItemStack(block, 1, metadata);
                try {
                    this.miner.inventory.addItem(item);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            this.miner.field_70170_p.func_147449_b(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, newBlock);
            this.miner.inventory.decrementSlot(solidIndex);
        }
        return true;
    }

    private void getNewResource() {
        ArrayList boxCoords = this.miner.getValidCoords();
        for (int i = 0; i < boxCoords.size(); ++i) {
            ChunkCoordinates currentCoords = (ChunkCoordinates)boxCoords.get(i);
            Block currentBlock = this.miner.field_70170_p.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
            int[] oreDictIDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(currentBlock));
            for (int j = 0; j < oreDictIDs.length; ++j) {
                String name = OreDictionary.getOreName((int)oreDictIDs[j]);
                if (!name.contains("ore")) continue;
                this.miner.currentResource = new ResourceCluster(this.miner.field_70170_p, currentCoords);
                this.miner.currentResource.buildCluster();
                this.buildTunnel();
                return;
            }
        }
    }

    private void buildTunnel() {
        ChunkCoordinates destCoords = this.miner.currentResource.coords;
        ChunkCoordinates currentCoords = new ChunkCoordinates((int)this.miner.field_70165_t, destCoords.field_71572_b, (int)this.miner.field_70161_v);
        while (true) {
            this.tunnelCoords.add(new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c));
            if (currentCoords.field_71574_a < destCoords.field_71574_a) {
                ++currentCoords.field_71574_a;
                continue;
            }
            if (currentCoords.field_71574_a <= destCoords.field_71574_a) break;
            --currentCoords.field_71574_a;
        }
        while (true) {
            this.tunnelCoords.add(new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c));
            if (currentCoords.field_71573_c < destCoords.field_71573_c) {
                ++currentCoords.field_71573_c;
                continue;
            }
            if (currentCoords.field_71573_c <= destCoords.field_71573_c) break;
            --currentCoords.field_71573_c;
        }
        this.tunnelCoords.remove(this.tunnelCoords.size() - 1);
        --this.shaftIndex;
    }

    private void digTunnel(boolean returning) {
        boolean shouldSwing;
        block47: {
            shouldSwing = false;
            ChunkCoordinates currentCoords = returning ? (ChunkCoordinates)this.returnPath.get(this.returnPath.size() - 1) : (ChunkCoordinates)this.tunnelCoords.get(0);
            ArrayList adjacent = AIHelper.getAdjacentCoords(currentCoords);
            for (int i = 0; i < adjacent.size(); ++i) {
                ChunkCoordinates check = (ChunkCoordinates)adjacent.get(i);
                Block checkBlock = this.miner.field_70170_p.func_147439_a(check.field_71574_a, check.field_71572_b, check.field_71573_c);
                if (!checkBlock.equals(Blocks.field_150353_l)) continue;
                this.tunnelCoords.clear();
                this.skipResource = true;
                this.miner.currentResource = null;
                return;
            }
            if (this.lastBlock != null && (this.lastBlock.equals(Blocks.field_150354_m) || this.lastBlock.equals(Blocks.field_150351_n))) {
                if (this.previousWait <= 0) {
                    this.previousWait = this.miner.field_70173_aa;
                    return;
                }
                this.currentTime = this.miner.field_70173_aa;
                if (this.currentTime - this.previousWait >= 40) {
                    this.previousWait = 0;
                    this.lastBlock = null;
                } else {
                    this.miner.func_71038_i();
                    return;
                }
            }
            if (this.lastAbove != null && (this.lastAbove.equals(Blocks.field_150354_m) || this.lastAbove.equals(Blocks.field_150351_n))) {
                if (this.previousWait <= 0) {
                    this.previousWait = this.miner.field_70173_aa;
                    return;
                }
                this.currentTime = this.miner.field_70173_aa;
                if (this.currentTime - this.previousWait >= 40) {
                    this.previousWait = 0;
                    this.lastAbove = null;
                } else {
                    this.miner.func_71038_i();
                    return;
                }
            }
            if (this.lastAbove2 != null && (this.lastAbove2.equals(Blocks.field_150354_m) || this.lastAbove2.equals(Blocks.field_150351_n))) {
                if (this.previousWait <= 0) {
                    this.previousWait = this.miner.field_70173_aa;
                    return;
                }
                this.currentTime = this.miner.field_70173_aa;
                if (this.currentTime - this.previousWait >= 40) {
                    this.previousWait = 0;
                    this.lastAbove2 = null;
                } else {
                    this.miner.func_71038_i();
                    return;
                }
            }
            ChunkCoordinates aboveCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b + 1, currentCoords.field_71573_c);
            ChunkCoordinates aboveCoords2 = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b + 2, currentCoords.field_71573_c);
            ChunkCoordinates belowCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b - 1, currentCoords.field_71573_c);
            Block currentBlock = this.miner.field_70170_p.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
            Block aboveBlock = this.miner.field_70170_p.func_147439_a(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c);
            Block aboveBlock2 = this.miner.field_70170_p.func_147439_a(aboveCoords2.field_71574_a, aboveCoords2.field_71572_b, aboveCoords2.field_71573_c);
            Block belowBlock = this.miner.field_70170_p.func_147439_a(belowCoords.field_71574_a, belowCoords.field_71572_b, belowCoords.field_71573_c);
            this.miner.func_70661_as().func_75492_a((double)currentCoords.field_71574_a, (double)currentCoords.field_71572_b, (double)currentCoords.field_71573_c, (double)this.speed);
            if (AIHelper.findDistance((int)this.miner.field_70165_t, currentCoords.field_71574_a) <= 3 && AIHelper.findDistance((int)this.miner.field_70163_u, currentCoords.field_71572_b) <= 3 && AIHelper.findDistance((int)this.miner.field_70161_v, currentCoords.field_71573_c) <= 3) {
                this.miner.func_70661_as().func_75499_g();
                if (!(currentBlock.equals(Blocks.field_150350_a) || currentBlock.equals(Blocks.field_150355_j) || currentBlock.equals(Blocks.field_150353_l))) {
                    if (this.previousTime <= 0) {
                        this.previousTime = this.miner.field_70173_aa;
                        if (this.miner.getCurrentItem() != null) {
                            this.harvestTime = 60.0f / this.miner.getCurrentItem().func_77973_b().getDigSpeed(this.miner.getCurrentItem(), currentBlock, this.miner.getCurrentItem().func_77973_b().func_77647_b(0));
                        }
                        shouldSwing = true;
                    } else {
                        this.currentTime = this.miner.field_70173_aa;
                        if ((float)(this.currentTime - this.previousTime) >= this.harvestTime) {
                            this.previousTime = 0;
                            shouldSwing = false;
                            AIHelper.breakBlock(currentCoords, this.miner);
                            this.lastBlock = currentBlock;
                        } else {
                            shouldSwing = true;
                        }
                    }
                } else if (!(aboveBlock.equals(Blocks.field_150350_a) || aboveBlock.equals(Blocks.field_150355_j) || aboveBlock.equals(Blocks.field_150353_l))) {
                    if (this.previousTime <= 0) {
                        this.previousTime = this.miner.field_70173_aa;
                        if (this.miner.getCurrentItem() != null) {
                            this.harvestTime = 60.0f / this.miner.getCurrentItem().func_77973_b().getDigSpeed(this.miner.getCurrentItem(), aboveBlock, this.miner.getCurrentItem().func_77973_b().func_77647_b(0));
                        }
                        shouldSwing = true;
                    } else {
                        this.currentTime = this.miner.field_70173_aa;
                        if ((float)(this.currentTime - this.previousTime) >= this.harvestTime) {
                            this.previousTime = 0;
                            shouldSwing = false;
                            AIHelper.breakBlock(aboveCoords, this.miner);
                            this.lastAbove = aboveBlock;
                        } else {
                            shouldSwing = true;
                        }
                    }
                } else if (!(aboveBlock2.equals(Blocks.field_150350_a) || aboveBlock2.equals(Blocks.field_150355_j) || aboveBlock2.equals(Blocks.field_150353_l))) {
                    if (this.previousTime <= 0) {
                        this.previousTime = this.miner.field_70173_aa;
                        if (this.miner.getCurrentItem() != null) {
                            this.harvestTime = 60.0f / this.miner.getCurrentItem().func_77973_b().getDigSpeed(this.miner.getCurrentItem(), aboveBlock2, this.miner.getCurrentItem().func_77973_b().func_77647_b(0));
                        }
                        shouldSwing = true;
                    } else {
                        this.currentTime = this.miner.field_70173_aa;
                        if ((float)(this.currentTime - this.previousTime) >= this.harvestTime) {
                            this.previousTime = 0;
                            shouldSwing = false;
                            AIHelper.breakBlock(aboveCoords2, this.miner);
                            this.lastAbove2 = aboveBlock2;
                        } else {
                            shouldSwing = true;
                        }
                    }
                } else if (!belowBlock.isSideSolid((IBlockAccess)this.miner.field_70170_p, belowCoords.field_71574_a, belowCoords.field_71572_b, belowCoords.field_71573_c, ForgeDirection.UP) || belowBlock.equals(Blocks.field_150351_n) || belowBlock.equals(Blocks.field_150354_m)) {
                    boolean replaced = this.replaceBlock(belowCoords);
                    if (!replaced) {
                        try {
                            if (returning) {
                                this.returnPath.remove(this.returnPath.size() - 1);
                                break block47;
                            }
                            this.returnPath.add(currentCoords);
                            this.tunnelCoords.remove(0);
                        }
                        catch (Exception e) {}
                    }
                } else if (returning) {
                    this.returnPath.remove(this.returnPath.size() - 1);
                } else {
                    this.returnPath.add(currentCoords);
                    this.tunnelCoords.remove(0);
                }
            } else if (AIHelper.findDistance((int)this.miner.field_70165_t, currentCoords.field_71574_a) > 10 || AIHelper.findDistance((int)this.miner.field_70161_v, currentCoords.field_71573_c) > 10) {
                Vec3 vector = Vec3.func_72443_a((double)currentCoords.field_71574_a, (double)currentCoords.field_71572_b, (double)currentCoords.field_71573_c);
                Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.miner, (int)10, (int)3, (Vec3)vector);
                this.miner.func_110171_b((int)this.miner.field_70165_t, (int)this.miner.field_70163_u, (int)this.miner.field_70161_v, 10);
                if (tempVec != null) {
                    this.miner.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
                }
            }
        }
        if (shouldSwing) {
            this.miner.func_71038_i();
        }
    }

    private void mineResource() {
        boolean shouldSwing = false;
        ChunkCoordinates currentCoords = this.miner.currentResource.coords;
        this.miner.func_70661_as().func_75492_a((double)currentCoords.field_71574_a, (double)currentCoords.field_71572_b, (double)currentCoords.field_71573_c, (double)this.speed);
        if (AIHelper.findDistance((int)this.miner.field_70165_t, currentCoords.field_71574_a) <= 3 && AIHelper.findDistance((int)this.miner.field_70163_u, currentCoords.field_71572_b) <= 3 && AIHelper.findDistance((int)this.miner.field_70161_v, currentCoords.field_71573_c) <= 3) {
            shouldSwing = true;
            if (this.previousTime <= 0) {
                this.previousTime = this.miner.field_70173_aa;
                this.harvestTime = 60.0f / this.miner.getCurrentItem().func_77973_b().getDigSpeed(this.miner.getCurrentItem(), this.miner.currentResource.startBlock, this.miner.getCurrentItem().func_77973_b().func_77647_b(0));
            }
            if (this.previousTime > 0) {
                this.currentTime = this.miner.field_70173_aa;
                if (!this.miner.currentResource.blockCluster.isEmpty()) {
                    if ((float)(this.currentTime - this.previousTime) >= this.harvestTime) {
                        this.previousTime = this.currentTime;
                        currentCoords = (ChunkCoordinates)this.miner.currentResource.blockCluster.get(0);
                        Block currentBlock = this.miner.field_70170_p.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
                        if (Block.func_149682_b((Block)currentBlock) == Block.func_149682_b((Block)this.miner.currentResource.startBlock)) {
                            AIHelper.breakBlock(currentCoords, this.miner);
                        }
                        this.miner.currentResource.blockCluster.remove(0);
                        if (currentCoords.field_71572_b == (int)this.miner.field_70163_u - 1) {
                            this.replaceBlock(currentCoords);
                        }
                    }
                } else {
                    this.miner.currentResource = null;
                    this.previousTime = 0;
                    this.currentTime = 0;
                }
            }
        } else if (AIHelper.findDistance((int)this.miner.field_70165_t, currentCoords.field_71574_a) > 10 || AIHelper.findDistance((int)this.miner.field_70161_v, currentCoords.field_71573_c) > 10) {
            Vec3 vector = Vec3.func_72443_a((double)currentCoords.field_71574_a, (double)currentCoords.field_71572_b, (double)currentCoords.field_71573_c);
            Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.miner, (int)10, (int)3, (Vec3)vector);
            this.miner.func_110171_b((int)this.miner.field_70165_t, (int)this.miner.field_70163_u, (int)this.miner.field_70161_v, 10);
            if (tempVec != null) {
                this.miner.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
            }
            shouldSwing = false;
        }
        if (shouldSwing) {
            this.miner.func_71038_i();
        }
    }
}

