/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import mods.helpfulvillagers.ai.EntityAIFollowLeader;
import mods.helpfulvillagers.ai.EntityAIMoveIndoorsCustom;
import mods.helpfulvillagers.ai.EntityAIVillagerMateCustom;
import mods.helpfulvillagers.entity.EntityArcher;
import mods.helpfulvillagers.entity.EntityFarmer;
import mods.helpfulvillagers.entity.EntityLumberjack;
import mods.helpfulvillagers.entity.EntityMiner;
import mods.helpfulvillagers.entity.EntityRegularVillager;
import mods.helpfulvillagers.entity.EntitySoldier;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.inventory.InventoryVillager;
import mods.helpfulvillagers.main.HelpfulVillagers;
import mods.helpfulvillagers.network.LeaderPacket;
import mods.helpfulvillagers.network.PlayerMessagePacket;
import mods.helpfulvillagers.network.SwingPacket;
import mods.helpfulvillagers.network.UnlockedHallsPacket;
import mods.helpfulvillagers.util.ResourceCluster;
import mods.helpfulvillagers.village.GuildHall;
import mods.helpfulvillagers.village.HelpfulVillage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public abstract class AbstractVillager
extends EntityVillager {
    public int profession;
    public String nickname;
    public String profName;
    public InventoryVillager inventory;
    public ChunkCoordinates villageCenter;
    public HelpfulVillage homeVillage;
    public GuildHall homeGuildHall;
    public EntityLivingBase leader;
    private int leaderID;
    public int guiCommand;
    public boolean hasTool;
    private boolean isSwinging;
    private int swingTicks;
    private int healthTicks;
    protected ItemStack[] validTools = new ItemStack[0];
    public AxisAlignedBB searchBox;
    public AxisAlignedBB pickupBox;
    protected int searchRadius;
    protected int pickupRadius;
    private boolean canPickup;
    public EnumActivity currentActivity;
    public ResourceCluster lastResource;
    public ResourceCluster currentResource;
    public int villagerID;

    public AbstractVillager() {
        super(null);
    }

    public AbstractVillager(World world) {
        super(world);
        this.field_70138_W = (float)((double)this.field_70138_W + 0.5);
        this.profession = 0;
        this.nickname = "";
        this.inventory = new InventoryVillager(this);
        this.villageCenter = null;
        this.homeVillage = null;
        this.homeGuildHall = null;
        this.leader = null;
        this.guiCommand = -1;
        this.isSwinging = false;
        this.healthTicks = 0;
        this.searchBox = this.field_70121_D.func_72329_c();
        this.pickupBox = this.field_70121_D.func_72329_c();
        this.searchRadius = 1;
        this.pickupRadius = 1;
        this.canPickup = true;
        this.currentActivity = EnumActivity.IDLE;
        this.lastResource = null;
        this.hasTool = false;
        this.villagerID = 0;
        this.leaderID = 0;
        this.addAI();
    }

    public AbstractVillager(AbstractVillager villager) {
        super(villager.field_70170_p);
        this.field_70138_W = (float)((double)this.field_70138_W + 0.5);
        this.nickname = villager.nickname;
        this.inventory = villager.inventory;
        this.inventory.owner = this;
        this.villageCenter = villager.villageCenter;
        this.homeVillage = villager.homeVillage;
        this.homeGuildHall = null;
        this.leader = villager.leader;
        this.guiCommand = villager.guiCommand;
        this.isSwinging = false;
        this.healthTicks = 0;
        this.searchBox = this.field_70121_D.func_72329_c();
        this.pickupBox = this.field_70121_D.func_72329_c();
        this.searchRadius = 1;
        this.pickupRadius = 1;
        this.canPickup = true;
        this.currentActivity = EnumActivity.IDLE;
        this.lastResource = null;
        this.hasTool = false;
        this.villagerID = 0;
        this.leaderID = 0;
        this.func_94058_c(villager.func_94057_bL());
        this.addAI();
    }

    public void addAI() {
        this.field_70714_bg.field_75782_a.clear();
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowLeader(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoorsCustom(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIVillagerMateCustom(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, (double)0.3f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowGolem((EntityVillager)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIPlay((EntityVillager)this, (double)0.32f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityVillager.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)0.3f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (HelpfulVillagers.player_guard.containsKey(player)) {
            AbstractVillager guard = HelpfulVillagers.player_guard.remove(player);
            if (guard.equals((Object)this)) {
                HelpfulVillagers.player_guard.put(player, guard);
            } else {
                guard.setLeader((EntityLivingBase)this);
                if (this.field_70170_p.field_72995_K) {
                    String guardName = guard.func_94057_bL();
                    guardName = guardName == null || guardName.equals("") || guardName.equals(" ") ? "A " + guard.profName : guardName + " the " + guard.profName;
                    String leaderName = this.func_94057_bL();
                    leaderName = leaderName == null || leaderName.equals("") || leaderName.equals(" ") ? "this " + this.profName : leaderName + " the " + this.profName;
                    String message = guardName + " is now guarding " + leaderName;
                    player.func_145747_a((IChatComponent)new ChatComponentText(message));
                }
                return false;
            }
        }
        if (this.func_70631_g_()) {
            return false;
        }
        this.func_70932_a_(player);
        player.openGui((Object)HelpfulVillagers.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
        return true;
    }

    private void handleGuiCommand() {
        EntityPlayer player = this.func_70931_l_();
        switch (this.guiCommand) {
            case 0: {
                this.setLeader((EntityLivingBase)player);
                this.currentActivity = EnumActivity.FOLLOW;
                break;
            }
            case 1: {
                if (this.leader instanceof EntityMiner) {
                    EntityMiner miner = (EntityMiner)this.leader;
                    miner.beingFollowed = false;
                }
                this.setLeader(null);
                this.currentActivity = EnumActivity.IDLE;
                break;
            }
            case 2: {
                if (!this.func_70089_S() || this.func_70631_g_() || player.func_70093_af()) break;
                player.openGui((Object)HelpfulVillagers.instance, 2, this.field_70170_p, this.func_145782_y(), 0, 0);
                break;
            }
            case 3: {
                player.openGui((Object)HelpfulVillagers.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
                break;
            }
            case 4: {
                player.openGui((Object)HelpfulVillagers.instance, 3, this.field_70170_p, this.func_145782_y(), 0, 0);
                break;
            }
            case 5: {
                HelpfulVillagers.player_guard.put(player, this);
                if (this.leader != null && this.leader instanceof EntityMiner) {
                    EntityMiner miner = (EntityMiner)this.leader;
                    miner.beingFollowed = false;
                }
                this.setLeader((EntityLivingBase)player);
                this.currentActivity = EnumActivity.FOLLOW;
                break;
            }
        }
        this.guiCommand = -1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.guiCommand >= 0) {
            try {
                this.handleGuiCommand();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.leader != null) {
            this.currentActivity = EnumActivity.FOLLOW;
        }
        this.getNewHomeVillage();
        this.getNewGuildHall();
        this.updateBoxes();
        this.updateArmor();
        this.updateSwing();
        this.updateHealth();
        this.updateID();
        this.updateLeader();
        this.pickupItems();
        this.resetTool();
        this.syncAll();
    }

    public ChunkCoordinates getCoords() {
        return new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public ArrayList getSurroundingCoords() {
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        for (int x = (int)this.field_70165_t - 1; x <= (int)this.field_70165_t + 1; ++x) {
            for (int y = (int)this.field_70163_u; y <= (int)this.field_70163_u + 1; ++y) {
                for (int z = (int)this.field_70161_v - 1; z <= (int)this.field_70161_v + 1; ++z) {
                    coords.add(new ChunkCoordinates(x, y, z));
                }
            }
        }
        return coords;
    }

    public int getDirection() {
        return MathHelper.func_76128_c((double)((double)(this.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public void func_70938_b(int par1) {
        if (this.profession != par1) {
            switch (par1) {
                case 0: {
                    EntityRegularVillager villager = new EntityRegularVillager(this);
                    villager.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)villager);
                        if (villager.leader != null && !(villager.leader instanceof AbstractVillager)) {
                            HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(villager.func_145782_y(), villager.leader.func_145782_y()));
                        }
                    }
                    this.func_70106_y();
                    break;
                }
                case 1: {
                    EntityLumberjack lumberjack = new EntityLumberjack(this);
                    lumberjack.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)lumberjack);
                        if (lumberjack.leader != null && !(lumberjack.leader instanceof AbstractVillager)) {
                            HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(lumberjack.func_145782_y(), lumberjack.leader.func_145782_y()));
                        }
                    }
                    this.func_70106_y();
                    break;
                }
                case 2: {
                    EntityMiner miner = new EntityMiner(this);
                    miner.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)miner);
                        if (miner.leader != null && !(miner.leader instanceof AbstractVillager)) {
                            HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(miner.func_145782_y(), miner.leader.func_145782_y()));
                        }
                    }
                    this.func_70106_y();
                    break;
                }
                case 3: {
                    EntityFarmer farmer = new EntityFarmer(this);
                    farmer.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)farmer);
                        if (farmer.leader != null && !(farmer.leader instanceof AbstractVillager)) {
                            HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(farmer.func_145782_y(), farmer.leader.func_145782_y()));
                        }
                    }
                    this.func_70106_y();
                    break;
                }
                case 9: {
                    EntitySoldier soldier = new EntitySoldier(this);
                    soldier.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)soldier);
                        if (soldier.leader != null) {
                            HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(soldier.func_145782_y(), soldier.leader.func_145782_y()));
                        }
                    }
                    this.func_70106_y();
                    break;
                }
                case 10: {
                    EntityArcher archer = new EntityArcher(this);
                    archer.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)archer);
                        if (archer.leader != null) {
                            HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(archer.func_145782_y(), archer.leader.func_145782_y()));
                        }
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    public int func_70946_n() {
        return this.profession;
    }

    public void setLeader(EntityLivingBase leader) {
        this.leader = leader;
        if (leader != null && leader instanceof AbstractVillager) {
            if (this.profession == 9 || this.profession == 10) {
                AbstractVillager villager = (AbstractVillager)leader;
                this.leaderID = villager.villagerID;
                if (villager instanceof EntityMiner) {
                    EntityMiner miner = (EntityMiner)villager;
                    miner.beingFollowed = true;
                }
            } else {
                this.leader = null;
                this.leaderID = -1;
            }
        } else {
            this.leaderID = -1;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.leader == null) {
                HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(this.func_145782_y(), -1));
            } else {
                HelpfulVillagers.network.sendToAll((IMessage)new LeaderPacket(this.func_145782_y(), this.leader.func_145782_y()));
            }
        }
    }

    public EntityLivingBase getLeader() {
        return this.leader;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        return null;
    }

    public void takeItemFromPlayer(EntityPlayer player) {
        this.inventory.setCurrentItem(player.field_71071_by.func_70448_g());
        player.func_71028_bD();
    }

    public void giveItemToPlayer(EntityPlayer player) {
        if (this.inventory.getCurrentItem() != null) {
            player.field_71071_by.func_70441_a(this.inventory.getCurrentItem());
            this.inventory.setCurrentItem(null);
        }
    }

    public ItemStack[] getValidTools() {
        return this.validTools;
    }

    public boolean isValidTool(ItemStack item) {
        for (ItemStack i : this.validTools) {
            if (i == null || !item.func_82833_r().equals(i.func_82833_r())) continue;
            return true;
        }
        return false;
    }

    protected void setTools(ItemStack[] items) {
        this.validTools = new ItemStack[items.length];
        System.arraycopy(items, 0, this.validTools, 0, this.validTools.length);
    }

    private void resetTool() {
        if (this.getCurrentItem() != null && !this.isValidTool(this.getCurrentItem())) {
            this.hasTool = false;
            if (!this.inventory.isFull()) {
                this.inventory.addItem(this.inventory.getCurrentItem());
            } else {
                EntityItem worldItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getCurrentItem());
                this.field_70170_p.func_72838_d((Entity)worldItem);
            }
            this.inventory.setCurrentItem(null);
        } else if (this.getCurrentItem() == null && this.validTools.length > 0) {
            this.hasTool = false;
            for (ItemStack i : this.getValidTools()) {
                if (this.inventory.containsItem(i) < 0) continue;
                int index = this.inventory.containsItem(i);
                this.inventory.swapEquipment(index, 0);
                this.hasTool = true;
                break;
            }
        } else {
            this.hasTool = true;
        }
    }

    public ItemStack getCurrentItem() {
        return this.inventory.getCurrentItem();
    }

    public ItemStack func_70694_bm() {
        return this.getCurrentItem();
    }

    public void damageItem() {
        if (this.getCurrentItem() == null) {
            return;
        }
        this.getCurrentItem().func_77964_b(this.getCurrentItem().func_77960_j() + 1);
        if (this.getCurrentItem().func_77960_j() >= this.getCurrentItem().func_77958_k()) {
            this.inventory.setCurrentItem(null);
        }
    }

    public void func_71038_i() {
        if (this.field_70170_p.field_72995_K) {
            if (!this.isSwinging || this.swingTicks >= 4 || this.swingTicks < 0) {
                this.swingTicks = -1;
                this.isSwinging = true;
            }
        } else {
            HelpfulVillagers.network.sendToAll((IMessage)new SwingPacket(this.func_145782_y()));
        }
    }

    private void updateSwing() {
        if (this.isSwinging) {
            ++this.swingTicks;
            if (this.swingTicks >= 8) {
                this.swingTicks = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingTicks = 0;
        }
        this.field_70733_aJ = (float)this.swingTicks / 8.0f;
    }

    public boolean isSwinging() {
        return this.isSwinging;
    }

    public void updateBoxes() {
        this.searchBox.func_72324_b(this.field_70165_t - (double)this.searchRadius, this.field_70163_u - (double)this.searchRadius, this.field_70161_v - (double)this.searchRadius, this.field_70165_t + (double)this.searchRadius, this.field_70163_u + (double)this.searchRadius, this.field_70161_v + (double)this.searchRadius);
        this.pickupBox.func_72324_b(this.field_70165_t - (double)this.pickupRadius, this.field_70163_u - (double)this.pickupRadius, this.field_70161_v - (double)this.pickupRadius, this.field_70165_t + (double)this.pickupRadius, this.field_70163_u + (double)this.pickupRadius, this.field_70161_v + (double)this.pickupRadius);
    }

    protected void pickupItems() {
        if (this.func_70631_g_() || !this.canPickup) {
            return;
        }
        if (this.inventory.isFull()) {
            return;
        }
        List items = this.field_70170_p.func_72872_a(EntityItem.class, this.pickupBox);
        for (EntityItem currentItem : items) {
            this.inventory.addItem(currentItem.func_92059_d());
            currentItem.func_70106_y();
        }
    }

    private void updateArmor() {
        this.func_70062_b(4, this.inventory.func_70301_a(28));
        this.func_70062_b(3, this.inventory.func_70301_a(29));
        this.func_70062_b(2, this.inventory.func_70301_a(30));
        this.func_70062_b(1, this.inventory.func_70301_a(31));
    }

    private void updateHealth() {
        ++this.healthTicks;
        if (this.healthTicks == 60) {
            this.func_70691_i(0.5f);
            this.healthTicks = 0;
        }
    }

    private void updateLeader() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.leader != null) {
                EntityLivingBase temp = (EntityLivingBase)this.field_70170_p.func_73045_a(this.leader.func_145782_y());
                this.setLeader(temp);
            } else if (this.leaderID > 0) {
                AbstractVillager temp = HelpfulVillagers.villager_id.get(this.leaderID);
                this.setLeader((EntityLivingBase)temp);
            }
        }
    }

    private void updateID() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.func_70681_au().nextInt(10) && this.villagerID <= 0) {
            int newKey = Math.abs(this.func_70681_au().nextInt());
            while (HelpfulVillagers.villager_id.containsKey(newKey)) {
                newKey = Math.abs(this.func_70681_au().nextInt());
            }
            this.villagerID = newKey;
            HelpfulVillagers.villager_id.put(this.villagerID, this);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        for (int i = 28; i < 32; ++i) {
            ItemStack armorPiece = this.inventory.func_70301_a(i);
            if (armorPiece == null) continue;
            armorPiece.func_77964_b(armorPiece.func_77960_j() + 1);
            if (armorPiece.func_77960_j() >= armorPiece.func_77958_k()) {
                armorPiece = null;
            }
            this.inventory.func_70299_a(i, armorPiece);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.villageCenter != null) {
            int[] villageCoords = new int[]{this.villageCenter.field_71574_a, this.villageCenter.field_71572_b, this.villageCenter.field_71573_c};
            compound.func_74782_a("Village", (NBTBase)new NBTTagIntArray(villageCoords));
        }
        compound.func_74782_a("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        if (this.lastResource != null) {
            compound.func_74782_a("Resource", (NBTBase)this.lastResource.writeToNBT(new NBTTagList()));
        }
        compound.func_74782_a("VillagerID", (NBTBase)new NBTTagInt(this.villagerID));
        compound.func_74782_a("LeaderID", (NBTBase)new NBTTagInt(this.leaderID));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        int[] village = compound.func_74759_k("Village");
        if (village.length > 0) {
            this.villageCenter = new ChunkCoordinates(village[0], village[1], village[2]);
            boolean addVillage = true;
            for (int i = 0; i < HelpfulVillagers.villages.size(); ++i) {
                HelpfulVillage currVillage = HelpfulVillagers.villages.get(i);
                if (!currVillage.initialCenter.equals((Object)this.villageCenter)) continue;
                addVillage = false;
                break;
            }
            if (addVillage) {
                HelpfulVillagers.villages.add(new HelpfulVillage(this.field_70170_p, this.villageCenter));
            }
        }
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", (int)compound.func_74732_a());
        this.inventory.readFromNBT(nbttaglist);
        if (compound.func_74764_b("Resource")) {
            this.lastResource = new ResourceCluster(this.field_70170_p);
            nbttaglist = compound.func_150295_c("Resource", (int)compound.func_74732_a());
            this.lastResource.readFromNBT(nbttaglist);
        }
        this.villagerID = compound.func_74762_e("VillagerID");
        HelpfulVillagers.villager_id.put(this.villagerID, this);
        this.leaderID = compound.func_74762_e("LeaderID");
    }

    public void syncAll() {
        if (!this.field_70170_p.field_72995_K) {
            this.inventory.syncInventory();
            if (this.homeVillage != null) {
                HelpfulVillagers.network.sendToAll((IMessage)new UnlockedHallsPacket(this.func_145782_y(), this.homeVillage.unlockedHalls));
            }
        }
    }

    public void getNewHomeVillage() {
        if (!this.field_70170_p.field_72995_K && this.homeVillage == null) {
            if (this.villageCenter != null) {
                for (int i = 0; i < HelpfulVillagers.villages.size(); ++i) {
                    if (!HelpfulVillagers.villages.get(i).equals(this.villageCenter)) continue;
                    this.homeVillage = HelpfulVillagers.villages.get(i);
                    ++this.homeVillage.numVillagers;
                    return;
                }
            }
            double closestDist = 100.0;
            HelpfulVillage closestVillage = null;
            for (int i = 0; i < HelpfulVillagers.villages.size(); ++i) {
                HelpfulVillage currVillage = HelpfulVillagers.villages.get(i);
                ChunkCoordinates center = currVillage.getCenter();
                double dist = this.func_70011_f(center.field_71574_a, center.field_71572_b, center.field_71573_c);
                if (!currVillage.isInRange(this.field_70165_t, this.field_70163_u, this.field_70161_v) && !(dist < closestDist)) continue;
                closestDist = dist;
                closestVillage = currVillage;
            }
            if (closestVillage != null) {
                this.homeVillage = closestVillage;
                ++this.homeVillage.numVillagers;
                this.villageCenter = this.homeVillage.initialCenter;
            } else {
                int x = (int)this.field_70165_t;
                int z = (int)this.field_70161_v;
                int y = this.field_70170_p.func_72825_h(x, z);
                this.homeVillage = new HelpfulVillage(this.field_70170_p, new ChunkCoordinates(x, y, z));
                ++this.homeVillage.numVillagers;
                HelpfulVillagers.villages.add(this.homeVillage);
            }
        }
    }

    public void returnToOrigin() {
        if (this.homeVillage == null) {
            this.func_70661_as().func_75492_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)0.3f);
        } else {
            this.func_70661_as().func_75492_a((double)this.homeVillage.getCenter().field_71574_a, (double)this.homeVillage.getCenter().field_71572_b, (double)this.homeVillage.getCenter().field_71573_c, (double)0.3f);
        }
    }

    public void getNewGuildHall() {
        if (!this.field_70170_p.field_72995_K && this.homeVillage != null) {
            if (this.profession == 0) {
                this.homeGuildHall = null;
            } else if (this.homeGuildHall == null) {
                this.homeGuildHall = this.homeVillage.lookForExistingHall(this.profession);
            } else if (this.homeGuildHall.itemFrame == null) {
                this.homeGuildHall = this.homeVillage.lookForExistingHall(this.profession);
            }
        }
    }

    public void checkGuildHall() {
        if (this.currentActivity == EnumActivity.IDLE && this.homeGuildHall != null) {
            if (!this.homeVillage.guildHallList.contains(this.homeGuildHall)) {
                this.homeGuildHall = null;
            }
            if (this.homeGuildHall != null && this.insideHall()) {
                this.homeGuildHall.checkChests();
            }
        }
    }

    public boolean insideHall() {
        ChunkCoordinates currentPosition = new ChunkCoordinates((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        return this.homeGuildHall != null && this.homeGuildHall.insideCoords.contains(currentPosition);
    }

    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (this.homeVillage != null) {
            --this.homeVillage.numVillagers;
        }
        this.canPickup = false;
        this.inventory.dumpInventory();
        this.sendDeathMessage(src);
    }

    private void sendDeathMessage(DamageSource src) {
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase lastTarget;
            String name = this.func_94057_bL();
            name = name == null || name.equals("") || name.equals(" ") ? "A " + this.profName : name + " the " + this.profName;
            String cause = src.field_76373_n;
            Entity attacker = src.func_76346_g();
            EntityLivingBase aiAttacker = this.func_70643_av();
            cause = cause.equals("anvil") ? " was squashed by an anvil" : (cause.equals("cactus") ? (aiAttacker != null && aiAttacker.func_70089_S() ? " walked into a cactus whilst trying to escape " + aiAttacker.func_70005_c_() : " was pricked to death") : (cause.equals("arrow") ? (attacker.func_70005_c_().equals("arrow") ? " was shot by an arrow" : " was shot by " + attacker.func_70005_c_()) : (cause.equals("drown") ? (aiAttacker != null && aiAttacker.func_70089_S() ? " drowned whilst trying to escape " + aiAttacker.func_70005_c_() : " drowned") : (cause.equals("explosion") ? " blew up" : (cause.equals("explosion.player") ? " was blown up by " + attacker.func_70005_c_() : (cause.equals("fall") ? (aiAttacker != null && aiAttacker.func_70089_S() ? " was doomed to fall by " + aiAttacker.func_70005_c_() : " fell from a high place") : (cause.equals("inFire") ? ((lastTarget = this.func_110144_aD()) != null && lastTarget.func_70089_S() ? " walked into a fire whilst fighting " + lastTarget.func_70005_c_() : (aiAttacker != null && aiAttacker.func_70089_S() ? " walked into a fire whilst trying to escape " + aiAttacker.func_70005_c_() : " went up in flames")) : (cause.equals("onFire") ? ((lastTarget = this.func_110144_aD()) != null && lastTarget.func_70089_S() ? " was burnt to a crisp whilst fighting " + lastTarget.func_70005_c_() : (aiAttacker != null && aiAttacker.func_70089_S() ? " was burnt to a crisp whilst trying to escape " + aiAttacker.func_70005_c_() : " burned to death")) : (cause.equals("mob") ? " was slain by a " + attacker.func_70005_c_() : (cause.equals("player") ? " was slain by " + attacker.func_70005_c_() : (cause.equals("fireball") ? " was fireballed by a " + attacker.func_70005_c_() : (cause.equals("indirectMagic") ? " was killed by " + attacker.func_70005_c_() + " using magic" : (cause.equals("magic") ? " was killed by magic" : (cause.equals("inWall") ? " suffocated in a wall" : (cause.equals("lava") ? (aiAttacker != null && aiAttacker.func_70089_S() ? " tried to swim in lava while trying to escape " + aiAttacker.func_70005_c_() : " tried to swim in lava") : (cause.equals("outOfWorld") ? (aiAttacker != null && aiAttacker.func_70089_S() ? " was knocked into the void by " + aiAttacker.func_70005_c_() : " fell out of the world") : (cause.equals("wither") ? " withered away" : (cause.equals("fallingBlock") ? " was squashed by a falling block" : " died"))))))))))))))))));
            String message = name + cause;
            HelpfulVillagers.network.sendToAll((IMessage)new PlayerMessagePacket(message));
        }
    }

    public abstract boolean shouldReturn();

    public abstract ArrayList getValidCoords();

    public int getAttackDamage() {
        return 0;
    }
}

