/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.util;

import java.util.ArrayList;
import java.util.Random;
import mods.helpfulvillagers.entity.AbstractVillager;
import mods.helpfulvillagers.village.HelpfulVillage;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;

public class AIHelper {
    public static ChunkCoordinates getRandOutsideCoords(AbstractVillager villager, int limit) {
        Random gen = new Random();
        HelpfulVillage village = villager.homeVillage;
        if (villager.lastResource != null) {
            System.out.println("Using Resource Center");
            ChunkCoordinates center = villager.lastResource.coords;
            int x = center.field_71574_a;
            int y = center.field_71572_b;
            int z = center.field_71573_c;
            int newX = gen.nextBoolean() ? x + gen.nextInt(limit / 2) : x - gen.nextInt(limit / 2);
            int newZ = gen.nextBoolean() ? z + gen.nextInt(limit / 2) : z - gen.nextInt(limit / 2);
            return new ChunkCoordinates(newX, y, newZ);
        }
        if (village != null) {
            int newZ;
            int newX;
            System.out.println("Using Village Center");
            ChunkCoordinates center = village.getCenter();
            int x = center.field_71574_a;
            int y = center.field_71572_b;
            int z = center.field_71573_c;
            if (gen.nextBoolean()) {
                newX = x - village.getVillageRadius();
                newX -= gen.nextInt(limit);
            } else {
                newX = x + village.getVillageRadius();
                newX += gen.nextInt(limit);
            }
            if (gen.nextBoolean()) {
                newZ = z - village.getVillageRadius();
                newZ -= gen.nextInt(limit);
            } else {
                newZ = z + village.getVillageRadius();
                newZ += gen.nextInt(limit);
            }
            return new ChunkCoordinates(newX, y, newZ);
        }
        return null;
    }

    public static ChunkCoordinates getRandInsideCoords(AbstractVillager villager) {
        Random gen = new Random();
        HelpfulVillage village = villager.homeVillage;
        if (village != null) {
            int LIMIT = village.getVillageRadius();
            ChunkCoordinates center = village.getCenter();
            int x = center.field_71574_a;
            int y = center.field_71572_b;
            int z = center.field_71573_c;
            int newX = x;
            int newZ = z;
            newX = gen.nextBoolean() ? (newX -= gen.nextInt(LIMIT)) : (newX += gen.nextInt(LIMIT));
            newZ = gen.nextBoolean() ? (newZ -= gen.nextInt(LIMIT)) : (newZ += gen.nextInt(LIMIT));
            return new ChunkCoordinates(newX, y, newZ);
        }
        return null;
    }

    public static int findDistance(int par1, int par2) {
        int temp1 = Math.abs(par1);
        int temp2 = Math.abs(par2);
        int temp3 = temp1 - temp2;
        return Math.abs(temp3);
    }

    public static int chestContains(TileEntityChest chest, ItemStack item) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack chestItem = chest.func_70301_a(i);
            if (chestItem == null || !chestItem.func_82833_r().equals(item.func_82833_r())) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList getAdjacentCoords(ChunkCoordinates coords) {
        ArrayList<ChunkCoordinates> adjacent = new ArrayList<ChunkCoordinates>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    ChunkCoordinates coord = new ChunkCoordinates(coords.field_71574_a + x, coords.field_71572_b + y, coords.field_71573_c + z);
                    adjacent.add(coord);
                }
            }
        }
        return adjacent;
    }

    public static void breakBlock(ChunkCoordinates currentCoords, AbstractVillager villager) {
        Block currentBlock = villager.field_70170_p.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
        if (!(currentBlock.equals(Blocks.field_150350_a) || currentBlock.equals(Blocks.field_150355_j) || currentBlock.equals(Blocks.field_150353_l) || currentBlock.equals(Blocks.field_150357_h) || currentBlock.equals(Blocks.field_150329_H))) {
            int metadata = villager.field_70170_p.func_72805_g(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
            ArrayList items = currentBlock.getDrops(villager.field_70170_p, currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, metadata, 0);
            for (ItemStack i : items) {
                try {
                    villager.inventory.addItem(i);
                    villager.damageItem();
                }
                catch (NullPointerException e) {}
            }
        }
        villager.field_70170_p.func_147468_f(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
    }
}

