/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.crystalwing;

import bspkrs.crystalwing.ConfigElement;
import bspkrs.crystalwing.ItemCrystalWing;
import bspkrs.crystalwing.ItemCrystalWingBurned;
import bspkrs.crystalwing.ItemCrystalWingBurning;
import bspkrs.crystalwing.ItemEnderScepter;
import bspkrs.crystalwing.fml.Reference;
import bspkrs.util.CommonUtils;
import bspkrs.util.config.Configuration;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ChestGenHooks;

public final class CWSettings {
    private static final boolean allowDebugLoggingDefault = false;
    public static boolean allowDebugLogging = false;
    private static final int usesDefault = 8;
    public static int uses = 8;
    private static final int teleDistanceDefault = 500;
    public static int teleDistance = 500;
    public static Item crystalWing;
    public static Item crystalWingBurning;
    public static Item crystalWingBurned;
    public static Item enderScepter;
    public static Achievement burnedWing;

    public static void initConfig(File file) {
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        Reference.config = new Configuration(file);
        CWSettings.syncConfig();
    }

    public static void syncConfig() {
        String ctgyGen = "general";
        Reference.config.load();
        Reference.config.setCategoryComment(ctgyGen, "ATTENTION: Editing this file manually is no longer necessary. \nOn the Mods list screen select the entry for CrystalWing, then click the Config button to modify these settings.");
        allowDebugLogging = Reference.config.getBoolean(ConfigElement.ALLOW_DEBUG_LOGGING.key(), ctgyGen, false, ConfigElement.ALLOW_DEBUG_LOGGING.desc(), ConfigElement.ALLOW_DEBUG_LOGGING.languageKey());
        uses = Reference.config.getInt(ConfigElement.USES.key(), ctgyGen, 8, 0, 5280, ConfigElement.USES.desc(), ConfigElement.USES.languageKey());
        teleDistance = Reference.config.getInt(ConfigElement.TELE_DISTANCE.key(), ctgyGen, 500, 100, 50000, ConfigElement.TELE_DISTANCE.desc(), ConfigElement.TELE_DISTANCE.languageKey());
        Reference.config.save();
    }

    public static void registerStuff() {
        crystalWing = new ItemCrystalWing().func_77655_b("crystalwing.crystalWing");
        crystalWingBurning = new ItemCrystalWingBurning().func_77655_b("crystalwing.crystalWingBurning");
        crystalWingBurned = new ItemCrystalWingBurned(teleDistance).func_77655_b("crystalwing.crystalWingBurned");
        enderScepter = new ItemEnderScepter().func_77655_b("crystalwing.enderScepter");
        GameRegistry.registerItem((Item)crystalWing, (String)"crystalwing.crystalWing", (String)"CrystalWing");
        GameRegistry.registerItem((Item)crystalWingBurning, (String)"crystalwing.crystalWingBurning", (String)"CrystalWing");
        GameRegistry.registerItem((Item)crystalWingBurned, (String)"crystalwing.crystalWingBurned", (String)"CrystalWing");
        GameRegistry.registerItem((Item)enderScepter, (String)"crystalwing.enderScepter", (String)"CrystalWing");
        GameRegistry.addRecipe((ItemStack)new ItemStack(crystalWing, 1), (Object[])new Object[]{"GGG", "EFF", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('F'), Items.field_151008_G});
        burnedWing = new Achievement("burnedWing", "burnedWing", 9, -5, crystalWingBurning, null).func_75966_h().func_75971_g();
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWing, 1), 1, 1, 3));
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWingBurned, 1), 1, 1, 2));
        ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWing, 1), 1, 1, 2));
        ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWing, 1), 1, 1, 2));
        ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWing, 1), 1, 1, 2));
        ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWing, 1), 1, 1, 2));
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWing, 1), 1, 1, 3));
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(crystalWingBurned, 1), 1, 1, 2));
    }

    public static ChunkCoordinates verifyRespawnCoordinates(World world, ChunkCoordinates chunkCoords, boolean par2) {
        if (!world.field_72995_K) {
            IChunkProvider ichunkprovider = world.func_72863_F();
            ichunkprovider.func_73158_c(chunkCoords.field_71574_a - 3 >> 4, chunkCoords.field_71573_c - 3 >> 4);
            ichunkprovider.func_73158_c(chunkCoords.field_71574_a + 3 >> 4, chunkCoords.field_71573_c - 3 >> 4);
            ichunkprovider.func_73158_c(chunkCoords.field_71574_a - 3 >> 4, chunkCoords.field_71573_c + 3 >> 4);
            ichunkprovider.func_73158_c(chunkCoords.field_71574_a + 3 >> 4, chunkCoords.field_71573_c + 3 >> 4);
        }
        ChunkCoordinates c = chunkCoords;
        Block block = world.func_147439_a(c.field_71574_a, c.field_71572_b, c.field_71573_c);
        if (block.equals(Blocks.field_150324_C) || block.isBed((IBlockAccess)world, chunkCoords.field_71574_a, chunkCoords.field_71572_b, chunkCoords.field_71573_c, null)) {
            return block.getBedSpawnPosition((IBlockAccess)world, c.field_71574_a, c.field_71572_b, c.field_71573_c, null);
        }
        Material material = world.func_147439_a(chunkCoords.field_71574_a, chunkCoords.field_71572_b, chunkCoords.field_71573_c).func_149688_o();
        Material material1 = world.func_147439_a(chunkCoords.field_71574_a, chunkCoords.field_71572_b + 1, chunkCoords.field_71573_c).func_149688_o();
        boolean flag1 = !material.func_76220_a() && !material.func_76224_d();
        boolean flag2 = !material1.func_76220_a() && !material1.func_76224_d();
        return par2 && flag1 && flag2 ? chunkCoords : null;
    }
}

