/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.event;

import airbreather.mods.airbreathercore.asm.EntityAccessor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.IEventListener;
import java.util.Random;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public abstract class LivingDropsEventHandlerBase
implements IEventListener {
    private final Random rand = new Random();
    private final int minDropsPerEvent;
    private final int maxDropsPerEvent;

    protected LivingDropsEventHandlerBase(int minDropsPerEvent, int maxDropsPerEvent) {
        Preconditions.checkArgument((maxDropsPerEvent >= minDropsPerEvent ? 1 : 0) != 0, (String)"min cannot be greater than max. max: %s, min: %s", (Object[])new Object[]{maxDropsPerEvent, minDropsPerEvent});
        this.minDropsPerEvent = minDropsPerEvent;
        this.maxDropsPerEvent = maxDropsPerEvent;
    }

    public void invoke(Event event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        Preconditions.checkArgument((boolean)(event instanceof LivingDropsEvent), (String)"expected LivingDropsEvent, but got %s.", (Object[])new Object[]{event.getClass()});
        LivingDropsEvent typedEvent = (LivingDropsEvent)event;
        Optional<Item> itemToDrop = this.GetItemToDrop(typedEvent);
        if (!itemToDrop.isPresent()) {
            return;
        }
        EntityAccessor entityAccessor = new EntityAccessor(typedEvent.entity);
        Random rand = (Random)entityAccessor.GetRand().or((Object)this.rand);
        int range = this.maxDropsPerEvent - this.minDropsPerEvent + 1;
        int dropCount = this.minDropsPerEvent + rand.nextInt(range);
        if (typedEvent.lootingLevel > 0) {
            int perkBonus = rand.nextInt(typedEvent.lootingLevel + 1);
            dropCount += perkBonus;
        }
        for (int i = 0; i < dropCount; ++i) {
            EntityItem droppedItem = typedEvent.entity.func_145779_a((Item)itemToDrop.get(), 1);
        }
    }

    protected abstract Optional<Item> GetItemToDrop(LivingDropsEvent var1);
}

