/*
 * Decompiled with CFR 0.152.
 */
package panicnot42.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import panicnot42.util.AbstractPacket;
import panicnot42.util.INBTSerializable;
import panicnot42.util.NBTUtils;
import panicnot42.util.PacketPipeline;
import panicnot42.util.UpdateTableEvent;
import panicnot42.util.UpdateTableListener;

public class SyncableTable<T extends INBTSerializable>
implements INBTSerializable {
    private PacketPipeline pipeline;
    private HashMap<String, T> table;
    private Class<T> clazz;
    private boolean dirty = false;
    private EventListenerList updateTableListeners = new EventListenerList();
    private String rootTagName;

    public SyncableTable(PacketPipeline pipeline, Class<T> clazz, String rootTagName) {
        this.pipeline = pipeline;
        this.clazz = clazz;
        this.table = new HashMap();
        this.rootTagName = rootTagName;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void set(String key, T value) {
        this.table.put(key, value);
        this.markDirty();
    }

    public T get(String key) {
        return (T)((INBTSerializable)this.table.get(key));
    }

    public T remove(String waypoint) {
        return (T)((INBTSerializable)this.table.remove(waypoint));
    }

    public void addUpdateTableListener(UpdateTableListener listener) {
        this.updateTableListeners.add(UpdateTableListener.class, listener);
    }

    public void removeUpdateTableListener(UpdateTableListener listener) {
        this.updateTableListeners.remove(UpdateTableListener.class, listener);
    }

    protected void fireUpdate(UpdateTableEvent updateTableEvent) {
        for (UpdateTableListener listener : (UpdateTableListener[])this.updateTableListeners.getListeners(UpdateTableListener.class)) {
            listener.tableUpdated(updateTableEvent);
        }
    }

    @Mod.EventHandler
    public void registerHandlers(FMLPostInitializationEvent event) {
        this.pipeline.registerPacket(TablePacket.class);
    }

    @SubscribeEvent
    public void tick(TickEvent e) {
        if (this.dirty) {
            this.clean();
        }
    }

    @SubscribeEvent
    public void clientJoined(FMLNetworkEvent.ServerConnectionFromClientEvent e) {
        this.pipeline.sendTo(new TablePacket(this.table), ((NetHandlerPlayServer)e.handler).field_147369_b);
    }

    private void markDirty() {
        this.dirty = true;
    }

    private void clean() {
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                this.pipeline.sendToServer(new TablePacket(this.table));
                break;
            }
            case SERVER: {
                this.pipeline.sendToAll(new TablePacket(this.table));
                break;
            }
        }
        this.dirty = false;
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        NBTUtils.readHashMapFromNBT(var1.func_150295_c(this.rootTagName, (int)new NBTTagCompound().func_74732_a()), this.clazz);
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        NBTUtils.writeHashMapToNBT(var1.func_150295_c(this.rootTagName, (int)new NBTTagCompound().func_74732_a()), this.table);
    }

    public boolean contains(String name) {
        return this.table.keySet().contains(name);
    }

    public String[] keyList() {
        String[] keySet = new String[this.table.size()];
        this.table.keySet().toArray(keySet);
        return keySet;
    }

    private class TablePacket
    extends AbstractPacket {
        private HashMap<String, T> payload;

        private TablePacket(HashMap<String, T> payload) {
            this.payload = payload;
        }

        @Override
        public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry e : this.payload.entrySet()) {
                NBTTagCompound entry = new NBTTagCompound();
                ((INBTSerializable)e.getValue()).writeToNBT(entry);
                tag.func_74782_a(e.getKey(), (NBTBase)entry);
            }
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
        }

        @Override
        public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buffer);
            for (String e : tag.func_150296_c()) {
                INBTSerializable obj;
                NBTTagCompound entry = tag.func_74775_l(e);
                try {
                    obj = (INBTSerializable)SyncableTable.this.clazz.newInstance();
                }
                catch (InstantiationException e1) {
                    throw new RuntimeException(e1);
                }
                catch (IllegalAccessException e1) {
                    throw new RuntimeException(e1);
                }
                obj.readFromNBT(entry);
                this.payload.put(e, obj);
            }
        }

        @Override
        public void handleClientSide(EntityPlayer player) {
            this.copyParent();
        }

        @Override
        public void handleServerSide(EntityPlayer player) {
            this.copyParent();
        }

        private void copyParent() {
            SyncableTable.this.table = new HashMap(this.payload);
            SyncableTable.this.dirty = false;
        }
    }
}

