/*
 * Decompiled with CFR 0.152.
 */
package panicnot42.warpbook;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumDifficulty;
import panicnot42.util.CommandUtils;
import panicnot42.warpbook.WarpBookMod;
import panicnot42.warpbook.WarpWorldStorage;
import panicnot42.warpbook.util.Waypoint;

public class Proxy {
    public void registerRenderers() {
    }

    public void handleWarp(EntityPlayer player, ItemStack page) {
        Waypoint wp = this.extractWaypoint(player, page);
        if (wp == null) {
            CommandUtils.showError((ICommandSender)player, "This waypoint no longer exists");
            return;
        }
        boolean crossDim = player.field_71093_bK != wp.dim;
        player.func_71020_j(Proxy.calculateExhaustion(player.func_130014_f_().field_73013_u, WarpBookMod.exhaustionCoefficient, crossDim));
        if (crossDim) {
            player.func_71027_c(wp.dim);
        }
        player.func_70634_a((double)((float)wp.x + 0.5f), (double)((float)wp.y + 0.5f), (double)((float)wp.z + 0.5f));
    }

    protected Waypoint extractWaypoint(EntityPlayer player, ItemStack page) {
        NBTTagCompound pageTagCompound = page.func_77978_p();
        WarpWorldStorage storage = WarpWorldStorage.instance(player.func_130014_f_());
        Waypoint wp = pageTagCompound.func_74764_b("hypername") ? storage.getWaypoint(pageTagCompound.func_74779_i("hypername")) : new Waypoint("", "", pageTagCompound.func_74762_e("posX"), pageTagCompound.func_74762_e("posY"), pageTagCompound.func_74762_e("posZ"), pageTagCompound.func_74762_e("dim"));
        return wp;
    }

    private static float calculateExhaustion(EnumDifficulty difficultySetting, float exhaustionCoefficient, boolean crossDim) {
        float scaleFactor = 0.0f;
        switch (difficultySetting) {
            case EASY: {
                scaleFactor = 1.0f;
                break;
            }
            case NORMAL: {
                scaleFactor = 1.5f;
                break;
            }
            case HARD: {
                scaleFactor = 2.0f;
                break;
            }
            case PEACEFUL: {
                scaleFactor = 0.0f;
            }
        }
        return exhaustionCoefficient * scaleFactor * (crossDim ? 2.0f : 1.0f);
    }
}

