/*
 * Decompiled with CFR 0.152.
 */
package panicnot42.warpbook;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import panicnot42.util.PacketPipeline;
import panicnot42.warpbook.Proxy;
import panicnot42.warpbook.WarpWorldStorage;
import panicnot42.warpbook.commands.CreateWaypointCommand;
import panicnot42.warpbook.commands.DeleteWaypointCommand;
import panicnot42.warpbook.commands.GiveWarpCommand;
import panicnot42.warpbook.commands.ListWaypointCommand;
import panicnot42.warpbook.crafting.WarpPageShapeless;
import panicnot42.warpbook.gui.GuiManager;
import panicnot42.warpbook.item.WarpBookItem;
import panicnot42.warpbook.item.WarpPageItem;
import panicnot42.warpbook.net.packet.PacketWarp;
import panicnot42.warpbook.net.packet.PacketWaypointName;

@Mod(modid="warpbook", name="Warp Book", version="1.0.34")
public class WarpBookMod {
    @Mod.Instance(value="warpbook")
    public static WarpBookMod instance;
    public static final Logger logger;
    public static final PacketPipeline packetPipeline;
    public static WarpBookItem warpBookItem;
    public static WarpPageItem warpPageItem;
    @SidedProxy(clientSide="panicnot42.warpbook.client.ClientProxy", serverSide="panicnot42.warpbook.Proxy")
    public static Proxy proxy;
    private static int guiIndex;
    public static float exhaustionCoefficient;
    public static final int WarpBookWarpGuiIndex;
    public static final int WarpBookWaypointGuiIndex;
    public static final int WarpBookInventoryGuiIndex;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        exhaustionCoefficient = (float)config.get("tweaks", "exhaustion coefficient", 20.0).getDouble(20.0);
        warpBookItem = new WarpBookItem();
        warpPageItem = new WarpPageItem();
        GameRegistry.registerItem((Item)warpBookItem, (String)"warpbook");
        GameRegistry.registerItem((Item)warpPageItem, (String)"warppage");
        if (config.get("tweaks", "hard recipes", false).getBoolean(false)) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)warpBookItem), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151156_bN)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)warpPageItem), (Object[])new Object[]{new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151061_bv)});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)warpBookItem), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151079_bi)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)warpPageItem), (Object[])new Object[]{new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151079_bi)});
        }
        ItemStack boundpage = new ItemStack((Item)warpPageItem);
        boundpage.func_77964_b(1);
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        recipe.add(boundpage);
        recipe.add(new ItemStack((Item)warpPageItem));
        GameRegistry.addRecipe((IRecipe)new WarpPageShapeless(boundpage, recipe));
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiManager());
        packetPipeline.initalise();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        WarpWorldStorage.postInit();
        packetPipeline.registerPacket(PacketWarp.class);
        packetPipeline.registerPacket(PacketWaypointName.class);
        packetPipeline.postInitialise();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ServerCommandManager manager = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        manager.func_71560_a((ICommand)new CreateWaypointCommand());
        manager.func_71560_a((ICommand)new ListWaypointCommand());
        manager.func_71560_a((ICommand)new DeleteWaypointCommand());
        manager.func_71560_a((ICommand)new GiveWarpCommand());
    }

    static {
        logger = LogManager.getLogger((String)"warpbook");
        packetPipeline = new PacketPipeline(logger, "warpbook");
        guiIndex = 42;
        WarpBookWarpGuiIndex = guiIndex++;
        WarpBookWaypointGuiIndex = guiIndex++;
        WarpBookInventoryGuiIndex = guiIndex++;
    }
}

