/*
 * Decompiled with CFR 0.152.
 */
package panicnot42.warpbook;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import panicnot42.util.SyncableTable;
import panicnot42.util.UpdateTableEvent;
import panicnot42.util.UpdateTableListener;
import panicnot42.warpbook.WarpBookMod;
import panicnot42.warpbook.util.Waypoint;

public class WarpWorldStorage
extends WorldSavedData
implements UpdateTableListener {
    private static SyncableTable<Waypoint> table;
    private static final String IDENTIFIER = "WarpBook";

    public WarpWorldStorage(String identifier) {
        super(identifier);
    }

    public static WarpWorldStorage instance(World world) {
        if (world.field_72988_C.func_75742_a(WarpWorldStorage.class, IDENTIFIER) == null) {
            world.field_72988_C.func_75745_a(IDENTIFIER, (WorldSavedData)new WarpWorldStorage(IDENTIFIER));
        }
        return (WarpWorldStorage)world.field_72988_C.func_75742_a(WarpWorldStorage.class, IDENTIFIER);
    }

    public static void postInit() {
        table = new SyncableTable<Waypoint>(WarpBookMod.packetPipeline, Waypoint.class, "waypointTable");
    }

    public void func_76184_a(NBTTagCompound var1) {
        table.readFromNBT(var1);
    }

    public void func_76187_b(NBTTagCompound var1) {
        table.writeToNBT(var1);
    }

    public boolean waypointExists(String name) {
        return table.contains(name);
    }

    public Waypoint getWaypoint(String name) {
        return table.get(name);
    }

    public void addWaypoint(Waypoint point) {
        table.set(point.name, point);
        this.func_76185_a();
    }

    public String[] listWaypoints() {
        return table.keyList();
    }

    public boolean deleteWaypoint(String waypoint) {
        this.func_76185_a();
        return table.remove(waypoint) != null;
    }

    @Override
    public void tableUpdated(UpdateTableEvent updateTableEvent) {
    }
}

