/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers.Tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.EnchantmentInfo;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleEnchants;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotRepair;

public abstract class ModuleTool
extends ModuleWorker {
    private int currentDurability;
    private int remainingRepairUnits;
    private int maximumRepairUnits = 1;
    protected ModuleEnchants enchanter;
    private int[] durabilityRect = new int[]{10, 15, 52, 8};

    public ModuleTool(MinecartModular cart) {
        super(cart);
        this.currentDurability = this.getMaxDurability();
    }

    public abstract int getMaxDurability();

    public abstract String getRepairItemName();

    public abstract int getRepairItemUnits(ItemStack var1);

    public abstract int getRepairSpeed();

    public abstract boolean useDurability();

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleEnchants)) continue;
            this.enchanter = (ModuleEnchants)module;
            this.enchanter.addType(EnchantmentInfo.ENCHANTMENT_TYPE.TOOL);
            break;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/tool.png");
        this.drawBox(gui, 0, 0, 1.0f);
        this.drawBox(gui, 0, 8, this.useDurability() ? (float)this.currentDurability / (float)this.getMaxDurability() : 1.0f);
        this.drawBox(gui, 0, 16, (float)this.remainingRepairUnits / (float)this.maximumRepairUnits);
        if (this.inRect(x, y, this.durabilityRect)) {
            this.drawBox(gui, 0, 24, 1.0f);
        }
    }

    private void drawBox(GuiMinecart gui, int u, int v, float mult) {
        int w = (int)((float)this.durabilityRect[2] * mult);
        if (w > 0) {
            this.drawImage(gui, this.durabilityRect[0], this.durabilityRect[1], u, v, w, this.durabilityRect[3]);
        }
    }

    public boolean isValidRepairMaterial(ItemStack item) {
        return this.getRepairItemUnits(item) > 0;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotRepair(this, this.getCart(), slotId, 76, 8);
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 50;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        String str;
        if (this.useDurability()) {
            str = Localization.MODULES.TOOLS.DURABILITY.translate(new String[0]) + ": " + this.currentDurability + "/" + this.getMaxDurability();
            str = this.isBroken() ? str + " [" + Localization.MODULES.TOOLS.BROKEN.translate(new String[0]) + "]" : str + " [" + 100 * this.currentDurability / this.getMaxDurability() + "%]";
            str = str + "\n";
            str = this.isRepairing() ? (this.isActuallyRepairing() ? str + " [" + this.getRepairPercentage() + "%]" : str + Localization.MODULES.TOOLS.DECENT.translate(new String[0])) : str + Localization.MODULES.TOOLS.INSTRUCTION.translate(this.getRepairItemName());
        } else {
            str = Localization.MODULES.TOOLS.UNBREAKABLE.translate(new String[0]);
            if (this.isRepairing() && !this.isActuallyRepairing()) {
                str = str + " " + Localization.MODULES.TOOLS.UNBREAKABLE_REPAIR.translate(new String[0]);
            }
        }
        this.drawStringOnMouseOver(gui, str, x, y, this.durabilityRect);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K && this.useDurability()) {
            int units;
            if (this.isActuallyRepairing()) {
                int dif = 1;
                this.remainingRepairUnits -= dif;
                this.currentDurability += dif * this.getRepairSpeed();
                if (this.currentDurability > this.getMaxDurability()) {
                    this.currentDurability = this.getMaxDurability();
                }
            }
            if (!this.isActuallyRepairing() && (units = this.getRepairItemUnits(this.getStack(0))) > 0 && units <= this.getMaxDurability() - this.currentDurability) {
                this.maximumRepairUnits = this.remainingRepairUnits = units / this.getRepairSpeed();
                --this.getStack((int)0).field_77994_a;
                if (this.getStack((int)0).field_77994_a <= 0) {
                    this.setStack(0, null);
                }
            }
        }
    }

    @Override
    public boolean stopEngines() {
        return this.isRepairing();
    }

    public boolean isRepairing() {
        return this.getStack(0) != null || this.isActuallyRepairing();
    }

    public boolean isActuallyRepairing() {
        return this.remainingRepairUnits > 0;
    }

    public boolean isBroken() {
        return this.currentDurability == 0 && this.useDurability();
    }

    public void damageTool(int val) {
        int unbreaking;
        int n = unbreaking = this.enchanter != null ? this.enchanter.getUnbreakingLevel() : 0;
        if (this.getCart().field_70146_Z.nextInt(100) < 100 / (unbreaking + 1)) {
            this.currentDurability -= val;
            if (this.currentDurability < 0) {
                this.currentDurability = 0;
            }
        }
        if (this.enchanter != null) {
            this.enchanter.damageEnchant(EnchantmentInfo.ENCHANTMENT_TYPE.TOOL, val);
        }
    }

    @Override
    public int numberOfGuiData() {
        return 4;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)(this.currentDurability & 0xFFFF));
        this.updateGuiData(info, 1, (short)(this.currentDurability >> 16 & 0xFFFF));
        this.updateGuiData(info, 2, (short)this.remainingRepairUnits);
        this.updateGuiData(info, 3, (short)this.maximumRepairUnits);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        int dataint = data;
        if (dataint < 0) {
            dataint += 65536;
        }
        if (id == 0) {
            this.currentDurability = this.currentDurability & 0xFFFF0000 | dataint;
        } else if (id == 1) {
            this.currentDurability = this.currentDurability & 0xFFFF | dataint << 16;
        } else if (id == 2) {
            this.remainingRepairUnits = data;
        } else if (id == 3) {
            this.maximumRepairUnits = data;
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74768_a(this.generateNBTName("Durability", id), this.currentDurability);
        tagCompound.func_74777_a(this.generateNBTName("Repair", id), (short)this.remainingRepairUnits);
        tagCompound.func_74777_a(this.generateNBTName("MaxRepair", id), (short)this.maximumRepairUnits);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.currentDurability = tagCompound.func_74762_e(this.generateNBTName("Durability", id));
        this.remainingRepairUnits = tagCompound.func_74765_d(this.generateNBTName("Repair", id));
        this.maximumRepairUnits = tagCompound.func_74765_d(this.generateNBTName("MaxRepair", id));
    }

    @Override
    public boolean hasExtraData() {
        return true;
    }

    @Override
    public byte getExtraData() {
        return (byte)(100 * this.currentDurability / this.getMaxDurability());
    }

    @Override
    public void setExtraData(byte b) {
        this.currentDurability = b * this.getMaxDurability() / 100;
    }

    public boolean shouldSilkTouch(Block b, int x, int y, int z, int m) {
        boolean doSilkTouch = false;
        try {
            if (this.enchanter != null && this.enchanter.useSilkTouch() && b.canSilkHarvest(this.getCart().field_70170_p, null, x, y, z, m)) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public ItemStack getSilkTouchedItem(Block b, int m) {
        int droppedMeta = 0;
        ItemStack stack = new ItemStack(b, 1, droppedMeta);
        if (stack.func_77973_b() != null && stack.func_77973_b().func_77614_k()) {
            return new ItemStack(b, 1, m);
        }
        return stack;
    }

    public int getCurrentDurability() {
        return this.currentDurability;
    }

    public int getRepairPercentage() {
        return 100 - 100 * this.remainingRepairUnits / this.maximumRepairUnits;
    }
}

