/*
 * Decompiled with CFR 0.152.
 */
package RCM.Entities;

import RCM.Audio.MovingSoundOctocopterHigh;
import RCM.Audio.MovingSoundOctocopterLow;
import RCM.Entities.GlobalEntity;
import RCM.KeyHandler;
import RCM.Packets.MessageEntityRCOctocopter;
import RCM.Packets.MessageHandler;
import RCM.RCM_Main;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityRCOctocopter
extends GlobalEntity {
    private float propRadius;
    private float surfaceArea;
    private float dragCoeff;
    private float propArea;
    private float maxMotorSpeed;
    private float prevHoverSence;
    public float[] motorSpeeds;
    public float[] netMotorSpeeds;
    public float[] indivThrottle;
    public float[] prevMotorSpeeds;
    private float[] motorTargetSpeeds;
    private float propellerPitch;

    public EntityRCOctocopter(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityRCOctocopter(World par1World, double par2, double par4, double par6) {
        this(par1World);
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70169_q = par2;
        this.field_70167_r = par4 + (double)this.field_70129_M;
        this.field_70166_s = par6;
    }

    @Override
    public String filePath() {
        return "RCOctocopterProperties.cfg";
    }

    public boolean func_70112_a(double par1) {
        double d = this.field_70121_D.func_72320_b() * 4.0;
        return par1 < (d *= 64.0) * d;
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        Entity entity = damageSource.func_76346_g();
        if (!(this.field_70170_p.field_72995_K || this.field_70128_L || this.activated && this.holdingremotecontrol(this.thePlayer) && (this.thePlayer == null || entity == null || entity.func_110124_au() == this.thePlayer.func_110124_au()) && entity != null)) {
            this.func_145778_a(RCM_Main.rcoctocopter, 1, 0.0f);
            this.func_70106_y();
            this.activated = false;
            return true;
        }
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.propRadius = 0.2285f;
        this.propArea = this.propRadius * 0.02f;
        this.maxMotorSpeed = 942.47784f;
        this.propellerPitch = 0.08726647f;
        this.dragCoeff = 0.3f;
        this.surfaceArea = 0.6371f;
        try {
            this.helper.loadForce(this.filePath());
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Octocopter properties file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Octocopter properties file loaded incorrectly!!", (Object[])new Object[0]);
        }
        for (int i = 0; i < this.helper.getTorqueQuant(); ++i) {
            this.helper.addForce(new Vector3f(0.0f, 1.0f, 0.0f));
        }
        this.motorSpeeds = new float[this.helper.getTorqueQuant()];
        this.prevMotorSpeeds = new float[this.helper.getTorqueQuant()];
        this.motorTargetSpeeds = new float[this.helper.getTorqueQuant()];
        this.netMotorSpeeds = new float[this.helper.getTorqueQuant()];
        this.indivThrottle = new float[this.helper.getTorqueQuant()];
    }

    @Override
    public void calculatePhysics() {
        float variableThurst = 0.0f;
        float motorRef = 0.0f;
        float variableTorque = 0.0f;
        if (!this.activated || !this.holdingremotecontrol(this.thePlayer) || this.damaged) {
            this.throttle = 0.0f;
        }
        float hoverSence = this.physicsWorld.entityBody.getLinearVelocity((Vector3f)new Vector3f()).y;
        if (this.activated && this.throttle > 0.0f && KeyHandler.forwardMovement == 0 && (hoverSence > 0.0f && hoverSence - this.prevHoverSence > -0.01f || hoverSence < 0.0f && hoverSence - this.prevHoverSence < 0.01f)) {
            this.throttle = (float)((double)this.throttle - 0.5 * (double)hoverSence);
        }
        this.prevHoverSence = hoverSence;
        if (this.activated && this.holdingremotecontrol(this.thePlayer) && !this.damaged) {
            if (KeyHandler.pitchMovement != 0 && KeyHandler.rollMovement != 0) {
                variableThurst = 0.2f;
                motorRef = ((float)(-KeyHandler.pitchMovement) * 180.0f - 45.0f * (float)KeyHandler.rollMovement) / 180.0f * (float)Math.PI;
                if (KeyHandler.pitchMovement == 1) {
                    motorRef = 45.0f * (float)KeyHandler.rollMovement / 180.0f * (float)Math.PI;
                }
            } else if (KeyHandler.pitchMovement != 0) {
                variableThurst = 0.2f;
                if (KeyHandler.pitchMovement == -1) {
                    motorRef = (float)Math.PI;
                }
            } else if (KeyHandler.rollMovement != 0) {
                variableThurst = 0.2f;
                motorRef = 0.5f * (float)KeyHandler.rollMovement * (float)Math.PI;
            }
            if (KeyHandler.turnMovement != 0) {
                variableTorque = 0.15f * (float)(-KeyHandler.turnMovement);
            }
            this.throttle += (float)KeyHandler.forwardMovement;
            if (this.throttle > 100.0f) {
                this.throttle = 100.0f;
            } else if (this.throttle < 0.0f) {
                this.throttle = 0.0f;
            }
        }
        Quat4f localQuat = new Quat4f();
        Vector3f linearVel = new Vector3f();
        Vector3f rotationalVel = new Vector3f();
        localQuat = this.physicsWorld.entityBody.getOrientation(new Quat4f());
        linearVel = this.physicsWorld.entityBody.getLinearVelocity(new Vector3f());
        rotationalVel = this.physicsWorld.entityBody.getAngularVelocity(new Vector3f());
        for (int i = 0; i < this.helper.getTorqueQuant(); ++i) {
            float indivThrottle = this.throttle * (1.0f + variableThurst * (float)Math.cos(motorRef));
            if ((indivThrottle *= 1.0f + variableTorque * (float)this.helper.getTorqueDirection(i)) > 100.0f) {
                indivThrottle = 100.0f;
            } else if (indivThrottle < 0.0f) {
                indivThrottle = 0.0f;
            }
            float targetSpeed = this.maxMotorSpeed * (indivThrottle / 100.0f) * (float)this.helper.getTorqueDirection(i) / 2.0f;
            if (this.motorTargetSpeeds[i] > targetSpeed) {
                int n = i;
                this.motorTargetSpeeds[n] = this.motorTargetSpeeds[n] - 3.0f;
            } else if (this.motorTargetSpeeds[i] < targetSpeed) {
                int n = i;
                this.motorTargetSpeeds[n] = this.motorTargetSpeeds[n] + 3.0f;
            }
            if (this.damaged) {
                this.motorTargetSpeeds[i] = 0.0f;
            }
            float rpm = Math.abs(this.motorTargetSpeeds[i]) * 200.0f / this.maxMotorSpeed;
            this.indivThrottle[i] = Math.max(0.0f, rpm);
            this.prevMotorSpeeds[i] = this.motorSpeeds[i];
            int n = i;
            this.motorSpeeds[n] = this.motorSpeeds[n] + this.motorTargetSpeeds[i];
            this.helper.setPropAngles(this.propellerPitch * (float)this.helper.getTorqueDirection(i));
            this.helper.setPropFlowDirection(this.helper.getTorqueDirection(i));
            float thrust = 0.0f;
            for (int j = 0; j < 4; ++j) {
                float bladeLiftCoef = 0.0f;
                Vector3f bladeRelativeVeloc = new Vector3f();
                Quat4f bladeQuat = new Quat4f();
                Quat4f localBladeQuat = new Quat4f();
                bladeQuat.set(this.helper.getBladeAngle(j));
                localBladeQuat.mul(localQuat, bladeQuat);
                bladeRelativeVeloc = this.helper.rotateVector(localQuat, this.helper.getPropFlowDirection(j));
                bladeRelativeVeloc.scale(4.0f * this.propRadius / ((float)Math.PI * 3) * this.maxMotorSpeed * (indivThrottle / 100.0f));
                bladeRelativeVeloc.sub((Tuple3f)this.helper.getVelocityAtPoint(i, localQuat, linearVel, rotationalVel));
                bladeLiftCoef = (float)Math.PI * 2 * this.helper.getPropAoA(localBladeQuat, bladeRelativeVeloc);
                thrust += bladeLiftCoef * 0.5f * this.density * bladeRelativeVeloc.lengthSquared() * this.propArea / 2.0f;
            }
            this.helper.setForceMagnitude(i, thrust);
            this.helper.setTorqueMagnitude(i, 15.0f * indivThrottle / 100.0f);
            this.helper.resetPropAngles();
            this.helper.resetPropFlowDirection();
            motorRef += 0.7853982f;
        }
        this.sendAdditionalPacket();
        this.drag = this.helper.getDrag(linearVel, this.dragCoeff, this.density, this.surfaceArea);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSounds() {
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 0));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterLow(this, 0));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 1));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 2));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 3));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 4));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 5));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 6));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundOctocopterHigh(this, 7));
    }

    @Override
    public void sendAdditionalPacket() {
        if (!this.field_70170_p.field_72995_K) {
            MessageHandler.handler.sendToDimension((IMessage)new MessageEntityRCOctocopter(this.func_145782_y(), this.indivThrottle), this.field_70170_p.field_73011_w.field_76574_g);
        } else if (this.field_70170_p.field_72995_K) {
            MessageHandler.handler.sendToServer((IMessage)new MessageEntityRCOctocopter(this.func_145782_y(), this.indivThrottle));
        }
    }

    public void additionalInfoUpdate(float[] netMotorSpeed) {
        this.netMotorSpeeds = netMotorSpeed;
    }

    @Override
    public void updateAdditionalInfo() {
        this.indivThrottle = this.netMotorSpeeds;
        for (int i = 0; i < this.helper.getTorqueQuant(); ++i) {
            float targetSpeed = this.maxMotorSpeed * (this.indivThrottle[i] / 100.0f) * (float)this.helper.getTorqueDirection(i) / 2.0f;
            if (this.motorTargetSpeeds[i] > targetSpeed) {
                int n = i;
                this.motorTargetSpeeds[n] = this.motorTargetSpeeds[n] - 3.0f;
            } else if (this.motorTargetSpeeds[i] < targetSpeed) {
                int n = i;
                this.motorTargetSpeeds[n] = this.motorTargetSpeeds[n] + 3.0f;
            }
            if (this.damaged) {
                this.motorTargetSpeeds[i] = 0.0f;
            }
            this.prevMotorSpeeds[i] = this.motorSpeeds[i];
            int n = i;
            this.motorSpeeds[n] = this.motorSpeeds[n] + this.motorTargetSpeeds[i];
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        super.spawnParticles();
        if (this.throttle > 25.0f) {
            int k;
            int j;
            int i;
            Block block;
            int a = -1;
            while ((block = this.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5 - (double)(++a))), k = MathHelper.func_76128_c((double)this.field_70161_v))) == Blocks.field_150350_a && a != 3) {
            }
            if (block == Blocks.field_150431_aC) {
                --j;
            }
            for (int i1 = 0; i1 < 2; ++i1) {
                double d16 = (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
                double d17 = (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
                if (!this.field_70146_Z.nextBoolean()) continue;
                double d21 = this.field_70165_t + d16;
                double d23 = this.field_70161_v + d17;
                if (block == Blocks.field_150350_a) continue;
                this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(i, j, k), d21, (double)j + 1.125, d23, d16 * 2.0, 0.0, d17 * 2.0);
            }
        }
    }
}

