/*
 * Decompiled with CFR 0.152.
 */
package RCM.Entities;

import RCM.Audio.MovingSoundTrainerPlaneHigh;
import RCM.Audio.MovingSoundTrainerPlaneLow;
import RCM.Entities.GlobalEntity;
import RCM.KeyHandler;
import RCM.Packets.MessageEntityRCPlane;
import RCM.Packets.MessageHandler;
import RCM.RCM_Main;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class EntityRCPlane
extends GlobalEntity {
    private float bladeRadius;
    private float surfaceArea;
    private float dragCoeff;
    private float bladeArea;
    private float propArea;
    public float rudderAngle;
    public float elevatorAngle;
    public float aileronAngle;
    public float prevRudderAngle;
    public float prevElevatorAngle;
    public float prevAileronAngle;
    public float nvelocity;
    private float maxMotorSpeed;
    private float prevHoverSence;
    public float[] motorSpeeds;
    public float[] prevMotorSpeeds;
    private float[] motorTargetSpeeds;
    private float propellerPitch;
    private float maxRudderAngle;
    private float maxElevatorAngle;
    private float maxAileronAngle;
    public float motorRPM;
    public float netMotorRPM;
    private float netRudderAngle;
    private float netElevatorAngle;
    private float netAileronAngle;
    private float netVelocity;

    public EntityRCPlane(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.field_70145_X = true;
    }

    public EntityRCPlane(World world, double par2, double par4, double par6) {
        this(world);
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70169_q = par2;
        this.field_70167_r = par4 + (double)this.field_70129_M;
        this.field_70166_s = par6;
    }

    @Override
    public String filePath() {
        return "RCPlaneProperties.cfg";
    }

    public boolean func_70112_a(double par1) {
        double d = this.field_70121_D.func_72320_b() * 4.0;
        return par1 < (d *= 64.0) * d;
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        Entity entity = damageSource.func_76346_g();
        if (!(this.field_70170_p.field_72995_K || this.field_70128_L || this.activated && this.holdingremotecontrol(this.thePlayer) && (this.thePlayer == null || entity == null || entity.func_110124_au() == this.thePlayer.func_110124_au()) && entity != null)) {
            this.func_145778_a(RCM_Main.rctrainer, 1, 0.0f);
            this.func_70106_y();
            this.activated = false;
            return true;
        }
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.bladeRadius = 0.127f;
        this.bladeArea = this.bladeRadius * 0.02f;
        this.propArea = this.bladeRadius * this.bladeRadius * (float)Math.PI;
        this.maxMotorSpeed = 1256.6371f;
        this.propellerPitch = 0.34906587f;
        this.dragCoeff = 0.35f;
        this.surfaceArea = 0.218f;
        this.maxAileronAngle = 0.25f;
        this.maxElevatorAngle = 0.35f;
        this.maxRudderAngle = 0.5f;
        try {
            this.helper.loadForce(this.filePath());
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer properties file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Trainer properties file loaded incorrectly!!", (Object[])new Object[0]);
        }
        Quat4f localRotate = new Quat4f();
        Quat4f localRotate2 = new Quat4f();
        Vector3f refVect = new Vector3f(0.0f, 1.0f, 0.0f);
        this.helper.addForce(new Vector3f(0.0f, 0.0f, 1.0f));
        this.motorSpeeds = new float[this.helper.getTorqueQuant()];
        this.prevMotorSpeeds = new float[this.helper.getTorqueQuant()];
        this.motorTargetSpeeds = new float[this.helper.getTorqueQuant()];
    }

    @Override
    public void calculatePhysics() {
        this.prevRudderAngle = this.rudderAngle;
        this.prevElevatorAngle = this.elevatorAngle;
        this.prevAileronAngle = this.aileronAngle;
        if (this.activated && this.holdingremotecontrol(this.thePlayer)) {
            if (KeyHandler.turnMovement != 0) {
                this.rudderAngle -= 0.1f * (float)KeyHandler.turnMovement;
                if (this.rudderAngle > this.maxRudderAngle) {
                    this.rudderAngle = this.maxRudderAngle;
                }
                if (this.rudderAngle < -this.maxRudderAngle) {
                    this.rudderAngle = -this.maxRudderAngle;
                }
            } else if (this.rudderAngle > 0.0f) {
                this.rudderAngle -= 0.1f;
                if (this.rudderAngle < 0.1f) {
                    this.rudderAngle = 0.0f;
                }
            } else if (this.rudderAngle < 0.0f) {
                this.rudderAngle += 0.1f;
                if (this.rudderAngle > -0.1f) {
                    this.rudderAngle = 0.0f;
                }
            }
            if (KeyHandler.pitchMovement != 0) {
                this.elevatorAngle -= 0.05f * (float)KeyHandler.pitchMovement;
                if (this.elevatorAngle > this.maxElevatorAngle) {
                    this.elevatorAngle = this.maxElevatorAngle;
                }
                if (this.elevatorAngle < -this.maxElevatorAngle) {
                    this.elevatorAngle = -this.maxElevatorAngle;
                }
            } else if (this.elevatorAngle > 0.0f) {
                this.elevatorAngle = (float)((double)this.elevatorAngle - 0.1);
                if (this.elevatorAngle < 0.1f) {
                    this.elevatorAngle = 0.0f;
                }
            } else if (this.elevatorAngle < 0.0f) {
                this.elevatorAngle = (float)((double)this.elevatorAngle + 0.1);
                if (this.elevatorAngle > -0.1f) {
                    this.elevatorAngle = 0.0f;
                }
            }
            if (KeyHandler.rollMovement != 0) {
                this.aileronAngle += 0.1f * (float)KeyHandler.rollMovement;
                if (this.aileronAngle > this.maxAileronAngle) {
                    this.aileronAngle = this.maxAileronAngle;
                }
                if (this.aileronAngle < -this.maxAileronAngle) {
                    this.aileronAngle = -this.maxAileronAngle;
                }
            } else if (this.aileronAngle > 0.0f) {
                this.aileronAngle -= 0.1f;
                if (this.aileronAngle < 0.1f) {
                    this.aileronAngle = 0.0f;
                }
            } else if (this.aileronAngle < 0.0f) {
                this.aileronAngle += 0.1f;
                if (this.aileronAngle > -0.1f) {
                    this.aileronAngle = 0.0f;
                }
            }
        }
        if (!this.activated || !this.holdingremotecontrol(this.thePlayer) || this.damaged) {
            this.throttle = 0.0f;
        }
        if (this.activated && this.holdingremotecontrol(this.thePlayer) && !this.damaged) {
            this.throttle += (float)KeyHandler.forwardMovement;
            if (this.throttle > 100.0f) {
                this.throttle = 100.0f;
            } else if (this.throttle < 0.0f) {
                this.throttle = 0.0f;
            }
        }
        this.sendAdditionalPacket();
        Quat4f localQuat = new Quat4f();
        Vector3f linearVel = new Vector3f();
        Vector3f rotationalVel = new Vector3f();
        localQuat = this.physicsWorld.entityBody.getOrientation(new Quat4f());
        linearVel = this.physicsWorld.entityBody.getLinearVelocity(new Vector3f());
        rotationalVel = this.physicsWorld.entityBody.getAngularVelocity(new Vector3f());
        this.nvelocity = linearVel.length();
        float gVehicleSteering = this.rudderAngle;
        this.physicsWorld.vehicle.setSteeringValue(gVehicleSteering, 0);
        for (int i = 0; i < this.helper.getTorqueQuant(); ++i) {
            float targetSpeed = this.maxMotorSpeed * (this.throttle / 100.0f) * (float)this.helper.getTorqueDirection(i) / 5.0f;
            if (this.motorTargetSpeeds[i] > targetSpeed) {
                int n = i;
                this.motorTargetSpeeds[n] = this.motorTargetSpeeds[n] - 3.0f;
            } else if (this.motorTargetSpeeds[i] < targetSpeed) {
                int n = i;
                this.motorTargetSpeeds[n] = this.motorTargetSpeeds[n] + 3.0f;
            }
            if (this.damaged) {
                this.motorTargetSpeeds[i] = 0.0f;
            }
            this.prevMotorSpeeds[i] = this.motorSpeeds[i];
            int n = i;
            this.motorSpeeds[n] = this.motorSpeeds[n] + this.motorTargetSpeeds[i];
            float rpm = Math.abs(this.motorTargetSpeeds[i]) * 500.0f / this.maxMotorSpeed;
            this.motorRPM = Math.max(0.0f, rpm);
            this.motorRPM = Math.min(100.0f, rpm);
            this.helper.setPropAngles(this.propellerPitch);
            this.helper.setPropFlowDirection(1.0f);
            float thrust = 0.0f;
            for (int j = 0; j < 4; ++j) {
                float bladeLiftCoef = 0.0f;
                Vector3f bladeRelativeVeloc = new Vector3f();
                Quat4f propPitch = new Quat4f();
                Quat4f propTilt = new Quat4f();
                Quat4f propQuat = new Quat4f();
                Quat4f propFlowQuat = new Quat4f();
                propTilt.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, 1.5707964f));
                propPitch.set(this.helper.getBladeAngle(j));
                propQuat.mul(propTilt, propPitch);
                propQuat.mul(localQuat, propQuat);
                propFlowQuat.mul(localQuat, propTilt);
                bladeRelativeVeloc = this.helper.rotateVector(propFlowQuat, this.helper.getPropFlowDirection(j));
                bladeRelativeVeloc.scale(4.0f * this.bladeRadius / ((float)Math.PI * 3) * this.maxMotorSpeed * (this.throttle / 100.0f));
                bladeRelativeVeloc.sub((Tuple3f)this.helper.getVelocityAtPoint(i, propFlowQuat, linearVel, rotationalVel));
                bladeLiftCoef = (float)Math.PI * 2 * this.helper.getPropAoA(propQuat, bladeRelativeVeloc);
                thrust += bladeLiftCoef * 0.5f * this.density * bladeRelativeVeloc.lengthSquared() * this.bladeArea / 2.0f;
            }
            this.helper.setForceMagnitude(i, thrust);
            this.helper.resetPropAngles();
            this.helper.resetPropFlowDirection();
        }
        Vector3f propWash = new Vector3f(this.helper.getForceDirc(0, localQuat));
        float perpVel = propWash.dot(linearVel);
        float propVel = perpVel * perpVel + this.helper.getForceMagnitude(0) / (0.5f * this.density * this.propArea);
        propVel = Math.max(0.0f, propVel);
        propVel = 0.5f * ((float)Math.sqrt(propVel) - perpVel);
        propWash.scale(propVel * 0.8f);
        propWash.add((Tuple3f)linearVel);
        this.physicsWorld.wings.get(0).update(localQuat, linearVel, rotationalVel, this.density, -0.08f * this.aileronAngle / this.maxAileronAngle);
        this.physicsWorld.wings.get(1).update(localQuat, linearVel, rotationalVel, this.density, -0.08f * this.aileronAngle / this.maxAileronAngle);
        this.physicsWorld.wings.get(2).update(localQuat, propWash, rotationalVel, this.density, -0.3f * this.rudderAngle / this.maxRudderAngle);
        this.physicsWorld.wings.get(3).update(localQuat, propWash, rotationalVel, this.density, 0.15f * this.elevatorAngle / this.maxElevatorAngle);
        this.physicsWorld.wings.get(4).update(localQuat, propWash, rotationalVel, this.density, -0.15f * this.elevatorAngle / this.maxElevatorAngle);
        this.drag = this.helper.getDrag(linearVel, this.dragCoeff, this.density, this.surfaceArea);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSounds() {
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundTrainerPlaneHigh(this));
        RCM_Main.proxy.getSoundHandler().func_147682_a((ISound)new MovingSoundTrainerPlaneLow(this));
    }

    @Override
    public void sendAdditionalPacket() {
        if (!this.field_70170_p.field_72995_K) {
            MessageHandler.handler.sendToDimension((IMessage)new MessageEntityRCPlane(this.func_145782_y(), this.motorRPM, this.rudderAngle, this.elevatorAngle, this.aileronAngle, this.nvelocity), this.field_70170_p.field_73011_w.field_76574_g);
        } else if (this.field_70170_p.field_72995_K) {
            MessageHandler.handler.sendToServer((IMessage)new MessageEntityRCPlane(this.func_145782_y(), this.motorRPM, this.rudderAngle, this.elevatorAngle, this.aileronAngle, this.nvelocity));
        }
    }

    public void additionalInfoUpdate(float netMotorSpeed, float netRudderAngle, float netElevatorAngle, float netAileronAngle, float netVelocity) {
        this.netMotorRPM = netMotorSpeed;
        this.netRudderAngle = netRudderAngle;
        this.netElevatorAngle = netElevatorAngle;
        this.netAileronAngle = netAileronAngle;
        this.netVelocity = netVelocity;
    }

    @Override
    public void updateAdditionalInfo() {
        this.motorRPM = this.netMotorRPM;
        this.prevRudderAngle = this.rudderAngle;
        this.prevElevatorAngle = this.elevatorAngle;
        this.prevAileronAngle = this.aileronAngle;
        this.rudderAngle = this.netRudderAngle;
        this.elevatorAngle = this.netElevatorAngle;
        this.aileronAngle = this.netAileronAngle;
        this.nvelocity = this.netVelocity;
        float targetSpeed = this.maxMotorSpeed * (this.motorRPM / 100.0f) * (float)this.helper.getTorqueDirection(0) / 5.0f;
        if (this.motorTargetSpeeds[0] > targetSpeed) {
            this.motorTargetSpeeds[0] = this.motorTargetSpeeds[0] - 3.0f;
        } else if (this.motorTargetSpeeds[0] < targetSpeed) {
            this.motorTargetSpeeds[0] = this.motorTargetSpeeds[0] + 3.0f;
        }
        if (this.damaged) {
            this.motorTargetSpeeds[0] = 0.0f;
        }
        this.prevMotorSpeeds[0] = this.motorSpeeds[0];
        this.motorSpeeds[0] = this.motorSpeeds[0] + this.motorTargetSpeeds[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        super.spawnParticles();
        if (this.throttle > 25.0f) {
            int k;
            int j;
            int i;
            Block block;
            int a = -1;
            while ((block = this.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5 - (double)(++a))), k = MathHelper.func_76128_c((double)this.field_70161_v))) == Blocks.field_150350_a && a != 1) {
            }
            if (block == Blocks.field_150431_aC) {
                --j;
            }
            int i1 = 0;
            while ((double)i1 < 2.0) {
                double d1 = this.field_70146_Z.nextFloat() * -1.0f - 1.0f;
                double d2 = (double)this.field_70146_Z.nextFloat() * -0.5 + 0.25;
                if (this.field_70146_Z.nextBoolean()) {
                    double d3 = this.field_70165_t + d1 * (double)this.Forward.x + d2 * (double)this.Left.x;
                    double d4 = this.field_70161_v + d1 * (double)this.Forward.z + d2 * (double)this.Left.z;
                    double d5 = d1 * (double)this.Forward.x + d2 * (double)this.Left.x;
                    double d6 = d1 * (double)this.Forward.z + d2 * (double)this.Left.z;
                    if (block != Blocks.field_150350_a) {
                        this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(i, j, k), d3, (double)j + 1.125, d4, d5 * 10.0, 0.0, d6 * 10.0);
                    }
                }
                ++i1;
            }
        }
    }
}

